/*
 * Decompiled with CFR 0.152.
 */
package org.avis.router;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.SSLFilter;
import org.avis.io.TLS;
import org.avis.logging.Log;
import org.avis.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityFilter
implements IoFilter {
    private KeyStore keystore;
    private String keystorePassphrase;
    private Filter<InetAddress> authRequired;
    private boolean clientMode;

    public SecurityFilter(KeyStore keystore, String keystorePassphrase, Filter<InetAddress> authRequired, boolean clientMode) {
        this.keystore = keystore;
        this.keystorePassphrase = keystorePassphrase;
        this.authRequired = authRequired;
        this.clientMode = clientMode;
    }

    private SSLFilter ssfFilterFor(IoSession session) throws Exception {
        SSLFilter filter = (SSLFilter)session.getAttribute("securityFilterSSL");
        if (filter == null) {
            InetAddress address = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
            boolean needAuth = this.authRequired.matches(address);
            Log.diagnostic("Host " + address + " connecting via TLS " + (needAuth ? "needs authentication" : "does not require authentication"), this);
            filter = new SSLFilter(TLS.sslContextFor(this.keystore, this.keystorePassphrase, needAuth));
            filter.setUseClientMode(this.clientMode);
            filter.setNeedClientAuth(needAuth);
            session.setAttribute("securityFilterSSL", filter);
        }
        return filter;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void destroy() throws Exception {
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.ssfFilterFor(session).sessionCreated(nextFilter, session);
    }

    @Override
    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        this.ssfFilterFor(session).exceptionCaught(nextFilter, session, cause);
    }

    @Override
    public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.ssfFilterFor(session).filterClose(nextFilter, session);
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws Exception {
        this.ssfFilterFor(session).filterWrite(nextFilter, session, writeRequest);
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.ssfFilterFor(session).messageReceived(nextFilter, session, message);
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.ssfFilterFor(session).messageSent(nextFilter, session, message);
    }

    @Override
    public void onPostAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.ssfFilterFor(parent.getSession()).onPostAdd(parent, name, nextFilter);
    }

    @Override
    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.ssfFilterFor(parent.getSession()).onPostRemove(parent, name, nextFilter);
    }

    @Override
    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.ssfFilterFor(parent.getSession()).onPreAdd(parent, name, nextFilter);
    }

    @Override
    public void onPreRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.ssfFilterFor(parent.getSession()).onPreRemove(parent, name, nextFilter);
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.ssfFilterFor(session).sessionClosed(nextFilter, session);
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        this.ssfFilterFor(session).sessionIdle(nextFilter, session, status);
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.ssfFilterFor(session).sessionOpened(nextFilter, session);
    }
}

