/*
 * Decompiled with CFR 0.152.
 */
package org.avis.router;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.filter.ReadThrottleFilterBuilder;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.avis.common.ElvinURI;
import org.avis.config.Options;
import org.avis.io.ClientFrameCodec;
import org.avis.io.ExceptionMonitorLogger;
import org.avis.io.FrameCodec;
import org.avis.io.FrameTooLargeException;
import org.avis.io.LegacyConnectionOptions;
import org.avis.io.Net;
import org.avis.io.TLS;
import org.avis.io.messages.ConfConn;
import org.avis.io.messages.ConnRply;
import org.avis.io.messages.ConnRqst;
import org.avis.io.messages.Disconn;
import org.avis.io.messages.DisconnRply;
import org.avis.io.messages.DisconnRqst;
import org.avis.io.messages.ErrorMessage;
import org.avis.io.messages.Message;
import org.avis.io.messages.Nack;
import org.avis.io.messages.Notify;
import org.avis.io.messages.NotifyDeliver;
import org.avis.io.messages.NotifyEmit;
import org.avis.io.messages.QuenchPlaceHolder;
import org.avis.io.messages.SecRply;
import org.avis.io.messages.SecRqst;
import org.avis.io.messages.SubAddRqst;
import org.avis.io.messages.SubDelRqst;
import org.avis.io.messages.SubModRqst;
import org.avis.io.messages.SubRply;
import org.avis.io.messages.UNotify;
import org.avis.io.messages.XidMessage;
import org.avis.logging.Log;
import org.avis.router.BlacklistFilter;
import org.avis.router.CloseListener;
import org.avis.router.Connection;
import org.avis.router.ConnectionOptionSet;
import org.avis.router.InvalidSubscriptionException;
import org.avis.router.NoConnectionException;
import org.avis.router.NotifyListener;
import org.avis.router.RouterOptions;
import org.avis.router.SecurityFilter;
import org.avis.router.Subscription;
import org.avis.router.SubscriptionMatch;
import org.avis.security.Keys;
import org.avis.subscription.parser.ConstantExpressionException;
import org.avis.subscription.parser.ParseException;
import org.avis.subscription.parser.SubscriptionParserBase;
import org.avis.util.ConcurrentHashSet;
import org.avis.util.Filter;
import org.avis.util.IllegalConfigOptionException;
import org.avis.util.ListenerList;
import org.avis.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router
implements IoHandler,
Closeable {
    private static final String ROUTER_VERSION;
    private RouterOptions routerOptions;
    private ExecutorService executor;
    private SocketAcceptor acceptor;
    private KeyStore keystore;
    private volatile boolean closing;
    private ConcurrentHashSet<IoSession> sessions;
    private ListenerList<NotifyListener> notifyListeners = new ListenerList<NotifyListener>(NotifyListener.class, "notifyReceived", Notify.class, Keys.class);
    private ListenerList<CloseListener> closeListeners = new ListenerList<CloseListener>(CloseListener.class, "routerClosing", (Class<?>)Router.class);

    public Router() throws IOException {
        this(2917);
    }

    public Router(int port) throws IOException {
        this(new RouterOptions(port));
    }

    public Router(RouterOptions options) throws IOException, IllegalConfigOptionException {
        this.routerOptions = options;
        this.sessions = new ConcurrentHashSet();
        this.executor = Executors.newCachedThreadPool();
        this.acceptor = new SocketAcceptor(Runtime.getRuntime().availableProcessors() + 1, this.executor);
        ByteBuffer.setUseDirectBuffers(options.getBoolean("IO.Use-Direct-Buffers"));
        DefaultIoFilterChainBuilder filters = new DefaultIoFilterChainBuilder();
        filters.addLast("codec", ClientFrameCodec.FILTER);
        filters.addLast("threadPool", new ExecutorFilter(this.executor));
        this.bind(options.listenURIs(), this, filters, (Filter)this.routerOptions.get("Require-Authenticated"));
    }

    public void bind(Set<? extends ElvinURI> uris, IoHandler handler, DefaultIoFilterChainBuilder baseFilters, Filter<InetAddress> authRequired) throws IOException {
        SocketAcceptorConfig defaultAcceptorConfig = this.createAcceptorConfig(this.createStandardFilters(baseFilters, authRequired));
        SocketAcceptorConfig secureAcceptorConfig = null;
        for (ElvinURI elvinURI : uris) {
            SocketAcceptorConfig bindConfig;
            if (elvinURI.isSecure()) {
                if (secureAcceptorConfig == null) {
                    secureAcceptorConfig = this.createAcceptorConfig(this.createSecureFilters(baseFilters, authRequired, false));
                }
                bindConfig = secureAcceptorConfig;
            } else {
                bindConfig = defaultAcceptorConfig;
            }
            for (InetSocketAddress address : Net.addressesFor(elvinURI)) {
                this.acceptor.bind(address, handler, bindConfig);
            }
        }
    }

    private SocketAcceptorConfig createAcceptorConfig(DefaultIoFilterChainBuilder filters) {
        SocketAcceptorConfig defaultAcceptorConfig = new SocketAcceptorConfig();
        defaultAcceptorConfig.setReuseAddress(true);
        defaultAcceptorConfig.setThreadModel(ThreadModel.MANUAL);
        defaultAcceptorConfig.setFilterChainBuilder(filters);
        return defaultAcceptorConfig;
    }

    public DefaultIoFilterChainBuilder createStandardFilters(DefaultIoFilterChainBuilder commonFilters, Filter<InetAddress> authRequired) {
        if (authRequired != Filter.MATCH_NONE) {
            commonFilters = (DefaultIoFilterChainBuilder)commonFilters.clone();
            commonFilters.addFirst("blacklist", new BlacklistFilter(authRequired));
        }
        return commonFilters;
    }

    public DefaultIoFilterChainBuilder createSecureFilters(DefaultIoFilterChainBuilder commonFilters, Filter<InetAddress> authRequired, boolean clientMode) throws IOException {
        DefaultIoFilterChainBuilder secureFilters = (DefaultIoFilterChainBuilder)commonFilters.clone();
        secureFilters.addFirst("security", new SecurityFilter(this.keystore(), this.routerOptions.getString("TLS.Keystore-Passphrase"), authRequired, clientMode));
        return secureFilters;
    }

    private KeyStore keystore() throws IOException {
        if (this.keystore == null) {
            URI keystoreUri = (URI)this.routerOptions.get("TLS.Keystore");
            if (keystoreUri.toString().length() == 0) {
                throw new IOException("Cannot use TLS without a keystore: see TLS.Keystore configuration option");
            }
            InputStream keystoreStream = this.routerOptions.toAbsoluteURI(keystoreUri).toURL().openStream();
            try {
                this.keystore = KeyStore.getInstance("JKS");
                this.keystore.load(keystoreStream, TLS.toPassphrase(this.routerOptions.getString("TLS.Keystore-Passphrase")));
            }
            catch (GeneralSecurityException ex) {
                throw new IOException("Failed to load TLS keystore: " + ex.getMessage());
            }
            finally {
                keystoreStream.close();
            }
        }
        return this.keystore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Router router = this;
        synchronized (router) {
            if (this.closing) {
                return;
            }
            this.closing = true;
        }
        this.closeListeners.fire((Object)this);
        this.closeListeners = null;
        Disconn disconnMessage = new Disconn(1);
        for (IoSession session : this.sessions) {
            Connection connection = Router.peekConnectionFor(session);
            session.suspendRead();
            if (connection == null) continue;
            connection.lockWrite();
            try {
                if (!connection.isOpen()) continue;
                Router.send(session, disconnMessage).addListener(IoFutureListener.CLOSE);
                connection.close();
            }
            finally {
                connection.unlockWrite();
            }
        }
        this.waitForAllSessionsClosed();
        this.acceptor.unbindAll();
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(15L, TimeUnit.SECONDS)) {
                Log.warn("Failed to cleanly shut down thread pool", this);
            }
        }
        catch (InterruptedException ex) {
            Log.diagnostic("Interrupted while waiting for shutdown", this, ex);
        }
    }

    private void waitForAllSessionsClosed() {
        long finish = System.currentTimeMillis() + 20000L;
        try {
            while (!this.sessions.isEmpty() && System.currentTimeMillis() < finish) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (!this.sessions.isEmpty()) {
            Log.warn("Sessions took too long to close (" + this.sessions.size() + " still open", this);
        }
        this.sessions.clear();
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public SocketAcceptor socketAcceptor() {
        return this.acceptor;
    }

    public Set<ElvinURI> listenURIs() {
        return this.routerOptions.listenURIs();
    }

    public Options options() {
        return this.routerOptions;
    }

    public void testSimulateHang() {
        this.closing = true;
    }

    public void testSimulateUnhang() {
        this.closing = false;
    }

    public void addCloseListener(CloseListener listener) {
        this.closeListeners.add(listener);
    }

    public void removeCloseListener(CloseListener listener) {
        this.closeListeners.remove(listener);
    }

    public List<CloseListener> closeListeners() {
        return this.closeListeners.asList();
    }

    public void addNotifyListener(NotifyListener listener) {
        this.notifyListeners.add(listener);
    }

    public void removeNotifyListener(NotifyListener listener) {
        this.notifyListeners.remove(listener);
    }

    @Override
    public void messageReceived(IoSession session, Object messageObject) throws Exception {
        if (this.closing) {
            return;
        }
        if (Log.shouldLog(0)) {
            Log.trace("Server got message from " + Text.idFor(session) + ": " + messageObject, this);
        }
        Message message = (Message)messageObject;
        try {
            switch (message.typeId()) {
                case 49: {
                    this.handleConnRqst(session, (ConnRqst)message);
                    break;
                }
                case 51: {
                    this.handleDisconnRqst(session, (DisconnRqst)message);
                    break;
                }
                case 58: {
                    this.handleSubAddRqst(session, (SubAddRqst)message);
                    break;
                }
                case 59: {
                    this.handleSubModRqst(session, (SubModRqst)message);
                    break;
                }
                case 60: {
                    this.handleSubDelRqst(session, (SubDelRqst)message);
                    break;
                }
                case 56: {
                    this.handleNotifyEmit(session, (NotifyEmit)message);
                    break;
                }
                case 54: {
                    this.handleSecRqst(session, (SecRqst)message);
                    break;
                }
                case 63: {
                    Router.handleTestConn(session);
                    break;
                }
                case 32: {
                    this.handleUnotify((UNotify)message);
                    break;
                }
                case -1: {
                    Router.handleError(session, (ErrorMessage)message);
                    break;
                }
                case -2: {
                    Router.handleQuench(session, (QuenchPlaceHolder)message);
                    break;
                }
                default: {
                    Log.warn("Server got an unhandleable message type: " + message, this);
                    break;
                }
            }
        }
        catch (ProtocolCodecException ex) {
            Router.disconnectProtocolViolation(session, message, ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnRqst(IoSession session, ConnRqst message) throws ProtocolCodecException {
        if (Router.peekConnectionFor(session) != null) {
            throw new ProtocolCodecException("Already connected");
        }
        Connection connection = new Connection(this.routerOptions, message.options, message.subscriptionKeys, message.notificationKeys);
        int maxKeys = connection.options.getInt("Connection.Max-Keys");
        if (message.versionMajor != 4 || message.versionMinor > 0) {
            Router.send(session, new Nack(message, 1, "Max supported protocol version is 4.0: use a connection URI like elvin:4.0//hostname to specify protocol version"));
        } else if (message.notificationKeys.size() > maxKeys || message.subscriptionKeys.size() > maxKeys) {
            Router.nackLimit(session, message, "Too many keys");
        } else {
            Router.updateTcpSendImmediately(session, connection.options);
            Router.updateQueueLength(session, connection);
            Map<String, Object> options = connection.options.accepted();
            LegacyConnectionOptions.setWithLegacy(options, "Vendor-Identification", "Avis " + ROUTER_VERSION);
            connection.lockWrite();
            try {
                Router.setConnection(session, connection);
                Router.send(session, new ConnRply(message, options));
            }
            finally {
                connection.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSecRqst(IoSession session, SecRqst message) throws NoConnectionException {
        Connection connection = Router.writeableConnectionFor(session);
        try {
            Keys newNtfnKeys = connection.notificationKeys.delta(message.addNtfnKeys, message.delNtfnKeys);
            Keys newSubKeys = connection.subscriptionKeys.delta(message.addSubKeys, message.delSubKeys);
            if (connection.connectionKeysFull(newNtfnKeys, newSubKeys)) {
                Router.nackLimit(session, message, "Too many keys");
            } else {
                connection.notificationKeys = newNtfnKeys;
                connection.subscriptionKeys = newSubKeys;
                Router.send(session, new SecRply(message));
            }
        }
        finally {
            connection.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisconnRqst(IoSession session, DisconnRqst message) throws NoConnectionException {
        Connection connection = Router.writeableConnectionFor(session);
        try {
            connection.close();
            Router.send(session, new DisconnRply(message)).addListener(IoFutureListener.CLOSE);
        }
        finally {
            connection.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubAddRqst(IoSession session, SubAddRqst message) throws NoConnectionException {
        Connection connection = Router.writeableConnectionFor(session);
        try {
            if (connection.subscriptionsFull()) {
                Router.nackLimit(session, message, "Too many subscriptions");
            } else if (connection.subscriptionTooLong(message.subscriptionExpr)) {
                Router.nackLimit(session, message, "Subscription too long");
            } else if (connection.subscriptionKeysFull(message.keys)) {
                Router.nackLimit(session, message, "Too many keys");
            } else {
                Subscription subscription = new Subscription(message.subscriptionExpr, message.keys, message.acceptInsecure);
                connection.addSubscription(subscription);
                Router.send(session, new SubRply(message, subscription.id));
            }
        }
        catch (ParseException ex) {
            Router.nackParseError(session, message, message.subscriptionExpr, ex);
        }
        finally {
            connection.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubModRqst(IoSession session, SubModRqst message) throws NoConnectionException {
        Connection connection = Router.writeableConnectionFor(session);
        try {
            Subscription subscription = connection.subscriptionFor(message.subscriptionId);
            Keys newKeys = subscription.keys.delta(message.addKeys, message.delKeys);
            if (connection.subscriptionKeysFull(newKeys)) {
                Router.nackLimit(session, message, "Too many keys");
            } else if (connection.subscriptionTooLong(message.subscriptionExpr)) {
                Router.nackLimit(session, message, "Subscription too long");
            } else {
                if (message.subscriptionExpr.length() > 0) {
                    subscription.updateExpression(message.subscriptionExpr);
                }
                subscription.keys = newKeys;
                subscription.acceptInsecure = message.acceptInsecure;
                Router.send(session, new SubRply(message, subscription.id));
            }
        }
        catch (ParseException ex) {
            Router.nackParseError(session, message, message.subscriptionExpr, ex);
        }
        catch (InvalidSubscriptionException ex) {
            Router.nackNoSub(session, message, message.subscriptionId, ex.getMessage());
        }
        finally {
            connection.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubDelRqst(IoSession session, SubDelRqst message) throws NoConnectionException {
        Connection connection = Router.writeableConnectionFor(session);
        try {
            if (connection.removeSubscription(message.subscriptionId) != null) {
                Router.send(session, new SubRply(message, message.subscriptionId));
            } else {
                Router.nackNoSub(session, message, message.subscriptionId, "Invalid subscription ID");
            }
        }
        finally {
            connection.unlockWrite();
        }
    }

    private void handleNotifyEmit(IoSession session, NotifyEmit message) throws NoConnectionException {
        if (Log.shouldLog(0)) {
            this.logNotification(session, message);
        }
        this.deliverNotification(message, Router.connectionFor((IoSession)session).notificationKeys);
    }

    private void handleUnotify(UNotify message) {
        if (Log.shouldLog(0)) {
            this.logNotification(null, message);
        }
        this.deliverNotification(message, Keys.EMPTY_KEYS);
    }

    public void injectNotify(Notify message) {
        this.deliverNotification(message, Keys.EMPTY_KEYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverNotification(Notify message, Keys notificationKeys) {
        for (IoSession session : this.sessions) {
            Connection connection = Router.peekConnectionFor(session);
            if (connection == null) continue;
            connection.lockRead();
            try {
                SubscriptionMatch matches;
                if (!connection.isOpen() || !(matches = connection.matchSubscriptions(message.attributes, notificationKeys, message.keys, message.deliverInsecure)).matched()) continue;
                if (Log.shouldLog(0)) {
                    Log.trace("Delivering notification " + Text.idFor(message) + " to client " + Text.idFor(session), this);
                }
                Router.send(session, new NotifyDeliver(message.attributes, matches.secure(), matches.insecure()));
            }
            catch (RuntimeException ex) {
                Log.alarm("Exception while delivering notification", this, ex);
            }
            finally {
                connection.unlockRead();
            }
        }
        if (this.notifyListeners.hasListeners()) {
            this.notifyListeners.fire(message, notificationKeys);
        }
    }

    private static void handleTestConn(IoSession session) {
        if (session.getScheduledWriteRequests() == 0) {
            Router.send(session, ConfConn.INSTANCE);
        }
    }

    private static void handleQuench(IoSession session, QuenchPlaceHolder message) {
        Log.diagnostic("Rejecting quench request from client: quench is not supported", Router.class);
        Router.send(session, new Nack(message, 2007, "Quench not supported"));
    }

    private static void handleError(IoSession session, ErrorMessage errorMessage) {
        String message = errorMessage.error instanceof FrameTooLargeException ? errorMessage.error.getMessage() + ". Use the Packet.Max-Length connection option to increase the " + "maximum notification size." : errorMessage.error.getMessage();
        Router.disconnectProtocolViolation(session, errorMessage.cause, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disconnectProtocolViolation(IoSession session, Message cause, String diagnosticMessage, Throwable error) {
        Connection connection;
        if (diagnosticMessage == null) {
            diagnosticMessage = "Frame format error";
        }
        Log.warn("Disconnecting client due to protocol violation: " + diagnosticMessage, Router.class);
        if (error != null) {
            Log.diagnostic("Decode stack trace", Router.class, error);
        }
        if ((connection = Router.peekConnectionFor(session)) != null) {
            connection.lockWrite();
            try {
                connection.close();
            }
            finally {
                connection.unlockWrite();
            }
        }
        Router.send(session, new Disconn(4, diagnosticMessage)).addListener(IoFutureListener.CLOSE);
    }

    private static void updateTcpSendImmediately(IoSession session, Options options) {
        if (!Net.enableTcpNoDelay(session, options.getInt("TCP.Send-Immediately") != 0)) {
            options.remove("TCP.Send-Immediately");
        }
    }

    private static void updateQueueLength(IoSession session, Connection connection) {
        ReadThrottleFilterBuilder readThrottle = (ReadThrottleFilterBuilder)session.getAttribute("readThrottle");
        readThrottle.setMaximumConnectionBufferSize(connection.options.getInt("Receive-Queue.Max-Length"));
    }

    private static void nackParseError(IoSession session, XidMessage inReplyTo, String expr, ParseException ex) {
        String message;
        int code;
        Object[] args = Nack.EMPTY_ARGS;
        if (ex instanceof ConstantExpressionException) {
            code = 2110;
            message = ex.getMessage();
        } else {
            code = 2101;
            if (ex.currentToken == null) {
                message = ex.getMessage();
                args = new Object[]{0, ""};
            } else {
                args = new Object[]{ex.currentToken.next.beginColumn, ex.currentToken.next.image};
                message = "Parse error at column " + args[0] + ", token \"" + args[1] + "\": expected: " + SubscriptionParserBase.expectedTokensFor(ex);
            }
        }
        Log.diagnostic("Subscription add/modify failed with parse error: " + message, Router.class);
        Log.diagnostic("Subscription was: " + expr, Router.class);
        Router.send(session, new Nack(inReplyTo, code, message, args));
    }

    private static void nackLimit(IoSession session, XidMessage inReplyTo, String message) {
        Router.send(session, new Nack(inReplyTo, 2006, message));
    }

    private static void nackNoSub(IoSession session, XidMessage inReplyTo, long subscriptionId, String message) {
        Router.send(session, new Nack(inReplyTo, 1002, message, subscriptionId));
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable ex) throws Exception {
        if (ex instanceof IOException) {
            Log.diagnostic("IO exception while processing message", this, ex);
        } else {
            Log.alarm("Server exception", this, ex);
        }
    }

    @Override
    public void messageSent(IoSession session, Object message) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionClosed(IoSession session) throws Exception {
        if (Log.shouldLog(0)) {
            Log.trace("Server session " + Text.idFor(session) + " closed", this);
        }
        this.sessions.remove(session);
        Connection connection = Router.peekConnectionFor(session);
        if (connection != null) {
            connection.lockWrite();
            try {
                if (connection.isOpen()) {
                    Log.diagnostic("Client disconnected without warning", this);
                    connection.close();
                }
            }
            finally {
                connection.unlockWrite();
            }
        }
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        session.setIdleTime(IdleStatus.READER_IDLE, this.routerOptions.getInt("IO.Idle-Connection-Timeout"));
        ReadThrottleFilterBuilder readThrottle = new ReadThrottleFilterBuilder();
        readThrottle.setMaximumConnectionBufferSize(ConnectionOptionSet.CONNECTION_OPTION_SET.defaults.getInt("Receive-Queue.Max-Length"));
        readThrottle.attach(session.getFilterChain());
        session.setAttribute("readThrottle", readThrottle);
        FrameCodec.setMaxFrameLengthFor(session, ConnectionOptionSet.CONNECTION_OPTION_SET.defaults.getInt("Packet.Max-Length"));
        this.sessions.add(session);
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        if (status == IdleStatus.READER_IDLE && Router.peekConnectionFor(session) == null) {
            Log.diagnostic("Client " + Text.idFor(session) + " waited too long to connect: closing session", this);
            session.close();
        }
    }

    @Override
    public void sessionOpened(IoSession session) throws Exception {
        Log.diagnostic("Server session " + Text.idFor(session) + " opened for connection on " + session.getServiceAddress() + (Router.isSecure(session) ? " (using TLS)" : ""), this);
    }

    private static void setConnection(IoSession session, Connection connection) {
        session.setAttachment(connection);
        FrameCodec.setMaxFrameLengthFor(session, connection.options.getInt("Packet.Max-Length"));
    }

    private static Connection connectionFor(IoSession session) throws NoConnectionException {
        Connection connection = (Connection)session.getAttachment();
        if (connection == null) {
            throw new NoConnectionException("No connection established for session");
        }
        if (!connection.isOpen()) {
            throw new NoConnectionException("Connection is closed");
        }
        return connection;
    }

    private static Connection writeableConnectionFor(IoSession session) throws NoConnectionException {
        Connection connection = Router.connectionFor(session);
        connection.lockWrite();
        if (!connection.isOpen()) {
            connection.unlockWrite();
            throw new NoConnectionException("Connection is closed");
        }
        return connection;
    }

    private static WriteFuture send(IoSession session, Message message) {
        if (Log.shouldLog(0)) {
            Log.trace("Server sent message to " + Text.idFor(session) + ": " + message, Router.class);
        }
        return session.write(message);
    }

    private void logNotification(IoSession session, Notify message) {
        Log.trace("Notification " + Text.idFor(message) + " from client " + Text.idFor(session) + ":\n" + Text.formatNotification(message.attributes), this);
    }

    private static Connection peekConnectionFor(IoSession session) {
        return (Connection)session.getAttachment();
    }

    public static boolean isSecure(IoSession session) {
        return session.getServiceConfig().getFilterChain().contains(SecurityFilter.class);
    }

    static {
        ExceptionMonitor.setInstance(ExceptionMonitorLogger.INSTANCE);
        ROUTER_VERSION = System.getProperty("avis.router.version", "<unknown>");
    }
}

