/*
 * Decompiled with CFR 0.152.
 */
package org.avis.router;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import org.avis.common.ElvinURI;
import org.avis.federation.EwafURI;
import org.avis.federation.FederationManager;
import org.avis.federation.FederationOptionSet;
import org.avis.io.Net;
import org.avis.logging.Log;
import org.avis.router.Router;
import org.avis.router.RouterOptionSet;
import org.avis.router.RouterOptions;
import org.avis.util.CommandLine;
import org.avis.util.IllegalCommandLineOption;
import org.avis.util.IllegalConfigOptionException;
import org.avis.util.Streams;

public class Main {
    private static final String USAGE = "Usage: avisd [-h] [-v] [-vv] [-p port] [-c file]\n\n -h         : This text\n -v and -vv : Increase verbosity\n -p port    : Set port to listen on\n -c file    : Load config from file\n";

    public static void main(String[] args) throws Exception {
        Log.setApplicationName("Avis");
        Log.enableLogging(0, false);
        Log.enableLogging(1, false);
        Properties avisProperties = Main.readAvisProperties();
        System.getProperties().putAll((Map<?, ?>)avisProperties);
        Log.info("Avis event router version " + avisProperties.getProperty("avis.router.version"), Main.class);
        try {
            final Router router = Main.start(args);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Log.info("Shutting down...", Main.class);
                    router.close();
                }
            });
            for (ElvinURI elvinURI : router.listenURIs()) {
                for (InetSocketAddress address : Net.addressesFor(elvinURI)) {
                    Log.info("Router listening on " + address + " (" + elvinURI + ")", Main.class);
                }
            }
            if (router.options().getBoolean("Federation.Activated")) {
                for (EwafURI ewafURI : FederationManager.federationManagerFor(router).listenURIs()) {
                    for (InetSocketAddress address : Net.addressesFor(ewafURI)) {
                        Log.info("Federator listening on " + address + " (" + ewafURI + ")", Main.class);
                    }
                }
            }
        }
        catch (Throwable ex) {
            if (ex instanceof IllegalArgumentException) {
                if (ex instanceof IllegalCommandLineOption) {
                    Log.alarm(ex.getMessage(), Main.class);
                    System.err.println();
                    System.err.println(USAGE);
                } else {
                    Log.alarm("Error in router configuration: " + ex.getMessage(), Main.class);
                }
                Main.exit(1);
            }
            Log.alarm("Error starting router: " + ex.getMessage(), Main.class);
            if (Log.shouldLog(1)) {
                ex.printStackTrace();
            }
            Main.exit(2);
        }
    }

    public static Router start(String ... args) throws IllegalConfigOptionException, IOException {
        RouterOptionSet routerOptionSet = new RouterOptionSet();
        routerOptionSet.inheritFrom(FederationOptionSet.OPTION_SET);
        RouterOptions config = new RouterOptions(routerOptionSet);
        Main.parseCommandLine(args, config);
        Router router = new Router(config);
        if (config.getBoolean("Federation.Activated")) {
            new FederationManager(router, config);
        }
        return router;
    }

    private static void parseCommandLine(String[] args, RouterOptions config) throws IllegalConfigOptionException, IllegalCommandLineOption {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            try {
                if (arg.equals("-v")) {
                    Log.enableLogging(1, true);
                    continue;
                }
                if (arg.equals("-vv")) {
                    Log.enableLogging(1, true);
                    Log.enableLogging(0, true);
                    continue;
                }
                if (arg.equals("-p")) {
                    config.set("Port", CommandLine.intArg(args, ++i));
                    continue;
                }
                if (arg.equals("-c")) {
                    File configFile = new File(CommandLine.stringArg(args, ++i)).getAbsoluteFile();
                    config.setAll(Streams.propertiesFrom(Streams.fileStream(configFile)));
                    config.setRelativeDirectory(configFile.getParentFile());
                    Log.diagnostic("Read configuration from " + configFile, Main.class);
                    continue;
                }
                throw new IllegalCommandLineOption("Unknown command line option: \"" + arg + "\"");
            }
            catch (IOException ex) {
                throw new IllegalCommandLineOption("Error in command line option: \"" + arg + "\": " + ex.getMessage());
            }
        }
    }

    private static void exit(int errorCode) {
        Log.info("Exiting on error", Main.class);
        System.exit(errorCode);
    }

    private static Properties readAvisProperties() throws IOException {
        Properties properties;
        try {
            properties = Streams.propertiesFrom(Streams.resourceStream("/avis.properties"));
        }
        catch (IOException ex) {
            Log.warn("Failed to load Avis property file: " + ex.getMessage(), Main.class);
            properties = new Properties();
        }
        if (!properties.containsKey("avis.router.version")) {
            properties.put("avis.router.version", "<unknown>");
        }
        return properties;
    }
}

