/*
 * Decompiled with CFR 0.152.
 */
package org.avis.logging;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.avis.logging.LogEvent;
import org.avis.logging.LogListener;
import org.avis.util.ListenerList;

public final class Log {
    public static final int TRACE = 0;
    public static final int DIAGNOSTIC = 1;
    public static final int INFO = 2;
    public static final int WARNING = 3;
    public static final int ALARM = 4;
    public static final int INTERNAL_ERROR = 5;
    private static final String[] TYPE_NAMES = new String[]{"Trace", "Diagnostic", "Info", "Warning", "Alarm", "Internal Error"};
    private static final ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("MMM dd HH:mm:ss");
        }
    };
    private static String applicationName;
    private static PrintWriter stdout;
    private static PrintWriter stderr;
    private static boolean[] enabledTypes;
    private static ListenerList<LogListener> listeners;

    private Log() {
    }

    public static void enableLogging(int type, boolean isEnabled) {
        Log.enabledTypes[type] = isEnabled;
    }

    public static void logAll() {
        for (int i = 0; i < enabledTypes.length; ++i) {
            Log.enabledTypes[i] = true;
        }
    }

    public static void logNone() {
        for (int i = 0; i < enabledTypes.length; ++i) {
            Log.enabledTypes[i] = false;
        }
    }

    public static boolean shouldLog(int type) {
        return enabledTypes[type];
    }

    public static void setApplicationName(String name) {
        applicationName = name;
    }

    public static String applicationName() {
        return applicationName;
    }

    public static void trace(String message, Object source) {
        Log.log(0, message, source);
    }

    public static void info(String message, Object source) {
        Log.log(2, message, source);
    }

    public static void diagnostic(String message, Object source) {
        Log.log(1, message, source);
    }

    public static void diagnostic(String message, Object source, Throwable ex) {
        Log.log(1, message, source, ex);
    }

    public static void alarm(String message, Object source) {
        Log.log(4, message, source);
    }

    public static void alarm(String message, Object source, Throwable ex) {
        Log.log(4, message, source, ex);
    }

    public static void warn(String message, Object source) {
        Log.log(3, message, source);
    }

    public static void warn(String message, Object source, Throwable ex) {
        Log.log(3, message, source, ex);
    }

    public static void internalError(String message, Object source) {
        Log.log(5, message, source);
    }

    public static void internalError(String message, Object source, Throwable ex) {
        Log.log(5, message, source, ex);
    }

    private static void log(int type, String message, Object source) {
        Log.log(type, message, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(int type, String message, Object source, Throwable exception) {
        if (Log.shouldLog(type)) {
            Date time = new Date();
            StringBuilder str = new StringBuilder();
            Log.printMessage(str, type, time, message, exception);
            PrintWriter output = type >= 3 ? stderr : stdout;
            output.println(str);
            if (exception != null) {
                output.println("Exception trace:");
                Log.printExceptionTrace(output, exception);
            }
            output.flush();
        }
        ListenerList<LogListener> listenerList = listeners;
        synchronized (listenerList) {
            if (listeners.hasListeners()) {
                listeners.fire((Object)new LogEvent(source, new Date(), type, message, exception));
            }
        }
    }

    private static void printMessage(StringBuilder str, int type, Date time, String messageStr, Throwable exception) {
        str.append(dateFormat.get().format(time));
        if (applicationName != null) {
            str.append(": ").append(applicationName);
        }
        str.append(": ").append(TYPE_NAMES[type]);
        str.append(": ").append(messageStr);
        if (exception != null && exception.getMessage() != null) {
            str.append(": " + exception.getMessage());
        }
    }

    private static void printExceptionTrace(PrintWriter str, Throwable exception) {
        exception.printStackTrace(str);
        Throwable legacyNestedException = Log.legacyNestedException(exception);
        if (legacyNestedException != null) {
            str.println("--------------------");
            str.println("Nested exception:");
            Log.printExceptionTrace(str, legacyNestedException);
        }
    }

    private static Throwable legacyNestedException(Throwable exception) {
        if (exception instanceof SQLException) {
            return ((SQLException)exception).getNextException();
        }
        if (exception instanceof InvocationTargetException) {
            return ((InvocationTargetException)exception).getTargetException();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogListener(LogListener listener) {
        ListenerList<LogListener> listenerList = listeners;
        synchronized (listenerList) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLogListener(LogListener listener) {
        ListenerList<LogListener> listenerList = listeners;
        synchronized (listenerList) {
            listeners.remove(listener);
        }
    }

    public static String toLogString(LogEvent e) {
        StringBuilder str = new StringBuilder();
        Log.printMessage(str, e.type, e.time, e.message, e.exception);
        return str.toString();
    }

    static {
        stdout = new PrintWriter(System.out);
        stderr = new PrintWriter(System.err);
        listeners = new ListenerList<LogListener>(LogListener.class, "messageLogged", (Class<?>)LogEvent.class);
        enabledTypes = new boolean[6];
        Log.logAll();
        Log.enableLogging(0, false);
        Log.enableLogging(1, false);
    }
}

