/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io.messages;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.avis.io.messages.Message;
import org.avis.io.messages.RequestMessage;

public abstract class XidMessage
extends Message {
    private static final AtomicInteger xidCounter = new AtomicInteger();
    public int xid;
    public transient RequestMessage<?> request;

    public XidMessage() {
        this.xid = -1;
    }

    public XidMessage(XidMessage inReplyTo) {
        this(inReplyTo.xid);
    }

    public XidMessage(int xid) {
        if (xid <= 0) {
            throw new IllegalArgumentException("Invalid XID: " + xid);
        }
        this.xid = xid;
    }

    public boolean hasValidXid() {
        return this.xid > 0;
    }

    public void decode(ByteBuffer in) throws ProtocolCodecException {
        this.xid = in.getInt();
        if (this.xid <= 0) {
            throw new ProtocolCodecException("XID must be >= 0: " + this.xid);
        }
    }

    public void encode(ByteBuffer out) throws ProtocolCodecException {
        if (this.xid == -1) {
            throw new ProtocolCodecException("No XID");
        }
        out.putInt(this.xid);
    }

    protected static int nextXid() {
        return xidCounter.incrementAndGet();
    }
}

