/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io.messages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.avis.io.XdrCoding;
import org.avis.io.messages.Message;
import org.avis.security.Keys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Notify
extends Message {
    public Map<String, Object> attributes;
    public boolean deliverInsecure;
    public Keys keys;

    protected Notify() {
        this.attributes = Collections.emptyMap();
        this.deliverInsecure = true;
        this.keys = Keys.EMPTY_KEYS;
    }

    protected Notify(Object ... attributes) {
        this(Notify.asAttributes(attributes), true, Keys.EMPTY_KEYS);
    }

    protected Notify(Map<String, Object> attributes, boolean deliverInsecure, Keys keys) {
        this.attributes = attributes;
        this.deliverInsecure = deliverInsecure;
        this.keys = keys;
    }

    @Override
    public void decode(ByteBuffer in) throws ProtocolCodecException {
        this.attributes = XdrCoding.getNameValues(in);
        this.deliverInsecure = XdrCoding.getBool(in);
        this.keys = Keys.decode(in);
    }

    @Override
    public void encode(ByteBuffer out) throws ProtocolCodecException {
        XdrCoding.putNameValues(out, this.attributes);
        XdrCoding.putBool(out, this.deliverInsecure);
        this.keys.encode(out);
    }

    public static Map<String, Object> asAttributes(Object ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Items must be a set of pairs");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < pairs.length; i += 2) {
            map.put((String)pairs[i], pairs[i + 1]);
        }
        return Collections.unmodifiableMap(map);
    }
}

