/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io.messages;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.avis.io.XdrCoding;
import org.avis.io.messages.Message;

public class Disconn
extends Message {
    public static final int ID = 53;
    public static final int REASON_SHUTDOWN = 1;
    public static final int REASON_SHUTDOWN_REDIRECT = 2;
    public static final int REASON_PROTOCOL_VIOLATION = 4;
    public int reason;
    public String args;

    public Disconn() {
        this(-1, "");
    }

    public Disconn(int reason) {
        this(reason, "");
    }

    public Disconn(int reason, String args) {
        this.reason = reason;
        this.args = args;
    }

    public int typeId() {
        return 53;
    }

    public boolean hasArgs() {
        return this.args.length() > 0;
    }

    public void decode(ByteBuffer in) throws ProtocolCodecException {
        this.reason = in.getInt();
        this.args = XdrCoding.getString(in);
    }

    public void encode(ByteBuffer out) throws ProtocolCodecException {
        if (this.reason == -1) {
            throw new ProtocolCodecException("Reason not set");
        }
        out.putInt(this.reason);
        XdrCoding.putString(out, this.args);
    }
}

