/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io.messages;

import java.util.Collections;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.avis.io.XdrCoding;
import org.avis.io.messages.ConnRply;
import org.avis.io.messages.RequestMessage;
import org.avis.security.Keys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnRqst
extends RequestMessage<ConnRply> {
    public static final Map<String, Object> EMPTY_OPTIONS = Collections.emptyMap();
    public static final int ID = 49;
    public int versionMajor;
    public int versionMinor;
    public Map<String, Object> options;
    public Keys notificationKeys;
    public Keys subscriptionKeys;

    public ConnRqst() {
    }

    public ConnRqst(int major, int minor) {
        this(major, minor, EMPTY_OPTIONS, Keys.EMPTY_KEYS, Keys.EMPTY_KEYS);
    }

    public ConnRqst(int major, int minor, Map<String, Object> options, Keys notificationKeys, Keys subscriptionKeys) {
        super(ConnRqst.nextXid());
        this.versionMajor = major;
        this.versionMinor = minor;
        this.options = options;
        this.notificationKeys = notificationKeys;
        this.subscriptionKeys = subscriptionKeys;
    }

    @Override
    public int typeId() {
        return 49;
    }

    @Override
    public Class<ConnRply> replyType() {
        return ConnRply.class;
    }

    @Override
    public void encode(ByteBuffer out) throws ProtocolCodecException {
        super.encode(out);
        out.putInt(this.versionMajor);
        out.putInt(this.versionMinor);
        XdrCoding.putNameValues(out, this.options);
        this.notificationKeys.encode(out);
        this.subscriptionKeys.encode(out);
    }

    @Override
    public void decode(ByteBuffer in) throws ProtocolCodecException {
        super.decode(in);
        this.versionMajor = in.getInt();
        this.versionMinor = in.getInt();
        this.options = XdrCoding.getNameValues(in);
        this.notificationKeys = Keys.decode(in);
        this.subscriptionKeys = Keys.decode(in);
    }
}

