/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io;

import java.nio.BufferUnderflowException;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.filter.codec.ProtocolCodecException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XdrCoding {
    public static final int TYPE_INT32 = 1;
    public static final int TYPE_INT64 = 2;
    public static final int TYPE_REAL64 = 3;
    public static final int TYPE_STRING = 4;
    public static final int TYPE_OPAQUE = 5;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final ThreadLocal<CharsetDecoder> UTF8_DECODER = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return Charset.forName("UTF-8").newDecoder();
        }
    };
    private static final ThreadLocal<CharsetEncoder> UTF8_ENCODER = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Charset.forName("UTF-8").newEncoder();
        }
    };

    private XdrCoding() {
    }

    public static byte[] toUTF8(String string) {
        try {
            if (string.length() == 0) {
                return EMPTY_BYTES;
            }
            return UTF8_ENCODER.get().encode(CharBuffer.wrap(string)).array();
        }
        catch (CharacterCodingException ex) {
            throw new Error("Internal error", ex);
        }
    }

    public static String fromUTF8(byte[] utf8Bytes, int offset, int length) throws CharacterCodingException {
        if (utf8Bytes.length == 0) {
            return "";
        }
        return UTF8_DECODER.get().decode(java.nio.ByteBuffer.wrap(utf8Bytes, offset, length)).toString();
    }

    public static String getString(ByteBuffer in) throws BufferUnderflowException, ProtocolCodecException {
        try {
            int length = XdrCoding.getPositiveInt(in);
            if (length == 0) {
                return "";
            }
            String string = in.getString(length, UTF8_DECODER.get());
            in.skip(XdrCoding.paddingFor(length));
            return string;
        }
        catch (CharacterCodingException ex) {
            throw new ProtocolCodecException("Invalid UTF-8 string", ex);
        }
    }

    public static void putString(ByteBuffer out, String string) {
        try {
            if (string.length() == 0) {
                out.putInt(0);
            } else {
                int start = out.position();
                out.skip(4);
                out.putString(string, UTF8_ENCODER.get());
                int byteCount = out.position() - start - 4;
                out.putInt(start, byteCount);
                XdrCoding.putPadding(out, byteCount);
            }
        }
        catch (CharacterCodingException ex) {
            throw new Error("Internal error", ex);
        }
    }

    public static void putPadding(ByteBuffer out, int length) {
        for (int count = XdrCoding.paddingFor(length); count > 0; --count) {
            out.put((byte)0);
        }
    }

    public static int paddingFor(int length) {
        return 4 - (length & 3) & 3;
    }

    public static void putNameValues(ByteBuffer out, Map<String, Object> nameValues) throws ProtocolCodecException {
        out.putInt(nameValues.size());
        for (Map.Entry<String, Object> entry : nameValues.entrySet()) {
            XdrCoding.putString(out, entry.getKey());
            XdrCoding.putObject(out, entry.getValue());
        }
    }

    public static Map<String, Object> getNameValues(ByteBuffer in) throws ProtocolCodecException {
        int pairs = XdrCoding.getPositiveInt(in);
        if (pairs == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nameValues = new HashMap<String, Object>();
        while (pairs > 0) {
            nameValues.put(XdrCoding.getString(in), XdrCoding.getObject(in));
            --pairs;
        }
        return nameValues;
    }

    public static void putObjects(ByteBuffer out, Object[] objects) throws ProtocolCodecException {
        out.putInt(objects.length);
        for (Object object : objects) {
            XdrCoding.putObject(out, object);
        }
    }

    public static Object[] getObjects(ByteBuffer in) throws ProtocolCodecException {
        Object[] objects = new Object[XdrCoding.getPositiveInt(in)];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = XdrCoding.getObject(in);
        }
        return objects;
    }

    public static void putObject(ByteBuffer out, Object value) throws ProtocolCodecException {
        if (value instanceof String) {
            out.putInt(4);
            XdrCoding.putString(out, (String)value);
        } else if (value instanceof Integer) {
            out.putInt(1);
            out.putInt((Integer)value);
        } else if (value instanceof Long) {
            out.putInt(2);
            out.putLong((Long)value);
        } else if (value instanceof Double) {
            out.putInt(3);
            out.putDouble((Double)value);
        } else if (value instanceof byte[]) {
            out.putInt(5);
            XdrCoding.putBytes(out, (byte[])value);
        } else {
            if (value == null) {
                throw new IllegalArgumentException("Value cannot be null");
            }
            throw new IllegalArgumentException("Don't know how to encode " + value.getClass());
        }
    }

    public static Object getObject(ByteBuffer in) throws ProtocolCodecException {
        int type = in.getInt();
        switch (type) {
            case 1: {
                return in.getInt();
            }
            case 2: {
                return in.getLong();
            }
            case 3: {
                return in.getDouble();
            }
            case 4: {
                return XdrCoding.getString(in);
            }
            case 5: {
                return XdrCoding.getBytes(in);
            }
        }
        throw new ProtocolCodecException("Unknown type code: " + type);
    }

    public static void putBytes(ByteBuffer out, byte[] bytes) {
        out.putInt(bytes.length);
        out.put(bytes);
        XdrCoding.putPadding(out, bytes.length);
    }

    public static byte[] getBytes(ByteBuffer in) throws ProtocolCodecException {
        return XdrCoding.getBytes(in, XdrCoding.getPositiveInt(in));
    }

    public static byte[] getBytes(ByteBuffer in, int length) {
        byte[] bytes = new byte[length];
        in.get(bytes);
        in.skip(XdrCoding.paddingFor(length));
        return bytes;
    }

    public static void putBool(ByteBuffer out, boolean value) {
        out.putInt(value ? 1 : 0);
    }

    public static boolean getBool(ByteBuffer in) throws ProtocolCodecException {
        int value = in.getInt();
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        throw new ProtocolCodecException("Cannot interpret " + value + " as boolean");
    }

    public static long[] getLongArray(ByteBuffer in) throws ProtocolCodecException {
        long[] longs = new long[XdrCoding.getPositiveInt(in)];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = in.getLong();
        }
        return longs;
    }

    public static void putLongArray(ByteBuffer out, long[] longs) {
        out.putInt(longs.length);
        for (long l : longs) {
            out.putLong(l);
        }
    }

    public static String[] getStringArray(ByteBuffer in) throws BufferUnderflowException, ProtocolCodecException {
        String[] strings = new String[XdrCoding.getPositiveInt(in)];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = XdrCoding.getString(in);
        }
        return strings;
    }

    public static void putStringArray(ByteBuffer out, String[] strings) {
        out.putInt(strings.length);
        for (String s : strings) {
            XdrCoding.putString(out, s);
        }
    }

    private static int getPositiveInt(ByteBuffer in) throws ProtocolCodecException {
        int value = in.getInt();
        if (value >= 0) {
            return value;
        }
        throw new ProtocolCodecException("Length cannot be negative: " + value);
    }
}

