/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.avis.io.SharedExecutor;
import org.avis.io.messages.ConfConn;
import org.avis.io.messages.LivenessFailureMessage;
import org.avis.io.messages.Message;
import org.avis.io.messages.TestConn;
import org.avis.logging.Log;

public class LivenessFilter
extends IoFilterAdapter
implements IoFilter {
    protected long receiveTimeout;
    protected long livenessTimeout;
    protected String filterName;
    protected ScheduledExecutorService executor;

    public LivenessFilter(long livenessTimeout, long receiveTimeout) {
        this(null, livenessTimeout, receiveTimeout);
    }

    public LivenessFilter(ScheduledExecutorService executor, long livenessTimeout, long receiveTimeout) {
        this.executor = executor;
        this.livenessTimeout = livenessTimeout;
        this.receiveTimeout = receiveTimeout;
    }

    public static void dispose(IoSession session) {
        Tracker tracker = LivenessFilter.trackerFor(session);
        if (tracker != null) {
            tracker.dispose();
        }
    }

    public static LivenessFilter filterFor(IoSession session) {
        return LivenessFilter.trackerFor(session).filter();
    }

    public long livenessTimeout() {
        return this.livenessTimeout;
    }

    public static void setLivenessTimeoutFor(IoSession session, long newTimeout) {
        if (newTimeout < 1000L) {
            throw new IllegalArgumentException("Timeout cannot be < 1000: " + newTimeout);
        }
        Tracker tracker = LivenessFilter.trackerFor(session);
        tracker.filter().livenessTimeout = newTimeout;
        tracker.timeoutUpdated();
    }

    public static void setReceiveTimeoutFor(IoSession session, long newTimeout) {
        if (newTimeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be < 0: " + newTimeout);
        }
        Tracker tracker = LivenessFilter.trackerFor(session);
        tracker.filter().receiveTimeout = newTimeout;
        tracker.timeoutUpdated();
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.filterName = name;
        if (this.executor == null) {
            this.executor = SharedExecutor.acquire();
        }
    }

    public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (SharedExecutor.release(this.executor)) {
            this.executor = null;
        }
        nextFilter.filterClose(session);
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        session.setAttribute("livenessTracker", new Tracker(session));
        nextFilter.sessionOpened(session);
    }

    static Tracker trackerFor(IoSession session) {
        return (Tracker)session.getAttribute("livenessTracker");
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        Tracker tracker = LivenessFilter.trackerFor(session);
        if (tracker != null) {
            tracker.dispose();
        }
        nextFilter.sessionClosed(session);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        LivenessFilter.trackerFor(session).connectionIsLive();
        if (message == ConfConn.INSTANCE) {
            Log.trace("Liveness confirmed: received ConfConn", this);
        } else if (message == TestConn.INSTANCE) {
            if (session.getScheduledWriteRequests() == 0) {
                session.write(ConfConn.INSTANCE);
                Log.trace("Sent ConfConn in response to TestConn liveness check", this);
            } else {
                Log.trace("Ignored TestConn: outgoing messages already in queue", this);
            }
        } else {
            nextFilter.messageReceived(session, message);
        }
    }

    class Tracker {
        private IoSession session;
        private ScheduledFuture<?> livenessFuture;
        private long lastLive;
        private long lastTestConnCheck;

        public Tracker(IoSession session) {
            this.session = session;
            this.lastLive = System.currentTimeMillis();
            this.scheduleLivenessCheck(LivenessFilter.this.livenessTimeout - (long)(Math.random() * (double)LivenessFilter.this.livenessTimeout));
        }

        public LivenessFilter filter() {
            return LivenessFilter.this;
        }

        public synchronized void dispose() {
            this.cancelLivenessCheck();
            this.session = null;
        }

        public boolean isDisposed() {
            return this.livenessFuture == null && this.session == null;
        }

        public synchronized void connectionIsLive() {
            this.lastLive = System.currentTimeMillis();
        }

        public void timeoutUpdated() {
            this.cancelLivenessCheck();
            this.lastLive = System.currentTimeMillis();
            this.scheduleLivenessCheck();
        }

        private void scheduleLivenessCheck() {
            this.scheduleLivenessCheck(Math.max(0L, LivenessFilter.this.livenessTimeout - (System.currentTimeMillis() - this.lastLive)));
        }

        private void scheduleLivenessCheck(long delay) {
            if (this.livenessFuture == null) {
                this.livenessFuture = LivenessFilter.this.executor.schedule(new Runnable(){

                    public void run() {
                        Tracker.this.checkLiveness();
                    }
                }, delay, TimeUnit.MILLISECONDS);
            }
        }

        private void cancelLivenessCheck() {
            if (this.livenessFuture != null) {
                this.livenessFuture.cancel(false);
                this.livenessFuture = null;
            }
        }

        protected synchronized void checkLiveness() {
            this.livenessFuture = null;
            if (System.currentTimeMillis() - this.lastLive >= LivenessFilter.this.livenessTimeout) {
                Log.trace("Liveness timeout: sending TestConn", this);
                this.lastTestConnCheck = System.currentTimeMillis();
                this.session.write(TestConn.INSTANCE);
                this.livenessFuture = LivenessFilter.this.executor.schedule(new Runnable(){

                    public void run() {
                        Tracker.this.checkConnReply();
                    }
                }, LivenessFilter.this.receiveTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.scheduleLivenessCheck();
            }
        }

        protected synchronized void checkConnReply() {
            this.livenessFuture = null;
            if (this.lastLive < this.lastTestConnCheck) {
                Log.trace("No reply to TestConn: signaling liveness failure", this);
                this.injectMessage(new LivenessFailureMessage());
            } else {
                this.scheduleLivenessCheck();
            }
        }

        private void injectMessage(Message message) {
            IoFilter.NextFilter filter = this.session.getFilterChain().getNextFilter(LivenessFilter.this.filterName);
            filter.messageReceived(this.session, message);
        }
    }
}

