/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LegacyConnectionOptions {
    private static final Map<String, String> legacyToNew = new HashMap<String, String>();
    private static final Map<String, String> newToLegacy = new HashMap<String, String>();

    private LegacyConnectionOptions() {
    }

    private static void addLegacy(String oldOption, String newOption) {
        legacyToNew.put(oldOption, newOption);
        newToLegacy.put(newOption, oldOption);
    }

    public static String legacyToNew(String option) {
        if (legacyToNew.containsKey(option)) {
            return legacyToNew.get(option);
        }
        return option;
    }

    public static String newToLegacy(String option) {
        if (newToLegacy.containsKey(option)) {
            return newToLegacy.get(option);
        }
        return option;
    }

    public static void setWithLegacy(Map<String, Object> options, String option, Object value) {
        options.put(option, value);
        options.put(LegacyConnectionOptions.newToLegacy(option), value);
    }

    static {
        LegacyConnectionOptions.addLegacy("router.attribute.max-count", "Attribute.Max-Count");
        LegacyConnectionOptions.addLegacy("router.attribute.name.max-length", "Attribute.Name.Max-Length");
        LegacyConnectionOptions.addLegacy("router.attribute.opaque.max-length", "Attribute.Opaque.Max-Length");
        LegacyConnectionOptions.addLegacy("router.attribute.string.max-length", "Attribute.String.Max-Length");
        LegacyConnectionOptions.addLegacy("router.packet.max-length", "Packet.Max-Length");
        LegacyConnectionOptions.addLegacy("router.recv-queue.drop-policy", "Receive-Queue.Drop-Policy");
        LegacyConnectionOptions.addLegacy("router.recv-queue.max-length", "Receive-Queue.Max-Length");
        LegacyConnectionOptions.addLegacy("router.send-queue.drop-policy", "Send-Queue.Drop-Policy");
        LegacyConnectionOptions.addLegacy("router.send-queue.max-length", "Send-Queue.Max-Length");
        LegacyConnectionOptions.addLegacy("router.subscription.max-count", "Subscription.Max-Count");
        LegacyConnectionOptions.addLegacy("router.subscription.max-length", "Subscription.Max-Length");
        LegacyConnectionOptions.addLegacy("router.supported-keyschemes", "Supported-Key-Schemes");
        LegacyConnectionOptions.addLegacy("router.vendor-identification", "Vendor-Identification");
        LegacyConnectionOptions.addLegacy("router.coalesce-delay", "TCP.Send-Immediately");
    }
}

