/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation.io;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.avis.federation.io.XdrAstParser;
import org.avis.io.XdrCoding;
import org.avis.subscription.ast.IllegalChildException;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.And;
import org.avis.subscription.ast.nodes.Compare;
import org.avis.subscription.ast.nodes.Const;
import org.avis.subscription.ast.nodes.Field;
import org.avis.subscription.ast.nodes.MathBitAnd;
import org.avis.subscription.ast.nodes.MathBitInvert;
import org.avis.subscription.ast.nodes.MathBitLogShiftRight;
import org.avis.subscription.ast.nodes.MathBitOr;
import org.avis.subscription.ast.nodes.MathBitShiftLeft;
import org.avis.subscription.ast.nodes.MathBitShiftRight;
import org.avis.subscription.ast.nodes.MathBitXor;
import org.avis.subscription.ast.nodes.MathDiv;
import org.avis.subscription.ast.nodes.MathMinus;
import org.avis.subscription.ast.nodes.MathMod;
import org.avis.subscription.ast.nodes.MathMult;
import org.avis.subscription.ast.nodes.MathPlus;
import org.avis.subscription.ast.nodes.MathUnaryMinus;
import org.avis.subscription.ast.nodes.Nan;
import org.avis.subscription.ast.nodes.Not;
import org.avis.subscription.ast.nodes.Or;
import org.avis.subscription.ast.nodes.Require;
import org.avis.subscription.ast.nodes.Size;
import org.avis.subscription.ast.nodes.StrBeginsWith;
import org.avis.subscription.ast.nodes.StrContains;
import org.avis.subscription.ast.nodes.StrEndsWith;
import org.avis.subscription.ast.nodes.StrFoldCase;
import org.avis.subscription.ast.nodes.StrRegex;
import org.avis.subscription.ast.nodes.StrUnicodeDecompose;
import org.avis.subscription.ast.nodes.StrWildcard;
import org.avis.subscription.ast.nodes.Type;
import org.avis.subscription.ast.nodes.Xor;
import org.avis.util.Text;

public final class XdrAstCoding {
    private static Map<Class<? extends Node>, Integer> typeCodes = new HashMap<Class<? extends Node>, Integer>();

    private XdrAstCoding() {
    }

    public static void encodeAST(ByteBuffer out, Node node) throws ProtocolCodecException {
        if (node instanceof Const) {
            XdrAstCoding.encodeConst(out, (Const)node);
        } else if (node instanceof Field) {
            out.putInt(1);
            out.putInt(4);
            XdrCoding.putString(out, ((Field)node).fieldName());
        } else {
            out.putInt(XdrAstCoding.typeCodeFor(node));
            out.putInt(0);
            Collection<Node> children = node.children();
            out.putInt(children.size());
            for (Node child : children) {
                XdrAstCoding.encodeAST(out, child);
            }
        }
    }

    private static int typeCodeFor(Node node) {
        if (node instanceof Compare) {
            Compare compare = (Compare)node;
            switch (compare.inequality) {
                case 0: {
                    return 65;
                }
                case -1: {
                    return compare.equality ? 11 : 10;
                }
                case 1: {
                    return compare.equality ? 13 : 12;
                }
            }
            throw new Error();
        }
        if (node instanceof Type) {
            Class<?> type = ((Type)node).type;
            if (type == String.class) {
                return 43;
            }
            if (type == Integer.class) {
                return 40;
            }
            if (type == Long.class) {
                return 41;
            }
            if (type == Double.class) {
                return 42;
            }
            if (type == byte[].class) {
                return 44;
            }
            throw new Error();
        }
        if (node instanceof StrUnicodeDecompose) {
            StrUnicodeDecompose decompose = (StrUnicodeDecompose)node;
            return decompose.mode == StrUnicodeDecompose.Mode.DECOMPOSE ? 61 : 62;
        }
        return typeCodes.get(node.getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void encodeConst(ByteBuffer out, Const node) throws ProtocolCodecException {
        Object value = node.value();
        Class<?> type = value.getClass();
        if (type == String.class) {
            out.putInt(5);
            out.putInt(4);
            XdrCoding.putString(out, (String)value);
            return;
        } else if (type == Integer.class) {
            out.putInt(2);
            out.putInt(1);
            out.putInt((Integer)value);
            return;
        } else if (type == Long.class) {
            out.putInt(3);
            out.putInt(2);
            out.putLong((Long)value);
            return;
        } else if (type == Double.class) {
            out.putInt(4);
            out.putInt(3);
            out.putDouble((Double)value);
            return;
        } else {
            if (type != Boolean.class) throw new ProtocolCodecException("Cannot encode constant type " + Text.className(type));
            if (((Boolean)node.value()).booleanValue()) throw new ProtocolCodecException("Cannot encode TRUE in AST");
            out.putInt(0);
        }
    }

    public static Node decodeAST(ByteBuffer in) throws ProtocolCodecException {
        try {
            return new XdrAstParser(in).expr();
        }
        catch (IllegalChildException ex) {
            throw new ProtocolCodecException("Invalid AST: " + ex.getMessage());
        }
    }

    static {
        typeCodes.put(And.class, 18);
        typeCodes.put(MathBitAnd.class, 35);
        typeCodes.put(MathBitInvert.class, 38);
        typeCodes.put(MathBitLogShiftRight.class, 34);
        typeCodes.put(MathBitOr.class, 37);
        typeCodes.put(MathBitShiftLeft.class, 32);
        typeCodes.put(MathBitShiftRight.class, 33);
        typeCodes.put(MathBitXor.class, 36);
        typeCodes.put(MathDiv.class, 27);
        typeCodes.put(MathMinus.class, 30);
        typeCodes.put(MathMod.class, 28);
        typeCodes.put(MathMult.class, 26);
        typeCodes.put(MathPlus.class, 29);
        typeCodes.put(MathUnaryMinus.class, 25);
        typeCodes.put(Nan.class, 45);
        typeCodes.put(Not.class, 19);
        typeCodes.put(Or.class, 16);
        typeCodes.put(Require.class, 64);
        typeCodes.put(Size.class, 66);
        typeCodes.put(StrBeginsWith.class, 48);
        typeCodes.put(StrContains.class, 49);
        typeCodes.put(StrEndsWith.class, 50);
        typeCodes.put(StrFoldCase.class, 56);
        typeCodes.put(StrRegex.class, 52);
        typeCodes.put(StrWildcard.class, 51);
        typeCodes.put(Xor.class, 17);
    }
}

