/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.avis.common.ElvinURI;
import org.avis.config.Options;
import org.avis.federation.Acceptor;
import org.avis.federation.Connector;
import org.avis.federation.EwafURI;
import org.avis.federation.FederationClass;
import org.avis.federation.FederationClasses;
import org.avis.io.Net;
import org.avis.router.CloseListener;
import org.avis.router.Router;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.Const;
import org.avis.util.IllegalConfigOptionException;
import org.avis.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FederationManager
implements CloseListener {
    protected Router router;
    protected FederationClasses classes;
    protected Acceptor acceptor;
    protected List<Connector> connectors;

    public FederationManager(Router router, Options federationConfig) throws IllegalConfigOptionException, IOException {
        this.router = router;
        String serverDomain = this.initServerDomain(federationConfig);
        this.classes = FederationManager.initClasses(federationConfig);
        FederationManager.initAddAttributes(federationConfig, this.classes);
        this.connectors = FederationManager.initConnectors(router, serverDomain, this.classes, federationConfig);
        this.acceptor = FederationManager.initAcceptor(router, serverDomain, this.classes, federationConfig);
        router.addCloseListener(this);
    }

    public static FederationManager federationManagerFor(Router router) {
        for (CloseListener listener : router.closeListeners()) {
            if (!(listener instanceof FederationManager)) continue;
            return (FederationManager)listener;
        }
        throw new IllegalArgumentException("No federation manager");
    }

    public Acceptor acceptor() {
        return this.acceptor;
    }

    public Collection<Connector> connectors() {
        return this.connectors;
    }

    public Set<EwafURI> listenURIs() {
        if (this.acceptor == null) {
            return Collections.emptySet();
        }
        return this.acceptor.listenURIs();
    }

    @Override
    public void routerClosing(Router theRouter) {
        this.close();
    }

    public void close() {
        this.router.removeCloseListener(this);
        if (this.acceptor != null) {
            this.acceptor.close();
        }
        for (Connector connector : this.connectors) {
            connector.close();
        }
        this.acceptor = null;
        this.connectors = null;
    }

    public boolean isClosed() {
        return this.connectors == null;
    }

    private static List<Connector> initConnectors(Router router, String serverDomain, FederationClasses classes, Options config) throws IllegalConfigOptionException, IOException {
        Map<String, ?> connect = config.getParamOption("Federation.Connect");
        for (Map.Entry<String, ?> entry : connect.entrySet()) {
            FederationClass fedClass = classes.define(entry.getKey());
            if (fedClass.allowsNothing()) {
                throw new IllegalConfigOptionException("Federation.Connect[" + entry.getKey() + "]", "No federation subscribe/provide defined: this connection cannot import or export any notifications");
            }
            for (EwafURI uri : (Set)entry.getValue()) {
                FederationManager.checkUri("Federation.Connect[" + entry.getKey() + "]", uri);
            }
        }
        ArrayList<Connector> connectors = new ArrayList<Connector>(connect.size());
        for (Map.Entry<String, ?> entry : connect.entrySet()) {
            FederationClass fedClass = classes.define(entry.getKey());
            for (EwafURI uri : (Set)entry.getValue()) {
                connectors.add(new Connector(router, serverDomain, uri, fedClass, config));
            }
        }
        return connectors;
    }

    private String initServerDomain(Options federationConfig) {
        String domain = federationConfig.getString("Federation.Router-Name");
        if (domain.length() == 0) {
            try {
                domain = this.defaultServerDomain();
            }
            catch (IOException ex) {
                throw new IllegalConfigOptionException("Federation.Router-Name", "Cannot auto detect default router name, please set this manually: " + Text.shortException(ex));
            }
        }
        return domain;
    }

    private String defaultServerDomain() throws IOException {
        String instanceId = Integer.toHexString(System.identityHashCode(this));
        String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
        if (runtimeName.matches("\\d+@.+")) {
            return instanceId + '.' + runtimeName;
        }
        return instanceId + '@' + Net.localHostName();
    }

    private static Acceptor initAcceptor(Router router, String serverDomain, FederationClasses classes, Options config) {
        Set uris = (Set)config.get("Federation.Listen");
        if (uris.isEmpty()) {
            return null;
        }
        try {
            for (EwafURI uri : uris) {
                FederationManager.checkUri("Federation.Listen", uri);
            }
            return new Acceptor(router, serverDomain, classes, uris, config);
        }
        catch (IOException ex) {
            throw new IllegalConfigOptionException("Federation.Listen", Text.shortException(ex));
        }
    }

    private static FederationClasses initClasses(Options federationConfig) {
        FederationClasses classes = new FederationClasses();
        Map<String, ?> provide = federationConfig.getParamOption("Federation.Provide");
        for (Map.Entry<String, ?> entry : provide.entrySet()) {
            FederationClass fedClass = classes.define(entry.getKey());
            fedClass.outgoingFilter = (Node)entry.getValue();
        }
        Map<String, ?> subscribe = federationConfig.getParamOption("Federation.Subscribe");
        for (Map.Entry<String, ?> entry : subscribe.entrySet()) {
            Node incomingFilter = (Node)entry.getValue();
            if (incomingFilter == Const.CONST_TRUE) {
                throw new IllegalConfigOptionException("Federation.Subscribe[" + entry.getKey() + "]", "Federation with TRUE is not currently supported");
            }
            classes.define((String)entry.getKey()).incomingFilter = incomingFilter;
        }
        Map<String, ?> applyClass = federationConfig.getParamOption("Federation.Apply-Class");
        for (Map.Entry<String, ?> entry : applyClass.entrySet()) {
            FederationClass fedClass = classes.define(entry.getKey());
            for (String hostPatterns : (Set)entry.getValue()) {
                if (hostPatterns.contains("@")) {
                    hostPatterns = hostPatterns.replaceAll("@", "");
                }
                classes.map(hostPatterns, fedClass);
            }
        }
        classes.setDefaultClass(classes.define(federationConfig.getString("Federation.Default-Class")));
        return classes;
    }

    private static void initAddAttributes(Options config, FederationClasses classes) {
        Map<String, ?> incoming = config.getParamOption("Federation.Add-Incoming-Attribute");
        for (Map.Entry<String, ?> entry : incoming.entrySet()) {
            FederationClass fedClass = classes.define(entry.getKey());
            fedClass.incomingAttributes = (Map)entry.getValue();
        }
        Map<String, ?> outgoing = config.getParamOption("Federation.Add-Outgoing-Attribute");
        for (Map.Entry<String, ?> entry : outgoing.entrySet()) {
            FederationClass fedClass = classes.define(entry.getKey());
            fedClass.outgoingAttributes = (Map)entry.getValue();
        }
    }

    private static void checkUri(String option, EwafURI uri) {
        if (!((Object)uri.protocol).equals(ElvinURI.defaultProtocol()) && !((Object)uri.protocol).equals(ElvinURI.secureProtocol())) {
            throw new IllegalConfigOptionException(option, "Avis only supports " + ElvinURI.defaultProtocol() + " and " + ElvinURI.secureProtocol() + " protocols: " + uri);
        }
    }
}

