/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation;

import java.util.Collections;
import java.util.Map;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.Const;
import org.avis.subscription.parser.ParseException;
import org.avis.subscription.parser.SubscriptionParserBase;

public class FederationClass {
    public String name;
    public Node incomingFilter;
    public Node outgoingFilter;
    public Map<String, Object> incomingAttributes;
    public Map<String, Object> outgoingAttributes;

    public FederationClass() {
        this(Const.CONST_FALSE, Const.CONST_FALSE);
    }

    public FederationClass(String incomingFilterExpr, String outgoingFilterExpr) throws ParseException {
        this(FederationClass.parse(incomingFilterExpr), FederationClass.parse(outgoingFilterExpr));
    }

    public FederationClass(Node incomingFilter, Node outgoingFilter) {
        this.incomingFilter = incomingFilter;
        this.outgoingFilter = outgoingFilter;
        this.incomingAttributes = Collections.emptyMap();
        this.outgoingAttributes = Collections.emptyMap();
    }

    public boolean allowsNothing() {
        return this.incomingFilter == Const.CONST_FALSE && this.outgoingFilter == Const.CONST_FALSE;
    }

    public static Node parse(String subExpr) throws ParseException {
        if ((subExpr = subExpr.trim()).equalsIgnoreCase("true")) {
            return Const.CONST_TRUE;
        }
        if (subExpr.equalsIgnoreCase("false")) {
            return Const.CONST_FALSE;
        }
        return SubscriptionParserBase.parse(subExpr);
    }
}

