/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation;

import java.io.IOException;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.avis.io.messages.ErrorMessage;
import org.avis.io.messages.Message;
import org.avis.logging.Log;
import org.avis.router.Router;
import org.avis.util.Text;

public final class Federation {
    public static final int DEFAULT_EWAF_PORT = 2916;
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 0;

    private Federation() {
    }

    public static WriteFuture send(IoSession session, String serverDomain, Message message) {
        if (Log.shouldLog(0)) {
            Log.trace("Federator for domain \"" + serverDomain + "\" sent: " + message, Federation.class);
        }
        return session.write(message);
    }

    public static void logMessageReceived(Message message, String serverDomain, Object source) {
        if (Log.shouldLog(0)) {
            Log.trace("Federator for domain \"" + serverDomain + "\" " + "received " + message.name(), source);
        }
    }

    public static void logError(ErrorMessage message, Object source) {
        Log.warn("Error in federation packet", source, message.error);
    }

    public static void logMinaException(Throwable cause, Object source) {
        if (cause instanceof IOException) {
            Log.diagnostic("I/O exception while processing federation message", source, cause);
        } else {
            Log.warn("Unexpected exception while processing federation message", source, cause);
        }
    }

    public static void logSessionOpened(IoSession session, Object source) {
        Log.diagnostic("Federation session " + Text.idFor(session) + " opened for connection on " + session.getServiceAddress() + (Router.isSecure(session) ? " (using TLS)" : ""), source);
    }
}

