/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.avis.config.Options;
import org.avis.federation.EwafURI;
import org.avis.federation.Federation;
import org.avis.federation.FederationClass;
import org.avis.federation.FederationClasses;
import org.avis.federation.Link;
import org.avis.federation.io.FederationFrameCodec;
import org.avis.federation.io.messages.FedConnRply;
import org.avis.federation.io.messages.FedConnRqst;
import org.avis.io.FrameCodec;
import org.avis.io.LivenessFilter;
import org.avis.io.Net;
import org.avis.io.RequestTrackingFilter;
import org.avis.io.messages.ErrorMessage;
import org.avis.io.messages.Message;
import org.avis.io.messages.Nack;
import org.avis.logging.Log;
import org.avis.router.Router;
import org.avis.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Acceptor
implements IoHandler,
Closeable {
    public static final int INVALID_DOMAIN = 2500;
    protected Router router;
    protected Options options;
    protected String serverDomain;
    protected FederationClasses federationClasses;
    protected Set<EwafURI> listenUris;
    protected Set<Link> links;
    protected Set<InetSocketAddress> listenAddresses;
    protected volatile boolean closing;

    public Acceptor(Router router, String serverDomain, FederationClasses federationClasses, Set<EwafURI> uris, Options options) throws IOException {
        this.router = router;
        this.serverDomain = serverDomain;
        this.federationClasses = federationClasses;
        this.listenUris = uris;
        this.listenAddresses = Net.addressesFor(uris);
        this.options = options;
        this.links = new HashSet<Link>();
        long requestTimeout = options.getInt("Federation.Request-Timeout") * 1000;
        long keepaliveInterval = options.getInt("Federation.Keepalive-Interval") * 1000;
        DefaultIoFilterChainBuilder filters = new DefaultIoFilterChainBuilder();
        filters.addLast("codec", FederationFrameCodec.FILTER);
        filters.addLast("requestTracker", new RequestTrackingFilter(requestTimeout));
        filters.addLast("liveness", new LivenessFilter(keepaliveInterval, requestTimeout));
        router.bind(uris, this, filters, (Filter)options.get("Federation.Require-Authenticated"));
        if (Log.shouldLog(1)) {
            for (EwafURI uri : uris) {
                Log.diagnostic("Federator listening on " + uri + " " + Net.addressesFor(uri), this);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        for (Link link : this.links) {
            link.close();
        }
        this.links.clear();
        SocketAcceptor socketAcceptor = this.router.socketAcceptor();
        for (InetSocketAddress address : this.listenAddresses) {
            for (IoSession session : socketAcceptor.getManagedSessions(address)) {
                session.close().join(10000L);
            }
            socketAcceptor.unbind(address);
        }
    }

    public Set<EwafURI> listenURIs() {
        return this.listenUris;
    }

    public Set<InetSocketAddress> listenAddresses() {
        return this.listenAddresses;
    }

    public void hang() {
        for (InetSocketAddress address : this.listenAddresses) {
            for (IoSession session : this.router.socketAcceptor().getManagedSessions(address)) {
                session.getFilterChain().remove("requestTracker");
                session.getFilterChain().remove("liveness");
            }
        }
        this.closing = true;
    }

    private void handleMessage(IoSession session, Message message) {
        switch (message.typeId()) {
            case 192: {
                this.handleFedConnRqst(session, (FedConnRqst)message);
                break;
            }
            case -1: {
                Federation.logError((ErrorMessage)message, this);
                session.close();
                break;
            }
            default: {
                Log.warn("Unexpected handshake message from connecting remote federator at " + Net.hostIdFor(session) + " (disconnecting): " + message.name(), this);
                session.close();
            }
        }
    }

    private void handleFedConnRqst(IoSession session, FedConnRqst message) {
        InetAddress remoteHost = Net.remoteHostAddressFor(session);
        String hostName = remoteHost.getCanonicalHostName();
        if (message.versionMajor != 1 || message.versionMinor > 0) {
            String disconnMessage = "Incompatible federation protocol version: " + message.versionMajor + "." + message.versionMinor + " not compatible with this federator's " + 1 + "." + 0;
            Log.warn("Rejected federation request from " + hostName + ": " + disconnMessage, this);
            this.send(session, new Nack(message, 1, disconnMessage)).addListener(IoFutureListener.CLOSE);
        } else {
            Link existingLink = this.linkForDomain(message.serverDomain);
            FederationClass fedClass = this.federationClasses.classFor(remoteHost);
            if (existingLink != null) {
                this.nackInvalidDomain(session, message, "using a federation domain already in use by \"" + Net.hostIdFor(existingLink.session()), "Server domain " + message.serverDomain + " already in use");
            } else if (fedClass.allowsNothing()) {
                this.nackInvalidDomain(session, message, "no provide/subscribe defined for its hostname/server domain", "No federation import/export allowed for host");
            } else if (message.serverDomain.equalsIgnoreCase(this.serverDomain)) {
                this.nackInvalidDomain(session, message, "using the same server domain the remote router", "Server domain is the same as the remote router's");
            } else {
                this.send(session, new FedConnRply(message, this.serverDomain));
                Log.info("Federation incoming link established with \"" + Net.hostIdFor(session) + "\", remote server domain \"" + message.serverDomain + "\", federation class \"" + fedClass.name + "\"", this);
                this.createLink(session, message.serverDomain, hostName, fedClass);
            }
        }
    }

    private void nackInvalidDomain(IoSession session, FedConnRqst message, String logMessage, String nackMessage) {
        Log.warn("Remote federator has been denied connection due to " + logMessage + ", host = " + Net.hostIdFor(session) + ", server domain = " + message.serverDomain, this);
        this.send(session, new Nack(message, 2500, nackMessage)).addListener(IoFutureListener.CLOSE);
    }

    private synchronized void createLink(IoSession session, String remoteServerDomain, String remoteHost, FederationClass federationClass) {
        Link link = new Link(this.router, session, federationClass, this.serverDomain, remoteServerDomain, remoteHost);
        session.setAttribute("federationLink", link);
        this.links.add(link);
    }

    private synchronized void removeLink(Link link) {
        this.links.remove(link);
    }

    private synchronized Link linkForDomain(String domain) {
        for (Link link : this.links) {
            if (!link.remoteServerDomain().equalsIgnoreCase(domain)) continue;
            return link;
        }
        return null;
    }

    private static Link linkFor(IoSession session) {
        return (Link)session.getAttribute("federationLink");
    }

    private WriteFuture send(IoSession session, Message message) {
        return Federation.send(session, this.serverDomain, message);
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        session.setIdleTime(IdleStatus.READER_IDLE, 20);
        FrameCodec.setMaxFrameLengthFor(session, this.options.getInt("Packet.Max-Length"));
    }

    @Override
    public void sessionOpened(IoSession session) throws Exception {
        if (this.closing) {
            session.close();
        } else {
            Federation.logSessionOpened(session, this);
        }
    }

    @Override
    public void messageReceived(IoSession session, Object theMessage) throws Exception {
        if (this.closing) {
            return;
        }
        Message message = (Message)theMessage;
        Federation.logMessageReceived(message, this.serverDomain, this);
        Link link = Acceptor.linkFor(session);
        if (link == null) {
            this.handleMessage(session, message);
        } else if (!link.isClosed()) {
            link.handleMessage(message);
        }
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        Link link = Acceptor.linkFor(session);
        if (link != null) {
            if (!link.isClosed()) {
                Log.warn("Remote host \"" + Net.hostIdFor(session) + "\" closed incoming federation link with no warning", this);
                link.close();
            } else {
                Log.info("Federation link with \"" + Net.hostIdFor(session) + "\" disconnected", this);
            }
            this.removeLink(link);
        }
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        Federation.logMinaException(cause, this);
    }

    @Override
    public void messageSent(IoSession session, Object message) throws Exception {
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        if (status == IdleStatus.READER_IDLE && Acceptor.linkFor(session) == null) {
            Log.warn("Disconnecting incoming federation connection from " + Net.hostIdFor(session) + " due to failure to send connect request", this);
            session.close();
        }
    }
}

