/*
 * Decompiled with CFR 0.152.
 */
package org.avis.config;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.avis.config.OptionSet;
import org.avis.config.OptionTypeParam;
import org.avis.util.IllegalConfigOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
implements Iterable<Map.Entry<String, Object>> {
    protected Map<String, Object> values = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    protected List<Options> defaults = new ArrayList<Options>();
    protected OptionSet optionSet;
    protected File relativeDirectory;

    public Options() {
        this(OptionSet.EMPTY_OPTION_SET);
    }

    public Options(OptionSet optionSet) {
        this.optionSet = optionSet;
        this.relativeDirectory = new File(System.getProperty("user.dir"));
    }

    public OptionSet optionSet() {
        return this.optionSet;
    }

    public void setRelativeDirectory(String directory) {
        this.setRelativeDirectory(new File(directory));
    }

    public void setRelativeDirectory(File directory) {
        this.relativeDirectory = directory;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.values.entrySet().iterator();
    }

    public void addDefaults(Options newDefaults) {
        this.defaults.add(0, newDefaults);
    }

    public void setAll(Map<String, Object> options) throws IllegalConfigOptionException {
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public void setAll(Properties properties) throws IllegalConfigOptionException {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.set((String)entry.getKey(), entry.getValue());
        }
    }

    public int getInt(String option) throws IllegalConfigOptionException {
        Object value = this.get(option);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new IllegalConfigOptionException(option, "Not an integer");
    }

    public String getString(String option) throws IllegalConfigOptionException {
        Object value = this.get(option);
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalConfigOptionException(option, "Not a string");
    }

    public boolean getBoolean(String option) throws IllegalConfigOptionException {
        Object value = this.get(option);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalConfigOptionException(option, "Not a boolean");
    }

    public Map<String, ?> getParamOption(String option) {
        return OptionTypeParam.getParamOption(this, option);
    }

    public <T> Set<T> getSet(String option, Class<T> type) {
        Object value = this.get(option);
        if (value instanceof Set) {
            return (Set)value;
        }
        throw new IllegalConfigOptionException(option, "Not a set");
    }

    public URI getAbsoluteURI(String option) {
        Object value = this.get(option);
        if (value instanceof URI) {
            return this.toAbsoluteURI((URI)value);
        }
        throw new IllegalConfigOptionException(option, "Not a URI");
    }

    public URI toAbsoluteURI(URI uri) {
        if (uri.isAbsolute()) {
            return uri;
        }
        return this.relativeDirectory.toURI().resolve(uri);
    }

    public Object get(String option) throws IllegalConfigOptionException {
        Object value = this.peek(option);
        if (value != null) {
            return value;
        }
        throw new IllegalConfigOptionException(option, "Undefined option");
    }

    public Object peek(String option) {
        Object value = this.values.get(option);
        if (value == null) {
            Options options;
            Iterator<Options> i$ = this.defaults.iterator();
            while (i$.hasNext() && (value = (options = i$.next()).peek(option)) == null) {
            }
        }
        if (value == null) {
            value = this.optionSet.peekDefaultValue(option);
        }
        return value;
    }

    public void set(String option, Object value) throws IllegalConfigOptionException {
        if (value == null) {
            throw new IllegalConfigOptionException(option, "Value cannot be null");
        }
        OptionSet set = this.optionSet.findOptionSetFor(option);
        if (set == null) {
            set = this.optionSet;
        }
        set.validateAndSet(this, option, value);
    }

    public void remove(String option) {
        this.values.remove(option);
    }

    public boolean isDefined(String option) {
        return this.peek(option) != null;
    }

    public Set<String> options() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.values);
    }
}

