var NotificationPrefsClass = Class.create(
{
    initialize: function()
    {
		this.defaultAddressValue 	= '';
		this.STUDIO_CHANNEL_ID		= 4;
    },
    
    finishInit: function()
    {
		// load all our html content
		this.fetchEventDrop();
		this.fetchChannelDrop();
		
		EventManager.subscribe('/portal/cloud/subscriptions/', 
        {
            channelHook: 'NotificationPrefs',
            onComplete: function()
            {
                this.parseNotificationList();
            }.bind(this)
        });
		
        Portal.Data.currentUser.observe('subscriptionsLoaded', function()
        {
			this.parseNotificationList();
        }.bind(this));
    },
    
    dispatchEvent: function(msg)
    {
        if (msg.data.response == 'listSubscriptions') 
        {
            this.parseNotificationList();
        }
        else if (msg.data.response == 'addSubscription')
        {
            this.addChannelSub(msg);
        }
		else if (msg.data.response == 'deleteSubscription')
		{
			this.handleRemoveChannelSub(msg);
		}
    },
    
    fetchEventDrop: function()
    {
        var selectTemplate = new Template('<select name="eventId" id="eventId" class="text"><option value="0">Please choose...</option>#{options}</select>');
        var optionTemplate = new Template('<option value="#{eventId}">#{eventName}</option>');
        var options = '';
        
        Portal.Data.events.events.each(function(event)
        {
            options += optionTemplate.evaluate(
            {
                eventId: event.value.id,
                eventName: event.value.name
            });
        });
        
        Portal.API.utils.setContent('eventDropCage', selectTemplate.evaluate({
            options: options
        }));
    },
	
	fetchChannelDrop: function()
    {
        var selectTemplate = new Template('<select name="channelId" id="channelId" class="text" onChange="javascript: Portal.Modules.NotificationPrefs.manageChannelForm(this.value)"><option value="0">Please choose...</option>#{options}</select>');
        var optionTemplate = new Template('<option value="#{channelId}">#{channelName}</option>');
        var options = '';
        
        Portal.Data.channels.channels.each(function(channel)
        {
			// skip studio..
			if(channel.value.name.toLowerCase() == 'studio')
			{
				// return;
			}
			
            options += optionTemplate.evaluate(
            {
                channelId: channel.value.id,
                channelName: channel.value.name
            });
        });
        
        Portal.API.utils.setContent('channelDropCage', selectTemplate.evaluate({
            options: options
        }));
    },
    
	manageChannelForm: function manageChannelForm(value)
	{
		if(value == '0')
		{
			$('addressCage').update('');
			return;
		}
		
		var channelType = Portal.Data.channels.getName(value);
		
		var inputTemplate = new Template('<input name="eventAddress" id="eventAddress" size="15" class="text" value="#{value}" #{onFocus} #{onBlur} /><div id="autocomplete_choices" class="autocomplete"></div>');
		var value = '';
		var onFocus = '';
		var onBlur = '';
		
		switch(channelType.toLowerCase())
		{
			case 'email':
				if(Portal.Data.currentUser.email != null && Portal.Data.currentUser.email != false)
				{
					value = Portal.Data.currentUser.email;	
				}
				else
				{
					value = 'Email address';
					this.defaultAddressValue = value;
					onFocus = 'onFocus="if(this.value==\'' + value + '\') this.value = \'\';"';
					onBlur = 'onBlur="if(this.value==\'\') this.value = \'' + value + '\';"';	
				}
				break;
			case 'sms':
				value = 'Phone number';
				this.defaultAddressValue = value;
				onFocus = 'onFocus="if(this.value==\'' + value + '\') this.value = \'\';"';
				onBlur = 'onBlur="if(this.value==\'\') this.value = \'' + value + '\';"';
				break;
			case 'jabber':
				value = 'Jabber account';
				this.defaultAddressValue = value;
				onFocus = 'onFocus="if(this.value==\'' + value + '\') this.value = \'\';"';
				onBlur = 'onBlur="if(this.value==\'\') this.value = \'' + value + '\';"';
				break;
			case 'studio':
				$('addressCage').update('');
				return;
				break;
				
		}
				
        $('addressCage').update(inputTemplate.evaluate(
        {
            value: value,
            onFocus: onFocus,
            onBlur: onBlur
        }));
		
		var autoCompleteOptions = new Array();
		
        Portal.Data.currentUser.subscriptions.each(function(item)
        {
			if(item.value.channelName.toLowerCase() == channelType.toLowerCase())
			{
				autoCompleteOptions.push(item.value.channelValue);
			}
        });
		
		this.autocompleter = new Autocompleter.Local('eventAddress', 'autocomplete_choices', autoCompleteOptions.uniq());
	},
	
	parseNotificationList: function parseNotificationList()
	{
		if(Portal.Data.currentUser.subscriptionsLoading == true)
		{
			$('subListActivity').show();
			Portal.Data.currentUser.fetchChannelSubs();
			return;
		}
		else
		{
			$('subListActivity').hide();
		}
		
		var tableTemplate 	= new Template('<table cellpadding="3" cellspacing="0" border="0" width="100%" class="sortable"><thead><tr>'
							+ '<th class="bold borderBottom darkGray pad5 sortfirstasc">Event</th>'
							+ '<th class="bold borderBottom darkGray pad5">Method</th>'
							+ '<th class="bold borderBottom darkGray pad5">Address</th>'
							+ '<th class="bold borderBottom darkGray pad5 nosort">&nbsp;</td></tr></thead>'
							+ '<tbody>#{rows}</tbody></table>');
		var rowTemplate	= new Template('<tr onmouseover="this.style.backgroundColor=\'#e1f0ff\'" onmouseout="this.style.backgroundColor=\'#fff\'"><td class="borderBottom lightGray">#{eventName}</td>' 
						+ '<td class="borderBottom lightGray">#{channelName}</td>'
						+ '<td class="borderBottom lightGray">#{channelValue}</td>'
						+ '<td class="borderBottom lightGray right"><a href="javascript: Portal.Modules.NotificationPrefs.removeChannelSub(\'#{subId}\')"><img src="images_global/button_alert_remove.png" /></a></td></tr>');
		
		var rows = '';
		Portal.Data.currentUser.subscriptions.each(function(sub)
		{
			// don't add studio to the list
			if(sub.value.channelValue == 'studio')
			{
				sub.value.channelValue = 'Studio Message Center';
			}
			
			sub.value.channelName = sub.value.channelName.capitalize();
			
			rows += rowTemplate.evaluate(sub.value);
		});
		
		if(rows == '')
		{
			rows = '<tr><td colspan="4" class="pad3">You currently do not have any subscriptions</td></tr>';
		}
		
		$('activityCage').hide();
		
		Portal.API.utils.setContent('subList', tableTemplate.evaluate({ rows: rows }));
		
		SortableTable.load();
	},
	
    
    addChannelSub: function(msg)
    {
		if(!msg)
		{
			$('errorCage').hide();
			
	        var eventId = $F('eventId');
	        var eventAddress = (!$('eventAddress')) ? '' : $F('eventAddress');
			var channelId = $F('channelId');
			
			if(eventId == 0 || channelId == 0 || eventAddress == '' || eventAddress == this.defaultAddressValue)
			{
				if (channelId != this.STUDIO_CHANNEL_ID) 
				{
					Portal.API.dialogs.alert('Please fill out the form completely');
					return;
				}
			}
			
			if(channelId == this.STUDIO_CHANNEL_ID)
			{
				if (eventId == 0) 
				{
					Portal.API.dialogs.alert('Please fill out the form completely');
					return;
				}
				
				eventAddress = 'studio';	
			}
			
			$('activityCage').update('Adding subscription...');
			$('activityCage').show();
			
			EventManager.publish('/portal/cloud/subscriptions',
			{
				request: 'addSubscription',
				value: eventAddress,
				channel: channelId,
				event: eventId
			});
		}
        else
		{
			if(msg.data.success == true)
			{
				$('eventId').selectedIndex = 0;
				$('channelId').selectedIndex = 0;
				this.manageChannelForm(0);
				
				EventManager.publish('/portal/cloud/subscriptions', 
	            {
	                request: 'listSubscriptions'
	            });
			}
			else
			{
				$('activityCage').hide();
				$('errorCage').update('There was an error adding the alert subscription:<br /><span class="size11">&bull; ' + msg.data.errors.join('</span><br /><span class="size11">&bull; ') + '</span>');
				$('errorCage').show();
			}	
		}
    },
    
    removeChannelSub: function(id)
    {
		
		Portal.API.dialogs.confirm(
		{
			message: 'Are you sure you wish to remove the subscription?',
			title: 'Confirm remove subscription',
			onConfirm: function()
			{
				$('errorCage').hide();
	            $('activityCage').update('Removing subscription...');
				$('activityCage').show();
	            
	            EventManager.publish('/portal/cloud/subscriptions', 
	            {
	                request: 'deleteSubscription',
	                id: id
	            });
			}
		});
    },
	
	handleRemoveChannelSub: function handleRemoveChannelSub(msg)
	{
		if(msg.data.success == true)
		{
			$('eventId').selectedIndex = 0;
			$('channelId').selectedIndex = 0;
			this.manageChannelForm(0);
			
			EventManager.publish('/portal/cloud/subscriptions', 
            {
                request: 'listSubscriptions'
            });
		}
		else
		{
			$('activityCage').hide();
			$('errorCage').update('There was an error removing the alert subscription.  Please try again.');
			$('errorCage').show();
		}
	}
});
