var SiteConfiguratorModule = Class.create(
{
	initialize: function initialize()
	{
		this.initVars();
	},
	
	initVars: function initVars()
	{
		this.loading				= true;
		this.templates				= {};
		this.planMap				= { 0: 1, 1: 2, 2: 3, 3: 4 },
		this.hostingPlanId			= 0;
		this.currentHostingPlan		= 0;
		this.optionIds				= [];
		this.currentOptionIds		= [];
		this.currentSite			= Portal.Modules.MyCloudPortal.currentSite;
		this.originalData			= {};
		this.serviceTotal			= 0;
		this.usageTotal				= 0;
		this.monthlyTotal			= 0;
		this.currentBillingAccount	= {};
		this.originalBillingAccount	= false;
		this.couponCode				= '';
		this.couponDescription		= '';
		this.newSettings			= '';
		this.couponDiscount			= 0;
		this.isTrial				= false;
		this.wasTrial				= false;
        this.states = 
        {
            usageHighlight: 		false,
            serviceHighlight: 		false,
			requestingPreview:		false,
			pendingFinalRequest:	false,
        }
	},
	
	finishInit: function finishInit()
	{
		this.extendSelf();
		this.registerObservers();
		
		this._init();
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if(msg.channel == '/portal/cloud/settings/preview' && msg.data.response == 'xmlRest')
		{
			this.fetchOrderPreview(msg);
		}
		else if(msg.channel == '/portal/cloud/settings/apply' && msg.data.response == 'xmlRest')
		{
			this.doApplySiteChanges(false, msg);
		}
		else if(msg.channel == '/portal/cloud/settings/force_apply' && msg.data.response == 'commit')
		{
			this.registerPoller(msg);
		}
	},
	
	registerObservers: function registerObservers()
	{
        EventManager.subscribe('/portal/cloud/settings/preview', 
        {
            channelHook: 'SiteConfigurator'
        });	
		
        EventManager.subscribe('/portal/cloud/settings/apply', 
        {
            channelHook: 'SiteConfigurator'
        });	
		
		EventManager.subscribe('/portal/cloud/settings/force_apply', 
        {
            channelHook: 'SiteConfigurator'
        });
		
        Portal.Data.currentUser.observe('billingAccountsLoaded', function()
        {
			this._initViews();
        }.bind(this));
	},
	
	extendSelf: function extendSelf()
	{
		Object.extend(this, SiteConfiguratorControllers);
		Object.extend(this, SiteConfiguratorViews);
	}
});

var SiteConfiguratorControllers = 
{
	_init: function _init()
	{
		if(Portal.Data.cloudProducts.error)
		{
			$('configurator_unavailable_cage').show();
			Portal.Data.cloudProducts.fetchProducts();
			
			return;
		}
		
		
		this.currentOptionIds = this.currentSite.hostingOptions.keys();
		this.hostingPlanId = this.currentSite.hostingPlanId;
		
		this.originalData.optionIds 	= this.currentOptionIds;
		this.originalData.hostingPlanId = this.hostingPlanId;
		this.originalData.serviceTotal	= 0;
		this.originalData.usageTotal	= 0;
		this.originalData.monthlyTotal	= 0;
		
		this.currentBillingAccount = {};
		
        Portal.Data.currentUser.billingAccounts.each(function(account)
        {
			if(account.value.sites.size() == 0)
			{
				return;
			}
			
            account.value.sites.each(function(site)
            {
				if(site.site_id == Portal.Modules.MyCloudPortal.currentSiteId)
				{
					this.currentBillingAccount = account.value;
					
					if(!this.originalBillingAccount)
					{
						this.originalBillingAccount = account.value;
					}
				}
            }.bind(this));
			
        }.bind(this));
		
		if(!this.originalBillingAccount)
		{
			this.isTrial = true;
		}

		// get the original total / current total		
		var plans = Portal.Data.cloudProducts.options;
		plans.each(function(item)
        {
            item.value.plans.each(function(plan)
            {
				if(this.originalData.optionIds.indexOf(plan.option.id.toString()) != -1)
				{
					this.originalData.serviceTotal += plan.option.unit_price;
				}
				
            }.bind(this))
        }.bind(this));
		
		this.serviceTotal = this.originalData.serviceTotal;

		this._initViews();
	},
	
	updateUsageDisplay: function updateUsageDisplay(currentValue)
	{
		var backgroundOffset = 120 * currentValue;
								
		$('cloud_size_image').setStyle({ backgroundPosition: '0px -' + backgroundOffset + 'px' });
		
        $$('td.hostingPlan').each(function(item)
        {
			$(item).setStyle({ fontWeight: 'normal' });
        });
		
		$('hosting_plan_' + currentValue).setStyle({ fontWeight: 'bold' });
		
		// get the current plan info..
		var currentPlan = Portal.Data.cloudProducts.plans.get(this.planMap[currentValue].toString());
		
		$('wizard_plan_description').update(currentPlan.description);
		
		if(currentPlan.description.indexOf('1/4') != -1)
		{
			$('wizard_plan_description').setStyle({ backgroundColor: '#caface' });
		}
		else
		{
			$('wizard_plan_description').setStyle({ backgroundColor: 'transparent' });
		}
		
		$('wizard_plan_price').update('$' + currentPlan.price.toFixed(3) + '/hour');
		$('usage_total').update('$' + currentPlan.price.toFixed(3) + '/hour');
		
		this.usageTotal = currentPlan.price.toFixed(3);
		
		if(this.originalData.usageTotal == 0)
		{
			this.originalData.usageTotal = this.usageTotal;
		}
		
		this.hostingPlanId = currentPlan.id;
		
		$('previous_usage_total').innerHTML = '$' + this.originalData.usageTotal + '/hour';
		
		if(this.hostingPlanId != this.originalData.hostingPlanId)
		{
			$('previous_usage_total_label').show();
			$('previous_usage_total').show();
			$('apply_cage').show();
			$('apply_disabled_cage').hide();
			
			if(!this.states.usageHighlight)
			{
				this.states.usageHighlight = true;
				$('usage_total_label').highlight();
				
                new Effect.Highlight('usage_total', 
                {
                    afterFinish: function()
                    {
						this.states.usageHighlight = false;
                    }.bind(this)
                });
			}
		}
		else
		{
			if (this.serviceTotal.toFixed(2) == this.originalData.serviceTotal.toFixed(2))
			{
				if ($('original_card').style.display == 'none') 
				{
					$('apply_cage').hide();
					$('apply_disabled_cage').show();
				}
			}
			
			$('previous_usage_total_label').hide();
			$('previous_usage_total').hide();
		}
		
		if (!this.loading) 
		{
			this.fetchOrderPreview();
		}
	},
	
	handleOptionSelect: function handleOptionSelect(event)
	{
		var element = Event.element(event);
		var plans = Portal.Data.cloudProducts.options;
		
		this.optionIds = [];
		
        $$('input.optionRadio').each(function(item)
        {
			if(item.checked)
			{
				this.optionIds.push(parseInt(item.value));
			}
        }.bind(this));
		
		var total = 0;
		var itemTotal = 0;
		
        plans.each(function(item)
        {
            item.value.plans.each(function(plan)
            {
				if(this.optionIds.indexOf(plan.option.id) != -1)
				{
					total += plan.option.unit_price;
				}
				
				if(plan.option.id == element.value)
				{
					itemTotal = plan.option.unit_price;
				}
            }.bind(this))
        }.bind(this));
		
		this.serviceTotal = total;
		$('price_' + element.name).update('$' + itemTotal.toFixed(2) + ' / month');
		$('total_service_cost').update('$' + total.toFixed(2));
		
		if (this.serviceTotal.toFixed(2) != this.originalData.serviceTotal.toFixed(2)) 
		{
			$('previous_service_cost_label').show();
			$('previous_service_cost').show();
			$('apply_cage').show();
			$('apply_disabled_cage').hide();
			
			if(!this.states.serviceHighlight)
			{
				this.states.serviceHighlight = true;
				$('total_service_cost_label').highlight();
				
                new Effect.Highlight('total_service_cost', 
                {
                    afterFinish: function()
                    {
						this.states.serviceHighlight = false;
                    }.bind(this)
                });
			}
		}
		else
		{
			if(this.hostingPlanId == this.originalData.hostingPlanId)
			{
				$('apply_cage').hide();
				$('apply_disabled_cage').show();
			}
			
			$('previous_service_cost_label').hide();
			$('previous_service_cost').hide();
		}
		
		this.fetchOrderPreview();
	},
	
	fetchOrderPreview: function fetchOrderPreview(msg)
	{
		if(!msg)
		{
			if(!this.states.requestingPreview)
			{
				this.states.requestingPreview = true;
				if ($('monthly_cost'))
				{
					$('monthly_cost').update('<div class="size11"><img src="images_global/img_activity.gif" align="absmiddle" class="inline" /> Updating...</div>');
				}
			}
			else
			{
				this.states.pendingFinalRequest = true;
				return;
			}
			
			
			// build all the data we need...
			var plan = this.hostingPlanId;
			var options = [];
			
            this.optionIds.each(function(item)
            {
				options.push({ option: { id: item.toString() }});
            });
			
            EventManager.publish('/portal/cloud/model', 
            {
				url: 'orders/preview',
				request: 'xmlRest',
				method: 'POST',
				returnChannel: '/portal/cloud/settings/preview',
				xmlData:
				{
					order:
					{
						plan: plan.toString(),
						options: options,
						coupon: this.couponCode,
						site_id: (Portal.Modules.MyCloudPortal.currentSiteId) ? Portal.Modules.MyCloudPortal.currentSiteId : Portal.Modules.MyCloudPortal.currentSite.id
					}
				}
			})
		}
		else
		{
			if(this.originalData.monthlyTotal == 0 && 'quote' in msg.data.xmlData)
			{
				this.originalData.monthlyTotal = new Number(msg.data.xmlData.quote.invoice.amount).toFixed(2);
				$('previous_monthly_cost').update('$' + this.originalData.monthlyTotal + '/month');
			}
			
			this.states.requestingPreview = false;
			
			if('quote' in msg.data.xmlData)
			{
				this.monthlyTotal = new Number(msg.data.xmlData.quote.invoice.amount).toFixed(2);
			}
			
			if(this.states.pendingFinalRequest)
			{
				this.states.pendingFinalRequest = false;
				this.fetchOrderPreview();
			}
			else
			{
				if(msg.data.xmlData.quote.coupons.length > 0 && msg.data.xmlData.quote.coupons[0].coupon.errors.length == 0)
				{
					this.couponCode = msg.data.xmlData.quote.coupons[0].coupon.code;
					this.couponDescription = msg.data.xmlData.quote.coupons[0].coupon.title;
					this.couponDiscount	= msg.data.xmlData.quote.coupons[0].coupon.total_discount_amount;
					
					if($('coupon_code_name'))
					{
						$('coupon_code_name').update(this.couponCode);
						$('coupon_code_title').update(this.couponDescription);
						$('coupon_code_cage').show();
					}
				}
				else
				{
					if($('coupon_code_cage'))
					{
						$('coupon_code_cage').hide();
					}
				}
				
				$('monthly_cost').update('$' + this.monthlyTotal);
				
				// the original order amount should be shown...
				if(this.hostingPlanId == this.originalData.hostingPlanId && this.serviceTotal.toFixed(2) == this.originalData.serviceTotal.toFixed(2))
				{
					$('previous_monthly_cost').hide();
					$('previous_monthly_cost_label').hide();	
				}
				else
				{
					$('previous_monthly_cost').show();
					$('previous_monthly_cost_label').show();
				}
			}
		}
	},
	
	doApplySiteChanges: function doApplySiteChanges(force, msg)
	{
		if(!msg)
		{
			var forceApply = false;
			
			if(force && force == true)
			{
				forceApply = true
			}
			
			// no id in this.currentBillingAccount + trial = alert
			// else = confirm
			
			var changes = '<strong>The following changes will be made: </strong><div class="size11 line16 top5 bottom5">';
			var newSettings = '<strong>The following changes have been made: </strong><div class="size11 line16 top5 bottom5">';
			
			if(this.originalData.hostingPlanId != this.hostingPlanId)
			{
				var hostingPlanItem = Portal.Data.cloudProducts.plans.get(this.hostingPlanId.toString());
				
				changes += '&bull; Changing cloud size to ' + hostingPlanItem.ram + ' RAM + ' + hostingPlanItem.disk + ' disk<br />'; 
				newSettings += '&bull; Set cloud size to ' + hostingPlanItem.ram + ' RAM + ' + hostingPlanItem.disk + ' disk<br />'; 
			}
			
            this.optionIds.each(function(item)
            {
				if(this.originalData.optionIds.indexOf(item.toString()) == -1)
				{
					var optionItem = Portal.Data.cloudProducts.findOption(item);
					
					changes += '&bull; Changing ' + optionItem.parentName + ' to ' + optionItem.name + '<br />';
					newSettings += '&bull; Set ' + optionItem.parentName + ' to ' + optionItem.name + '<br />';
				}
            }.bind(this));
			
			if(this.isTrial)
			{
				if (!('id' in this.currentBillingAccount)) 
				{
					if (Portal.Data.currentUser.billingAccounts.size() > 0) 
					{
						Portal.API.dialogs.alert('You must assign a credit card to use for this site\'s billing to apply changes.', 'Please assign a card to continue');
					}
					else 
					{
						Portal.API.dialogs.alert('You must add a new credit card to use for this site\'s billing to apply changes.', 'Please add a new card to continue');
					}
					return;
				}
				else
				{
					this.wasTrial = true;
					changes += '&bull; Setting payment to use card ' + this.currentBillingAccount.number + '<br />';
					newSettings += '&bull; Set payment to use card ' + this.currentBillingAccount.number + '<br />';
				}
			}
			else
			{
				if(this.originalBillingAccount != this.currentBillingAccount)
				{
					changes += '&bull; Changing payment to use card ' + this.currentBillingAccount.number + '<br />';
					newSettings += '&bull; Set payment to use card ' + this.currentBillingAccount.number + '<br />';
				}
			}
			
			this.newSettings = newSettings;
			
			var options = [];
            this.optionIds.each(function(item)
            {
				options.push({ option: { id: item.toString() } } );
            })
			
			var msg =
			{
				site:
				{
					plan: this.hostingPlanId.toString(),
					options: options,
					billing_account:
					{
						id: (!('id' in this.currentBillingAccount)) ? '0' : this.currentBillingAccount.id.toString()
					}
				}
			}
			
			if(forceApply)
			{
				msg.site.long_resize_ok = true;
	            Portal.API.dialogs.confirm(
	            {
					title: 'Confirm Long Resize for Changes',
					message: '<div class="size12 line16">The selected RAM and Disk configuration is not available for a fast-resize. <br /><br />If you would still like to continue, you may, but the resize will run in the background, and can take some time.  During this time, your site may be suspended (and thus unavailable) ' 
							 + 'while we work to apply your changes, however it will return to a Running state when this process completes.<br /><br />Would you like to continue applying these new settings to your site?</div>',
					
					onConfirm: function()
					{
	                    EventManager.publish('/portal/cloud/model', 
	                    {
							url: 'sites/' + Portal.Modules.MyCloudPortal.currentSiteId,
							request: 'commit',
							xmlData: msg,
							returnChannel: '/portal/cloud/settings/force_apply'
						});
					}
					
				});	
			}
			else
			{
				if(this.isTrial)
				{
                    Portal.API.dialogs.confirm(
                    {
                        title: 'Confirm Start of Billing',
						message: 'By applying changes, billing will begin for this site.  Would you like to continue?',
						onConfirm: function()
						{
							var showNextConfirm = function()
							{
								Portal.API.dialogs.confirm(
					            {
									title: 'Confirm Site Settings Changes',
									message: changes + '</div><div class="size11">Note: These changes may take a few seconds to take effect and appear in Studio.</div><br />Would you like to apply these new settings to your site?',
									onConfirm: function()
									{
					                    EventManager.publish('/portal/cloud/model', 
					                    {
											url: 'sites/' + Portal.Modules.MyCloudPortal.currentSiteId,
											request: 'xmlRest',
											method: 'POST',
											xmlData: msg,
											returnChannel: '/portal/cloud/settings/apply'
										});
									}
								});
							}
							
							setTimeout(showNextConfirm, 250);
						}
                    });
				}
				else
				{
		            Portal.API.dialogs.confirm(
		            {
						title: 'Confirm Site Settings Changes',
						message: changes + '</div><div class="size11">Note: These changes may take a few seconds to take effect and appear in Studio.</div><br />Would you like to apply these new settings to your site?',
						onConfirm: function()
						{
		                    EventManager.publish('/portal/cloud/model', 
		                    {
								url: 'sites/' + Portal.Modules.MyCloudPortal.currentSiteId,
								request: 'xmlRest',
								method: 'POST',
								xmlData: msg,
								returnChannel: '/portal/cloud/settings/apply'
							});
						}
					});
				}
			}
		}
		else
		{
			if(msg.data.status.toString() == '201')
			{
				var userMessage = function()
				{
					if(this.wasTrial && Portal.Modules.CloudTrialStatus.daysLeft > 1)
					{
						this.newSettings = '<div class="size12 line16 top5 bottom5"><strong>Thank you!</strong><br />Thank you for trying Aptana Cloud Connect and purchasing the service for ' + Portal.Modules.MyCloudPortal.currentSite.name
											+ '<br /><br /><strong>Want to try another site?</strong><br />There are still ' + Portal.Modules.CloudTrialStatus.daysLeft + ' days remaining in your trial period.  Until that time is up, you are welcome to deploy another site for free.' 
											+ '<br /><br /><strong>What about billing?</strong><br />Visit <a href="javascript:Portal.API.utils.openUrl(\'https://billing.aptana.com\');">https://billing.aptana.com</a> for invoices and billing statements related to ' + Portal.Modules.MyCloudPortal.currentSite.name + '<br /></div>' + this.newSettings;
						this.wasTrial = false;
					}
					
					if (this.newSettings.indexOf('MB') == -1) 
					{
						Portal.API.dialogs.alert(this.newSettings + '</div>Your settings have been applied successfully and are ready for use.', 'Site Settings Changed Successfully');
					}
					else
					{
						Portal.API.dialogs.alert(this.newSettings + '</div><div class="size11">Note: The resources charts may take up to a minute to reflect your settings.</div><br />Your settings have been applied successfully and are ready for use.', 'Site Settings Changed Successfully');
					}
				}.bind(this)
				
				var tempSite = Portal.Modules.MyCloudPortal.currentSite;
					
				tempSite.hostingPlanId = this.hostingPlanId;
				tempSite.hostingOptions = new Hash();
                this.optionIds.each(function(item)
                {
					tempSite.hostingOptions.set(item, parseInt(item));
					
                });
				
				Portal.Data.siteList.sites.set(tempSite.id, tempSite);
                
				var originalBillingAccount = Portal.Data.currentUser.billingAccounts.get(this.originalBillingAccount.id);
				var newBillingAccount = Portal.Data.currentUser.billingAccounts.get(this.currentBillingAccount.id);
				
				var originalBillingArray = [];
				var newBillingArray = newBillingAccount.sites;
				
				if(originalBillingAccount)
				{
	                originalBillingAccount.sites.each(function(item)
	                {
						if(item.site_id != Portal.Modules.MyCloudPortal.currentSiteId)
						{
							originalBillingArray.push(item);
						}
	                });
					
					originalBillingAccount.sites = originalBillingArray;
				}
				
				
				newBillingArray.push({site_id: Portal.Modules.MyCloudPortal.currentSiteId});
				newBillingAccount.sites = newBillingArray;
				
				Portal.Data.currentUser.fetchBillingAccounts();
				Portal.Modules.CloudTrialStatus.fetchTrialUpdate();
				
				var doInit = function()
				{
					this.initVars();
					this._init();
				}.bind(this);
				
				setTimeout(doInit, 1500);
			}
			else if (msg.data.status.toString() == '422')
			{
				if(msg.data.errors.length == 1 && msg.data.errors[0].indexOf('long_resize_ok') != -1)
				{
					var userMessage = function()
					{
	                    this.doApplySiteChanges(true);
					}.bind(this);
				}
				else
				{
					var userMessage = function()
					{
						Portal.API.dialogs.alert(Portal.API.templates.parseErrors('There was an error with the selected site settings', msg.data.errors), 'Error with Site Settings');
					}
				}
			}
			else
			{
				var userMessage = function()
				{
					Portal.API.dialogs.alert('There was an error processing your request.  Please try again later, or <a href="javascript: Portal.API.utils.openURL(\'http://support.aptana.com/asap\');">contact support</a> if you continue to have this problem', 'Settings failed');
				}
			}
			
			setTimeout(userMessage, 500);
		}
	},
	
	registerPoller: function registerPoller(msg)
	{
		var location = msg.data.location.replace(Portal.Vars.siteManagerUrl, '');
		var siteId = Portal.Modules.MyCloudPortal.currentSiteId;
		
		Portal.Data.siteList.activeResizes.set(siteId, location);
		Portal.Modules.MyCloudPortal.currentSite.resizing = true;
		
		var tempSite = Portal.Modules.MyCloudPortal.currentSite;
					
		tempSite.hostingPlanId = this.hostingPlanId;
		tempSite.hostingOptions = new Hash();
        this.optionIds.each(function(item)
        {
			tempSite.hostingOptions.set(item, parseInt(item));
			
        });
		
		Portal.Data.siteList.sites.set(tempSite.id, tempSite);
        
		Portal.Data.currentUser.fetchBillingAccounts();
		
		this._init();
		
        Portal.Pollers.register('siteResize', location, 
        {
			object: Portal.Data.siteList,
			method: 'pollResizeStatus',
			frequency: 30,
			args: [siteId],
			notifyEvent: 'resizePollerUpdated'
		});
	}
}

var SiteConfiguratorViews =
{
	_initViews: function _initViews()
	{
        View.load(
        {
			main:
			{
				file: 'portlets/cloud/templates/configurator_site/configurator_main.html',
				binding: function()
				{
					return $('configurator_site_cage');
				},
				behaviors: function()
				{
                    this.slider = new Control.Slider('configurator_handle', 'configurator_track', 
                    {
						range: $R(0, 3),
						values: $R(0, 3),
						onSlide: function(currentValue)
						{
							this.updateUsageDisplay(currentValue)
						}.bind(this),
						onChange: function(currentValue)
						{
							this.updateUsageDisplay(currentValue)
						}.bind(this)
					});
					
                    $$('td.hostingPlan').each(function(item)
                    {
                        $(item).observe('click', function(event)
                        {
							var value = Event.element(event).id.replace('hosting_plan_', '');
							
							value = parseInt(value);
							
							this.slider.setValue(value);
                        }.bind(this));
                    }.bind(this));
					
					this.slider.setValue(parseInt(this.hostingPlanId) - 1);
					
					$$('input.optionRadio').each(function(element)
                    {
						$(element).stopObserving('click');
                        $(element).observe('click', this.handleOptionSelect.bindAsEventListener(this));
                    }.bind(this));
					
					this.optionIds = [];
	
			        $$('input.optionRadio').each(function(item)
			        {
						if(item.checked)
						{
							this.optionIds.push(parseInt(item.value));
						}
			        }.bind(this));
					
					if($('new_billing_account'))
					{
	                    $('new_billing_account').observe('change', function()
	                    {
							if ($F('new_billing_account').value != '---')
							{
								$('current_card_controls').hide();
								$('original_card').show();
								$('billing_accounts_cage').hide();
								
								this.currentBillingAccount = Portal.Data.currentUser.billingAccounts.get(parseInt($F('new_billing_account')));
								
								$('apply_cage').show();
								$('apply_disabled_cage').hide();
								
								$('current_card').update('<div class="floatLeft" style="margin-right: 5px;"><img src="images_global/img_credit_cards.png" align="absmiddle" class="inline link" style="margin-top: 7px;" /></div> '
														+ '<div class="floatLeft gray48 size11" ><strong>Cardholder Name: </strong>' + this.currentBillingAccount.name + '<br /><strong>Card Number:</strong> ' + this.currentBillingAccount.number 
														+ ' <strong>Expiration Date:</strong> ' + this.currentBillingAccount.expiry + '</div><div class="clearfix"></div>').highlight();
							}
	                    }.bind(this));
					}
					
					this.loading = false;
					this.fetchOrderPreview();
					
				}.bind(this)
			},
			
			cloudSize:
			{
				file: 'portlets/cloud/templates/configurator_site/cloud_size.html'
			},
			
			monthlyOptions:
			{
				file: 'portlets/cloud/templates/configurator_site/monthly_options.html'
			},
			
			projectedCost:
			{
				file: 'portlets/cloud/templates/configurator_site/projected_cost.html'
			},
			
			paymentOptions:
			{
				file: 'portlets/cloud/templates/configurator_site/payment_options.html'
			}
		}, 
		function(templates)
        {
			this.templates = templates;
			
			var subTemplates = 
			{
				cloudSize: this.templates.cloudSize,
				paymentOptions: this.templates.paymentOptions,
				options: Portal.Data.cloudProducts.options,
				projectedCost: this.templates.projectedCost,
				monthlyOptions: this.templates.monthlyOptions,
				hostingData: { optionIds: this.currentOptionIds, hostingPlanId: this.currentHostingPlan },
				serviceTotal: this.serviceTotal,
				originalData: this.originalData,
				billingAccount: this.currentBillingAccount,
				originalBillingAccount: this.originalBillingAccount,
				isTrial: this.isTrial
			}
			try { 
			if(Portal.Modules.MyCloudPortal.currentSite.resizing == true)
			{
				$('resizing_site_cage').show();	
				$('delete_site_cage').hide();
				$('configurator_site_cage').hide();
			}
			else
			{
				$('resizing_site_cage').hide();	
				$('delete_site_cage').show();
				$('configurator_site_cage').show();
				this.templates.main.set('subTemplates', subTemplates);
			}
			}
			catch (e)
			{
				console.warn(e);
			}
			
        }.bind(this));
	}
}