var MembershipRolesClass = Class.create(
{
	initialize: function initialize()
	{
		this.loading	= true;
		this.roles		= new Hash();
	},
	
	finishInit: function()
	{
		EventManager.subscribe('/portal/cloud/roles/', 
		{
			channelHook: 'membershipRoles',
			onComplete: function()
			{
				Portal.Data.membershipRoles.fetchRoles();
			}
		});
		
        Portal.Modules.OnlineStatus.observe('onlineStatusChanged', function(isOnline)
        {
			this.loading = true;
			
			EventManager.subscribe('/portal/cloud/roles/', 
			{
				channelHook: 'membershipRoles',
				onComplete: function()
				{
					Portal.Data.membershipRoles.fetchRoles();
				}
			});
        }.bind(this));
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if(msg.data.response == 'listRoleTypes')
		{
			this.update(msg.data);
		}
	},
	
	update: function update(data)
	{
        data.types.each(function(type)
        {
			if(!this.roles.get(type.id))
			{
				var tempRole = new MembershipRoleClass(type);
			}
			else
			{
				var tempRole = this.roles.get(type.id);
				tempRole.update(type);
			}
			
			this.roles.set(type.id, tempRole);
			
			tempRole = null;
        }.bind(this));
		
		if(this.loading == true)
		{
			this.loading = false;
			this.notify('startupHookComplete');
		}
	},
	
	getRoleName: function getRoleName(roleId)
	{
		return this.roles.get(roleId).name;
	},
	
	fetchRoles: function()
	{
		EventManager.publish('/portal/cloud/roles', { request: 'listRoleTypes' });
	}
});

Object.Event.extend(MembershipRolesClass);

Portal.API.startup.registerStartupItem(6, 
{
	startupMessage: 'Loading cloud data...',
	onInit: function()
	{
		Portal.API.models.loadModel('membershipRoles', MembershipRolesClass, true);
	}
});

var MembershipRoleClass = Class.create(
{
	initialize: function initialize(data)
	{
		this.name	= '';
		this.id		= '';
		
		this.update(data)
	},
	
	update: function update(data)
	{
		if('name' in data)
		{
			this.name = data.name;
		}
		
		if('id' in data)
		{
			this.id = data.id;
		}
	}
});