var EventsClass = Class.create(
{
    initialize: function initialize()
    {
        this.loading = true;
        this.categories = new Hash();
        this.events = new Hash();
    },
    
    finishInit: function finishInit()
    {
        EventManager.subscribe('/portal/cloud/event_types', 
        {
            channelHook: 'events',
            onComplete: function()
            {
                EventManager.publish('/portal/cloud/model', 
                {
                    url: 'event_types',
                    request: 'describe',
                    returnChannel: '/portal/cloud/event_types'
                });
            }
        });
        
        Portal.Modules.OnlineStatus.observe('onlineStatusChanged', function(isOnline)
        {
			if(!isOnline)
			{
				return;
			}
			
			this.loading = true;
			EventManager.publish('/portal/cloud/model', 
            {
                url: 'event_types',
                request: 'describe',
                returnChannel: '/portal/cloud/event_types'
            });
			
        }.bind(this));
    },
    
    dispatchEvent: function dispatchEvent(msg)
    {
        if (msg.data.response == 'describe') 
        {
            this.update(msg.data);
        }
    },
    
    update: function update(data)
    {
        if (!('xmlData' in data) || !('event_types' in data.xmlData)) 
        {
            if (this.loading) 
            {
                this.loading = false;
                this.notify('startupHookComplete');
                return;
            }
        }
        
        data.xmlData.event_types.each(function(item)
        {
            var event = item.event_type;
            
            if (!event.subscribable) 
            {
                return;
            }
            
            // first grab the category, and see if it needs to be added to the list...
            if (!this.categories.get(event.category.id)) 
            {
                var tempCategory = new EventCategory(event.category);
                
                this.categories.set(tempCategory.id, tempCategory);
            }
            
            // injec this into a "better" place...
            event.category_id = event.category.id;
            
            // now look for the actual event...
            if (!this.events.get(event.id)) 
            {
                var tempEvent = new EventClass(event);
            }
            else 
            {
                var tempEvent = this.events.get(event.id);
                tempEvent.update(event);
            }
            
            this.events.set(event.id, tempEvent);
            
        }
.bind(this));
        
        
        if (this.loading) 
        {
            this.loading = false;
            this.notify('startupHookComplete');
        }
    },
    
    getName: function getName(eventId)
    {
        return this.events.get(eventId).name;
    },
    
    fetchByCategory: function fetchByCategory(categoryId)
    {
        var returnHash = new Hash();
        
        if (!this.categories.get(categoryId)) 
        {
            return returnHash;
        }
        
        this.events.each(function(event)
        {
            if (event.value.category_id == categoryId) 
            {
                returnHash.set(event.key, event.value);
            }
            
        }
.bind(this));
        
        return returnHash;
    }
});

var EventClass = Class.create(
{
    initialize: function initialize(data)
    {
        this.id = 0;
        this.severity_id = 0;
        this.category_id = 0;
        this.name = '';
        this.description = '';
        this.subscribable = false;
        
        this.update(data);
    },
    
    update: function update(data)
    {
        if ('id' in data) 
        {
            this.id = data.id;
        }
        
        if ('severity_id' in data) 
        {
            this.severity_id = data.severity_id;
        }
        
        if ('category_id' in data) 
        {
            this.category_id = data.category_id;
        }
        
        if ('name' in data) 
        {
            this.name = data.name;
        }
        
        if ('description' in data) 
        {
            this.description = data.description;
        }
        
        if ('subscribable' in data) 
        {
            this.subscribable = data.subscribable;
        }
    }
});

var EventCategory = Class.create(
{
    initialize: function initialize(data)
    {
        this.id = '';
        this.name = '';
        this.description = '';
        
        this.update(data);
    },
    
    update: function update(data)
    {
        if ('id' in data) 
        {
            this.id = data.id;
        }
        
        if ('name' in data) 
        {
            this.name = data.name;
        }
        
        if ('description' in data) 
        {
            this.description = data.description;
        }
    }
});


Object.Event.extend(EventsClass);

Portal.API.startup.registerStartupItem(9, 
{
    onInit: function()
    {
        Portal.API.models.loadModel('events', EventsClass, true);
    }
});
