var EventsClass = Class.create(
{
	initialize: function initialize()
	{
		this.loading 	= true;
		this.events 	= new Hash();
		
	},
	
	finishInit: function finishInit()
	{
		EventManager.subscribe('/portal/cloud/eventTypes/', 
        {
            channelHook: 'events',
			onComplete: function()
			{
				EventManager.publish('/portal/cloud/eventTypes', 
	            {
	                request: 'listEventTypes'
	            });
			}
        });
		
		this.notify('startupHookComplete');
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if(msg.data.response == 'listEventTypes')
		{
			this.update(msg.data);
		}
	},
	
	update: function update(data)
	{
        data.types.each(function(item)
        {
			if(!this.events.get(item.id))
			{
				var tempEvent = new EventClass(item);
			}
			else
			{
				var tempEvent = this.events.get(item.id);
				tempEvent.update(item);
			}
			
			this.events.set(item.id, tempEvent);
			
        }.bind(this));
		
		if(this.loading == true)
		{
			this.loading = false;
		}
	},
	
	getName: function getName(eventId)
	{
		var event = this.events.get(eventId);
		return event.name;
	}
});

Object.Event.extend(EventsClass);

Portal.API.startup.registerStartupItem(9, 
{
	onInit: function()
	{
		Portal.API.models.loadModel('events', EventsClass, true);
	}
});

var EventClass = Class.create(
{
	initialize: function initialize(data)
	{
		this.id		= '';
		this.name	= '';
		
		this.update(data);
	},
	
	update: function update(data)
	{
		if('id' in data)
		{
			this.id = data.id;
		}
		
		if('name' in data)
		{
			this.name = data.name;
		}
	}
});
