/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.validator;

import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.editor.xml.validator.XMLParser;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.errors.ErrorDescriptor;
import com.aptana.ide.editors.unified.errors.FileError;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.UnifiedErrorReporter;
import com.aptana.ide.editors.validator.ValidatorBase;
import com.aptana.xml.IErrorHandler;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;

public class XMLValidator
extends ValidatorBase
implements IErrorHandler {
    private XMLParser _xmlParser;
    private UnifiedErrorReporter _reporter;
    private String _path;

    public XMLParser getXMLParser() {
        if (this._xmlParser == null) {
            this._xmlParser = new XMLParser();
        }
        return this._xmlParser;
    }

    public IFileError[] parseForErrors(String path, String source, IFileSourceProvider sourceProvider, final boolean collectErrors, final boolean collectWarnings, final boolean collectInfos) {
        this._reporter = new UnifiedErrorReporter(sourceProvider);
        this._path = path;
        String ignoreErrors = XMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editors.HTMLEDITOR_IGNORE_PROBLEMS");
        ErrorDescriptor[] ds = ErrorDescriptor.deserializeErrorDescriptors((String)ignoreErrors);
        XMLParser xmlParser = this.getXMLParser();
        xmlParser.setErrorHandler(new IErrorHandler(){

            public void handleError(int line, int column, String message) {
                if (collectErrors) {
                    XMLValidator.this.handleError(line, column, message);
                }
            }

            public void handleInfo(int line, int column, String message) {
                if (collectInfos) {
                    XMLValidator.this.handleInfo(line, column, message);
                }
            }

            public void handleWarning(int line, int column, String message) {
                if (collectWarnings) {
                    XMLValidator.this.handleWarning(line, column, message);
                }
            }
        });
        ByteArrayInputStream in = new ByteArrayInputStream(source.getBytes());
        xmlParser.parse(in);
        IFileError[] errors = this._reporter.getErrors();
        ArrayList<IFileError> result = new ArrayList<IFileError>();
        int a = 0;
        while (a < errors.length) {
            IFileError fileError = errors[a];
            if (fileError instanceof FileError) {
                int b = 0;
                while (b < ds.length) {
                    if (!ds[b].matchesError((FileError)fileError)) {
                        ++b;
                        continue;
                    }
                    break;
                }
            } else {
                result.add(fileError);
            }
            ++a;
        }
        errors = new IFileError[result.size()];
        result.toArray(errors);
        return errors;
    }

    public void handleError(int line, int column, String message) {
        this._reporter.error(message, this._path, line + 1, "", column);
    }

    public void handleInfo(int line, int column, String message) {
        this._reporter.info(message, this._path, line + 1, "", column);
    }

    public void handleWarning(int line, int column, String message) {
        this._reporter.warning(message, this._path, line + 1, "", column);
    }
}

