/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.validator;

import com.aptana.xml.IErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler {
    private static final Pattern PARSE_ERROR_LINE_NUMBER = Pattern.compile(" line (\\d+)");
    private IErrorHandler _errorHandler;
    private Locator _locator;

    public void setErrorHandler(IErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    private void sendError(String message) {
        if (this._errorHandler != null) {
            int line = this._locator.getLineNumber();
            int column = this._locator.getColumnNumber();
            if (line == -1) {
                Matcher m = PARSE_ERROR_LINE_NUMBER.matcher(message);
                line = m.find() ? Integer.parseInt(m.group(1)) : 0;
            }
            this._errorHandler.handleError(line, column, message);
        }
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this._locator = locator;
    }

    public void parse(InputStream in) {
        block15: {
            block14: {
                try {
                    try {
                        SAXParserFactory factory = SAXParserFactory.newInstance();
                        factory.setNamespaceAware(true);
                        SAXParser saxParser = factory.newSAXParser();
                        saxParser.parse(in, (DefaultHandler)this);
                    }
                    catch (Exception e) {
                        this.sendError(e.getMessage());
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                break block15;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

