/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.outline;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.editor.xml.parsing.nodes.XMLElementNode;
import com.aptana.ide.views.outline.UnifiedOutlineProvider;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class XMLLabelProvider
extends LabelProvider
implements IPropertyChangeListener {
    private static final Image ELEMENT_ICON = XMLPlugin.getImage("icons/element_icon.gif");
    private String[] _attributeNames;

    public XMLLabelProvider() {
        IPreferenceStore prefStore = XMLPlugin.getDefault().getPreferenceStore();
        prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.getAttributeNameList();
    }

    private void getAttributeNameList() {
        IPreferenceStore prefStore = XMLPlugin.getDefault().getPreferenceStore();
        String result = prefStore.getString("com.aptana.ide.editor.xml.XMLEDITOR_OUTLINER_ATTRIBUTE_LIST");
        this._attributeNames = result.split("\\s+,\\s*|\\s*,\\s+|,|\\s+");
    }

    public Image getImage(Object element) {
        Image result = element instanceof XMLElementNode ? ELEMENT_ICON : super.getImage(element);
        return result;
    }

    public String getText(Object element) {
        String result;
        if (element instanceof XMLElementNode) {
            XMLElementNode node = (XMLElementNode)((Object)element);
            result = node.getName();
            if (this._attributeNames.length > 0) {
                ArrayList<String> values = new ArrayList<String>();
                int i = 0;
                while (i < this._attributeNames.length) {
                    String attributeName = this._attributeNames[i];
                    if (node.hasAttribute(attributeName)) {
                        values.add(node.getAttribute(attributeName));
                    }
                    ++i;
                }
                if (values.size() > 0) {
                    String[] valueStrings = values.toArray(new String[values.size()]);
                    result = String.valueOf(result) + " : " + StringUtils.join((String)" | ", (String[])valueStrings);
                }
            }
        } else {
            result = super.getText(element);
        }
        if (result != null) {
            try {
                result = result.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.aptana.ide.editor.xml.XMLEDITOR_OUTLINER_ATTRIBUTE_LIST")) {
            this.getAttributeNameList();
            UnifiedOutlineProvider.getInstance().refresh();
        }
    }
}

