/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.rcp;

import com.aptana.ide.core.BaseFileEditorInput;
import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.WorkbenchHelper;
import com.aptana.ide.rcp.ApplicationWorkbenchWindowAdvisor;
import com.aptana.ide.rcp.IdePlugin;
import com.aptana.ide.rcp.Messages;
import com.aptana.ide.rcp.main.MainPlugin;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.ide.IDEWorkbenchAdvisor;

public class ApplicationWorkbenchAdvisor
extends IDEWorkbenchAdvisor {
    private WorkbenchWindowAdvisor workbenchWindowAdvisor;
    private static final String PREFERENCE_OPEN_FILES = "com.aptana.ide.rcp.PREFERENCE_OPEN_FILES";
    private static final String PREFERENCE_FILE_DELIMETER = ";;;";

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        this.workbenchWindowAdvisor = new ApplicationWorkbenchWindowAdvisor(this, configurer);
        return this.workbenchWindowAdvisor;
    }

    WorkbenchWindowAdvisor getWorkbenchWindowAdvisor() {
        return this.workbenchWindowAdvisor;
    }

    public IStatus restoreState(IMemento memento) {
        return super.restoreState(memento);
    }

    public IStatus saveState(IMemento memento) {
        return super.saveState(memento);
    }

    public void postStartup() {
        try {
            IPreferenceStore prefStore = MainPlugin.getDefault().getPreferenceStore();
            if (prefStore != null && prefStore.getBoolean("com.aptana.ide.rcp.main.REOPEN_EDITORS_ON_STARTUP")) {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                ArrayList openFiles = this.getOpenEditors(windows);
                IPreferenceStore store = IdePlugin.getDefault().getPreferenceStore();
                String fileString = store.getString(PREFERENCE_OPEN_FILES);
                if (fileString != null) {
                    String[] files = fileString.split(PREFERENCE_FILE_DELIMETER);
                    int i = 0;
                    while (i < files.length) {
                        File f;
                        String file = files[i];
                        if (!"".equals(file) && (f = new File(file)).exists() && !openFiles.contains(file)) {
                            WorkbenchHelper.openFile((File)f, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)IdePlugin.getDefault(), (String)Messages.ApplicationWorkbenchAdvisor_ErrorPostStartup, (Throwable)ex);
        }
        super.postStartup();
    }

    public boolean preShutdown() {
        try {
            IPreferenceStore store = IdePlugin.getDefault().getPreferenceStore();
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            ArrayList openFiles = this.getOpenEditors(windows);
            String fileList = StringUtils.join((String)PREFERENCE_FILE_DELIMETER, (String[])openFiles.toArray(new String[0]));
            store.setValue(PREFERENCE_OPEN_FILES, fileList);
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)IdePlugin.getDefault(), (String)Messages.ApplicationWorkbenchAdvisor_ErrorPreShutdown, (Throwable)ex);
        }
        return super.preShutdown();
    }

    public ArrayList getOpenEditors(IWorkbenchWindow[] windows) {
        ArrayList openFiles = new ArrayList();
        int i = 0;
        while (i < windows.length) {
            ArrayList files = this.getOpenEditors(windows[i].getPages());
            openFiles.addAll(files);
            ++i;
        }
        return openFiles;
    }

    public ArrayList getOpenEditors(IWorkbenchPage[] pages) {
        ArrayList openFiles = new ArrayList();
        int i = 0;
        while (i < pages.length) {
            ArrayList files = this.getEditorReferences(pages[i]);
            openFiles.addAll(files);
            ++i;
        }
        return openFiles;
    }

    public ArrayList getEditorReferences(IWorkbenchPage page) {
        IEditorReference[] refs = page.getEditorReferences();
        if (refs == null) {
            return null;
        }
        ArrayList<String> openFiles = new ArrayList<String>();
        int i = 0;
        while (i < refs.length) {
            try {
                String path;
                IEditorInput input = refs[i].getEditorInput();
                if (input instanceof BaseFileEditorInput && !(path = ((BaseFileEditorInput)input).getPath().toOSString()).startsWith(FileUtils.systemTempDir)) {
                    openFiles.add(path);
                }
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)IdePlugin.getDefault(), (String)Messages.ApplicationWorkbenchAdvisor_ErrorGettingCurrentEditorReferences, (Throwable)e);
            }
            ++i;
        }
        return openFiles;
    }
}

