/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.runtime;

import com.aptana.ide.editor.scriptdoc.runtime.OpcodeType;
import com.aptana.ide.lexer.IRange;

public class Opcode {
    public final OpcodeType type;
    public final int fileIndex;
    public final int fileOffset;
    public final IRange range;
    public final Object value;

    public Opcode(OpcodeType type) {
        this(type, 0, 0, null, null);
    }

    public Opcode(OpcodeType type, int fileIndex) {
        this(type, fileIndex, 0, null, null);
    }

    public Opcode(OpcodeType type, int fileIndex, int fileOffset) {
        this(type, fileIndex, fileOffset, null, null);
    }

    public Opcode(OpcodeType type, int fileIndex, IRange range) {
        this(type, fileIndex, 0, range, null);
    }

    public Opcode(OpcodeType type, Object value) {
        this(type, 0, 0, null, value);
    }

    private Opcode(OpcodeType type, int fileIndex, int fileOffset, IRange range, Object value) {
        this.type = type;
        this.fileIndex = fileIndex;
        this.fileOffset = fileOffset;
        this.range = range;
        this.value = value;
    }

    public String toString() {
        String result;
        switch (this.type) {
            case DUPLICATE: {
                result = "duplicate";
                break;
            }
            case GET: {
                result = "get";
                break;
            }
            case GET_GLOBAL: {
                result = "get_global";
                break;
            }
            case INSTANTIATE: {
                result = "instantiate";
                break;
            }
            case INVOKE: {
                result = "invoke";
                break;
            }
            case NO_OPERATION: {
                result = "no_operation";
                break;
            }
            case POP: {
                result = "pop";
                break;
            }
            case PUSH: {
                if (this.value instanceof String) {
                    result = "push '" + this.value.toString() + "'";
                    break;
                }
                result = "push " + this.value.toString();
                break;
            }
            case PUSH_ARRAY: {
                result = "push_array";
                break;
            }
            case PUSH_BOOLEAN: {
                result = "push_boolean";
                break;
            }
            case PUSH_NULL: {
                result = "push_null";
                break;
            }
            case PUSH_NUMBER: {
                result = "push_number";
                break;
            }
            case PUSH_OBJECT: {
                result = "push_object";
                break;
            }
            case PUSH_REGEXP: {
                result = "push_regexp";
                break;
            }
            case PUSH_STRING: {
                result = "push_string";
                break;
            }
            case PUT: {
                result = "put";
                break;
            }
            case SWAP: {
                result = "swap";
                break;
            }
            default: {
                result = "unknown";
            }
        }
        return result;
    }
}

