/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.contentassist;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.scriptdoc.contentassist.Messages;
import com.aptana.ide.editor.scriptdoc.contentassist.ScriptDocCompletionProposal;
import com.aptana.ide.editor.scriptdoc.contentassist.ScriptDocCompletionProposalComparator;
import com.aptana.ide.editors.unified.EditorFileContext;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ScriptDocContentAssistProcessor
implements IContentAssistProcessor {
    boolean initalPopup = false;
    private ISourceViewer sourceViewer;
    private EditorFileContext context;
    private static Image fIcon = ScriptDocContentAssistProcessor.getImageDescriptor("icons/at.gif").createImage();
    static String[][] tagDocs = new String[][]{{"alias", "alias", Messages.ScriptDocContentAssistProcessor_Alias}, {"author", "author-name", Messages.ScriptDocContentAssistProcessor_Author}, {"classDescription", "description", Messages.ScriptDocContentAssistProcessor_Description}, {"constructor", "", Messages.ScriptDocContentAssistProcessor_Ctor}, {"copyright", "description", Messages.ScriptDocContentAssistProcessor_Copyright}, {"deprecated", "[description]", Messages.ScriptDocContentAssistProcessor_Deprecated}, {"exception", "[{type-name[,type-name]}] [description]", Messages.ScriptDocContentAssistProcessor_Exception}, {"extends", "{type-name[,type-name]} [description]", Messages.ScriptDocContentAssistProcessor_Extends}, {"id", "type-name", Messages.ScriptDocContentAssistProcessor_Id}, {"license", "description", Messages.ScriptDocContentAssistProcessor_License}, {"memberOf", "{type-name}", Messages.ScriptDocContentAssistProcessor_MemberOf}, {"method", "[method-name]", Messages.ScriptDocContentAssistProcessor_Method}, {"namespace", "dotted name", Messages.ScriptDocContentAssistProcessor_Namespace}, {"param", "param-name [{type-name[,type-name]}] [description]", Messages.ScriptDocContentAssistProcessor_Param}, {"private", "", "Signify that a function or property is not meant to be visible outside its container."}, {"projectDescription", "", Messages.ScriptDocContentAssistProcessor_ProjectDescription}, {"property", "", Messages.ScriptDocContentAssistProcessor_Property}, {"return", "[{type-name[,type-name]}] [description]", Messages.ScriptDocContentAssistProcessor_Return}, {"sdoc", "path", Messages.ScriptDocContentAssistProcessor_Sdoc}, {"see", "type-name/method-name#", Messages.ScriptDocContentAssistProcessor_See}, {"since", "version", Messages.ScriptDocContentAssistProcessor_Since}, {"type", "[{type-name[,type-name]}] [description]", Messages.ScriptDocContentAssistProcessor_Type}, {"version", "version-number", Messages.ScriptDocContentAssistProcessor_Version}};

    public ScriptDocContentAssistProcessor(EditorFileContext context, SourceViewer sourceViewer) {
        this.context = context;
        this.sourceViewer = sourceViewer;
        Arrays.sort(tagDocs, new ScriptDocCompletionProposalComparator());
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String source = this.context.getSource();
        int beginOffset = source.lastIndexOf(64, offset);
        int beginSpace = source.indexOf(32, beginOffset);
        int cr = source.indexOf(10, beginOffset);
        beginSpace = Math.min(beginSpace, cr);
        if (beginOffset == -1) {
            return null;
        }
        if (beginSpace != -1 && beginSpace < offset) {
            return null;
        }
        int lastNewline = source.lastIndexOf(10, beginOffset);
        if (lastNewline > beginOffset) {
            return null;
        }
        String prefix = "";
        String text = "";
        int start = beginOffset + 1;
        try {
            int length = offset - start;
            if (length < 0) {
                prefix = "";
            } else {
                prefix = this.sourceViewer.getDocument().get(start, length).trim().toLowerCase();
                text = this.sourceViewer.getDocument().get(start, beginSpace - start).trim().toLowerCase();
            }
        }
        catch (BadLocationException e) {
            IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)Messages.ScriptDocContentAssistProcessor_ErrorComputingCompletionProposals, (Throwable)e);
        }
        ArrayList<ScriptDocCompletionProposal> list = new ArrayList<ScriptDocCompletionProposal>();
        ScriptDocCompletionProposal defaultProp = null;
        int i = 0;
        while (i < tagDocs.length) {
            String name = tagDocs[i][0];
            String desc = "<b>@" + tagDocs[i][0] + "</b> <i>" + tagDocs[i][1] + "</i><p><p>" + tagDocs[i][2];
            String insertedName = name;
            ScriptDocCompletionProposal sdoc = new ScriptDocCompletionProposal(insertedName, start, text.length(), insertedName.length(), fIcon, name, null, desc, 0);
            list.add(sdoc);
            if (defaultProp == null && name.compareToIgnoreCase(prefix) >= 0) {
                defaultProp = sdoc;
            }
            ++i;
        }
        if (defaultProp != null) {
            defaultProp.setDefaultSelection(true);
        }
        if (list.size() == 0) {
            return null;
        }
        ICompletionProposal[] sda = list.toArray(new ScriptDocCompletionProposal[list.size()]);
        return sda;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'@'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private static ImageDescriptor getImageDescriptor(String imageFilePath) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.ide.editors", (String)imageFilePath);
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }
}

