/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.js.JSLanguageEnvironment;
import com.aptana.ide.editor.js.JSOffsetMapper;
import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.JSScope;
import com.aptana.ide.editor.js.runtime.JSUndefined;
import com.aptana.ide.editor.js.runtime.Property;
import com.aptana.ide.editor.scriptdoc.parsing.ScriptDocParseState;
import com.aptana.ide.editors.managers.EnvironmentManager;
import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.editors.unified.ChildOffsetMapper;
import com.aptana.ide.editors.unified.IChildOffsetMapper;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.metadata.IDocumentation;
import com.aptana.ide.metadata.IDocumentationStore;
import com.aptana.ide.parsing.CodeLocation;
import com.aptana.ide.parsing.ICodeLocation;
import java.util.Map;

public class ScriptDocOffsetMapper
extends ChildOffsetMapper
implements IChildOffsetMapper {
    public ScriptDocOffsetMapper(IParentOffsetMapper parent) {
        super(parent);
    }

    public ICodeLocation findTarget(Lexeme lexeme) {
        ICodeLocation codeLoc = this.getIDTargetFromOffset(lexeme);
        return codeLoc;
    }

    private ICodeLocation getIDTargetFromOffset(Lexeme lexeme) {
        ICodeLocation result = null;
        ScriptDocParseState ps = (ScriptDocParseState)this.getFileService().getParseState().getParseState("text/scriptdoc");
        Lexeme lastLexeme = this.getLastDocLexeme(ps, lexeme);
        int offset = lastLexeme.getEndingOffset();
        if (offset == -1) {
            return null;
        }
        String type = this.getTypeName(ps, lexeme);
        result = !type.equals("") ? this.getType(type, lexeme) : this.getID(ps, lexeme, offset);
        return result;
    }

    private ICodeLocation getType(String fullName, Lexeme lexeme) {
        ICodeLocation result = null;
        Environment jsEnv = (Environment)JSLanguageEnvironment.getInstance().getRuntimeEnvironment();
        JSScope global = jsEnv.getGlobal();
        Property prop = global.getProperty(fullName);
        if (prop == null) {
            return null;
        }
        IObject obj = prop.getValue(Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (obj == JSUndefined.getSingletonInstance()) {
            return null;
        }
        result = JSOffsetMapper.findTargetFromName(obj, prop);
        return result;
    }

    private ICodeLocation getID(ScriptDocParseState ps, Lexeme lexeme, int offset) {
        CodeLocation result = null;
        IDocumentationStore store = ps.getDocumentationStore();
        IDocumentation doc = store.getDocumentationFromOffset(offset);
        String[] ids = doc.getIDs();
        if (doc != null && ids.length > 0) {
            String id = ids[0];
            Map idMap = EnvironmentManager.getDocumentationIdMap();
            if (idMap.containsKey(id)) {
                IDocumentation mapDoc = (IDocumentation)idMap.get(id);
                CodeLocation[] locs = mapDoc.getID(id);
                int i = 0;
                while (i < locs.length) {
                    CodeLocation location = locs[i];
                    String locationURI = CoreUIUtils.getURI((String)location.getFullPath());
                    String psURI = FileContextManager.getURIFromFileIndex((int)ps.getFileIndex());
                    if (location.getStartLexeme().getEndingOffset() != lexeme.getEndingOffset() || !locationURI.equals(psURI)) {
                        result = location;
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private String getTypeName(ScriptDocParseState ps, Lexeme lexeme) {
        String result = "";
        Lexeme orgLexeme = lexeme;
        LexemeList ll = ps.getLexemeList();
        int index = ll.getLexemeIndex(lexeme);
        while (lexeme != null && lexeme.getLanguage().equals("text/scriptdoc")) {
            if (lexeme.typeIndex != 42 && lexeme.typeIndex != 39 && lexeme.typeIndex != 41) {
                if (lexeme.typeIndex != 33) break;
                result = orgLexeme.getText();
                break;
            }
            index = index == 0 ? 0 : index;
            if (index <= 0) break;
            lexeme = ll.get(--index);
        }
        return result;
    }

    private Lexeme getLastDocLexeme(ScriptDocParseState ps, Lexeme lexeme) {
        Lexeme result = null;
        LexemeList ll = ps.getLexemeList();
        int index = ll.getLexemeIndex(lexeme);
        while (lexeme != null && lexeme.getLanguage().equals("text/scriptdoc")) {
            if (lexeme.typeIndex == 32) {
                result = lexeme;
                break;
            }
            if (index >= ll.size()) break;
            lexeme = ll.get(++index);
        }
        return result;
    }
}

