/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.scriptdoc.ScriptDocFileLanguageService;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.BaseFileServiceFactory;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.ParentOffsetMapper;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import org.eclipse.core.runtime.Plugin;

public final class ScriptDocFileServiceFactory
extends BaseFileServiceFactory {
    private static ScriptDocFileServiceFactory instance;

    private ScriptDocFileServiceFactory() {
    }

    public static ScriptDocFileServiceFactory getInstance() {
        if (instance == null) {
            instance = new ScriptDocFileServiceFactory();
        }
        return instance;
    }

    public FileService createFileService(IFileSourceProvider sourceProvider, boolean parse) {
        IParser parser = this.createParser();
        IParser scanner = null;
        IParseState parseState = parser.createParseState(null);
        FileService fileService = new FileService(parser, parseState, sourceProvider, "text/scriptdoc");
        fileService.setScanner(scanner);
        ParentOffsetMapper mapper = new ParentOffsetMapper(fileService);
        ScriptDocFileLanguageService languageService = new ScriptDocFileLanguageService(fileService, parseState, parser, (IParentOffsetMapper)mapper);
        fileService.addLanguageService("text/scriptdoc", (IFileLanguageService)languageService);
        if (parse) {
            fileService.doFullParse();
        }
        return fileService;
    }

    protected IParser createParser() {
        IParser parser = LanguageRegistry.getParser((String)"text/scriptdoc");
        if (parser == null) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)"Unable to create parser. Parser for MIME type {0} not registered in LanguageRegistry", (String)"text/scriptdoc"));
        }
        return parser;
    }

    protected IParser createScanner() {
        IParser result = null;
        if (UnifiedEditorsPlugin.getDefault().useFastScan()) {
            result = LanguageRegistry.getScanner((String)"text/scriptdoc");
        }
        return result;
    }
}

