/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.jscomment;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.jscomment.JSCommentFileLanguageService;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.BaseFileServiceFactory;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.ParentOffsetMapper;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import org.eclipse.core.runtime.Plugin;

public final class JSCommentFileServiceFactory
extends BaseFileServiceFactory {
    private static JSCommentFileServiceFactory instance;

    private JSCommentFileServiceFactory() {
    }

    public static JSCommentFileServiceFactory getInstance() {
        if (instance == null) {
            instance = new JSCommentFileServiceFactory();
        }
        return instance;
    }

    public FileService createFileService(IFileSourceProvider sourceProvider, boolean parse) {
        IParser parser = this.createParser();
        IParser scanner = null;
        IParseState parseState = parser.createParseState(null);
        FileService fileService = new FileService(parser, parseState, sourceProvider, "text/jscomment");
        fileService.setScanner(scanner);
        ParentOffsetMapper mapper = new ParentOffsetMapper(fileService);
        JSCommentFileLanguageService languageService = new JSCommentFileLanguageService(fileService, parseState, parser, (IParentOffsetMapper)mapper);
        fileService.addLanguageService("text/jscomment", (IFileLanguageService)languageService);
        if (parse) {
            fileService.doFullParse();
        }
        return fileService;
    }

    protected IParser createParser() {
        IParser parser = LanguageRegistry.getParser((String)"text/jscomment");
        if (parser == null) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)"Unable to create parser. Parser for MIME type {0} not registered in LanguageRegistry", (String)"text/jscomment"));
        }
        return parser;
    }

    protected IParser createScanner() {
        IParser result = null;
        if (UnifiedEditorsPlugin.getDefault().useFastScan()) {
            result = LanguageRegistry.getScanner((String)"text/jscomment");
        }
        return result;
    }
}

