/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.validator;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.Messages;
import com.aptana.ide.editor.js.validator.JSValidationUtils;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.errors.FileError;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.UnifiedErrorReporter;
import com.aptana.ide.editors.validator.ValidatorBase;
import com.aptana.ide.epl.Activator;
import com.aptana.ide.lexer.Range;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSLintValidator
extends ValidatorBase {
    static String jsLintString = JSLintValidator.getResourceText("fulljslint.js");
    static Script JSLintScript = null;
    private static String LINE_DELIM = System.getProperty("line.separator", "\r\n");
    private static Class<?> codegenClass = Kit.classOrNull((String)"org.mozilla.javascript.optimizer.Codegen");

    public JSLintValidator() {
        if (JSLintScript == null) {
            JSLintScript = JSLintValidator.getJSLintScript(jsLintString);
        }
    }

    public IFileError[] parseForErrors(String path, String source, IFileSourceProvider sourceProvider, boolean collectErrors, boolean collectWarnings, boolean collectInfos) {
        IFileError[] errors;
        IFileError[] err = new IFileError[]{};
        UnifiedErrorReporter reporter = new UnifiedErrorReporter(sourceProvider);
        reporter.addErrors(err);
        ArrayList<Range> ranges = new ArrayList<Range>();
        Context cx = Context.enter();
        try {
            try {
                source = JSValidationUtils.filterPIInstructions(source, ranges);
                cx.setErrorReporter((ErrorReporter)reporter);
                if (collectErrors || collectWarnings) {
                    this.lintScript(JSLintScript, cx, source, path, collectErrors, collectWarnings);
                }
            }
            catch (Exception e) {
                IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)Messages.JSErrorManager_ParseForErrorsFailed, (Throwable)e);
            }
        }
        finally {
            Context.exit();
        }
        if ((errors = JSValidationUtils.filterErrors(source, reporter, ranges)) != null) {
            int i = 0;
            while (i < errors.length) {
                block16: {
                    try {
                        IFileError currError = errors[i];
                        int offset = currError.getOffset();
                        if (offset < source.length() && (offset > source.length() || LINE_DELIM.indexOf(source.charAt(offset)) == -1) || !(currError instanceof FileError)) break block16;
                        if (offset > source.length()) {
                            offset = source.length();
                        }
                        int j = offset = offset == source.length() ? offset - 1 : offset;
                        while (j >= 0) {
                            if (LINE_DELIM.indexOf(source.charAt(j)) == -1) {
                                ((FileError)currError).setOffset(j);
                                ((FileError)currError).setLineNumber(sourceProvider.getLineOfOffset(currError.getOffset()) + 1);
                                break;
                            }
                            --j;
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)"Error running JavaScript lint script", (Throwable)e);
                    }
                }
                ++i;
            }
        }
        try {
            return errors;
        }
        catch (Throwable th) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"Novalidate filtering failed", (Throwable)th);
            return errors;
        }
    }

    private void lintScript(Script JSLintScript, Context cx, String script, String path, boolean collectErrors, boolean collectWarnings) {
        ScriptableObject scope = cx.initStandardObjects();
        JSLintScript.exec(cx, (Scriptable)scope);
        Object fObj = scope.get("jslint", (Scriptable)scope);
        if (!(fObj instanceof Function)) {
            IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)Messages.JSErrorManager_JSLintUndefined);
        } else {
            Object[] functionArgs = new Object[]{script, scope.get("aptanaOptions", (Scriptable)scope)};
            Function f = (Function)fObj;
            f.call(cx, (Scriptable)scope, (Scriptable)scope, functionArgs).toString();
            Object errorObject = f.get("errors", (Scriptable)scope);
            if (errorObject != null && errorObject instanceof NativeArray) {
                NativeArray errorArray = (NativeArray)errorObject;
                Object[] ids = errorArray.getIds();
                if (ids.length == 0) {
                    return;
                }
                boolean lastIsError = false;
                NativeObject last = (NativeObject)errorArray.get(Integer.parseInt(ids[ids.length - 1].toString()), (Scriptable)scope);
                if (last == null) {
                    lastIsError = true;
                }
                if (!lastIsError && !collectWarnings) {
                    return;
                }
                int i = 0;
                while (i < ids.length) {
                    try {
                        NativeObject v = (NativeObject)errorArray.get(Integer.parseInt(ids[i].toString()), (Scriptable)scope);
                        if (v != null) {
                            int line = (int)Double.parseDouble(v.get("line", (Scriptable)scope).toString()) + 1;
                            String reason = v.get("reason", (Scriptable)scope).toString().trim();
                            int character = (int)Double.parseDouble(v.get("character", (Scriptable)scope).toString());
                            String evidence = v.get("evidence", (Scriptable)scope).toString().trim();
                            UnifiedErrorReporter rep = (UnifiedErrorReporter)cx.getErrorReporter();
                            if (i == ids.length - 2 && lastIsError) {
                                if (collectErrors) {
                                    rep.error(reason, path, line, evidence, character);
                                }
                            } else if (collectWarnings) {
                                rep.warning(reason, path, line, evidence, character);
                            }
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)"Error running JavaScript lint script", (Throwable)e);
                    }
                    ++i;
                }
            }
        }
    }

    private static Script getJSLintScript(String jsLintSourceString) {
        Context cx = Context.enter();
        try {
            Script result;
            CompilerEnvirons compilerEnv = new CompilerEnvirons();
            compilerEnv.initFromContext(cx);
            Parser p = new Parser(compilerEnv, cx.getErrorReporter());
            ScriptOrFnNode tree = p.parse(jsLintSourceString, "fulljslint.js", 1);
            String encodedSource = p.getEncodedSource();
            Interpreter compiler = JSLintValidator.createCompiler();
            Object bytecode = compiler.compile(compilerEnv, tree, encodedSource, false);
            Script script = result = compiler.createScriptObject(bytecode, null);
            return script;
        }
        catch (EvaluatorException e) {
            IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)Messages.JSErrorManager_JSLintFailed, (Throwable)e);
        }
        catch (Exception e) {
            if (!(e instanceof InterruptedException)) {
                IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)Messages.JSErrorManager_JSLintFailed, (Throwable)e);
            }
        }
        finally {
            Context.exit();
        }
        return null;
    }

    private static Interpreter createCompiler() {
        int optimizationLevel = codegenClass != null ? 0 : -1;
        Interpreter result = null;
        if (optimizationLevel >= 0 && codegenClass != null) {
            result = (Interpreter)JSLintValidator.newInstanceOrNull(codegenClass);
        }
        if (result == null) {
            result = new Interpreter();
        }
        return result;
    }

    static Object newInstanceOrNull(Class<?> cl) {
        try {
            return cl.newInstance();
        }
        catch (SecurityException securityException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return null;
    }

    private static String getResourceText(String name) {
        try {
            String fullName = "/com/aptana/ide/editor/js/" + name;
            InputStream stream = Activator.class.getResourceAsStream(fullName);
            StringWriter sw = new StringWriter();
            try {
                InputStreamReader isr = new InputStreamReader(stream);
                BufferedReader reader = new BufferedReader(isr);
                char[] buf = new char[1024];
                int numRead = reader.read(buf);
                while (numRead != -1) {
                    sw.write(buf, 0, numRead);
                    numRead = reader.read(buf);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            return sw.toString();
        }
        catch (Exception e) {
            if (!(e instanceof InterruptedException)) {
                IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.JSErrorManager_GetResourceTextFailed, (String)name), (Throwable)e);
            }
            return null;
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        if (PluginUtils.isPluginLoaded((Plugin)JSPlugin.getDefault())) {
            return JSPlugin.getDefault().getPreferenceStore();
        }
        return null;
    }
}

