/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.runtime;

import com.aptana.ide.editor.js.runtime.IFunction;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.JSArrayConstructor;
import com.aptana.ide.editor.js.runtime.JSBooleanConstructor;
import com.aptana.ide.editor.js.runtime.JSDateConstructor;
import com.aptana.ide.editor.js.runtime.JSErrorConstructor;
import com.aptana.ide.editor.js.runtime.JSFunctionConstructor;
import com.aptana.ide.editor.js.runtime.JSNull;
import com.aptana.ide.editor.js.runtime.JSNumberConstructor;
import com.aptana.ide.editor.js.runtime.JSObjectConstructor;
import com.aptana.ide.editor.js.runtime.JSRegExpConstructor;
import com.aptana.ide.editor.js.runtime.JSScope;
import com.aptana.ide.editor.js.runtime.JSStringConstructor;
import com.aptana.ide.editor.js.runtime.JSUndefined;
import com.aptana.ide.editor.js.runtime.Messages;
import com.aptana.ide.editor.js.runtime.NativeMath;
import com.aptana.ide.editor.js.runtime.ObjectBase;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.parsing.IRuntimeEnvironment;
import com.aptana.ide.parsing.nodes.ParseNodeBase;

public class Environment
implements IRuntimeEnvironment {
    private JSScope _global;
    private JSFunctionConstructor _jsFunctionConstructor;
    private JSObjectConstructor _jsObjectConstructor;
    private JSArrayConstructor _jsArrayConstructor;
    private JSBooleanConstructor _jsBooleanConstructor;
    private JSDateConstructor _jsDateConstructor;
    private JSErrorConstructor _jsErrorConstructor;
    private JSNumberConstructor _jsNumberConstructor;
    private JSRegExpConstructor _jsRegExpConstructor;
    private JSStringConstructor _jsStringConstructor;

    public JSScope getGlobal() {
        return this._global;
    }

    private IObject createInstance(String name, int fileIndex, IRange sourceRegion) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(Messages.Environment_CtorNameMustBeDefined);
        }
        if (sourceRegion == null) {
            throw new IllegalArgumentException(Messages.Environment_RegionMustNotBeNull);
        }
        int offset = sourceRegion.getStartingOffset();
        IFunction constructor = (IFunction)((Object)this._global.getPropertyValue(name, fileIndex, offset));
        return constructor.construct(this, new IObject[0], fileIndex, sourceRegion);
    }

    public IObject createArray(int fileIndex, IRange sourceRegion) {
        return this.createInstance("Array", fileIndex, sourceRegion);
    }

    public IObject createBoolean(int fileIndex, IRange sourceRegion) {
        return this.createInstance("Boolean", fileIndex, sourceRegion);
    }

    public IObject createDate(int fileIndex, IRange sourceRegion) {
        return this.createInstance("Date", fileIndex, sourceRegion);
    }

    public IObject createError(int fileIndex, IRange sourceRegion) {
        return this.createInstance("Error", fileIndex, sourceRegion);
    }

    public IObject createFunction(int fileIndex, IRange sourceRegion) {
        return this.createInstance("Function", fileIndex, sourceRegion);
    }

    public JSNull createNull() {
        return ObjectBase.NULL;
    }

    public IObject createNumber(int fileIndex, IRange sourceRegion) {
        return this.createInstance("Number", fileIndex, sourceRegion);
    }

    public IObject createObject(int fileIndex, IRange sourceRegion) {
        return this.createInstance("Object", fileIndex, sourceRegion);
    }

    public IObject createRegExp(int fileIndex, IRange sourceRegion) {
        return this.createInstance("RegExp", fileIndex, sourceRegion);
    }

    public IObject createString(int fileIndex, IRange sourceRegion) {
        return this.createInstance("String", fileIndex, sourceRegion);
    }

    public JSUndefined createUndefined() {
        return ObjectBase.UNDEFINED;
    }

    public JSScope initBuiltInObjects() {
        this._global = new JSScope();
        this._jsObjectConstructor = new JSObjectConstructor(this);
        this._jsFunctionConstructor = new JSFunctionConstructor(this);
        this._jsArrayConstructor = new JSArrayConstructor(this);
        this._jsBooleanConstructor = new JSBooleanConstructor(this);
        this._jsDateConstructor = new JSDateConstructor(this);
        this._jsErrorConstructor = new JSErrorConstructor(this);
        this._jsNumberConstructor = new JSNumberConstructor(this);
        this._jsRegExpConstructor = new JSRegExpConstructor(this);
        this._jsStringConstructor = new JSStringConstructor(this);
        this._jsObjectConstructor.initializeProperties();
        this._jsFunctionConstructor.initializeProperties();
        this._jsArrayConstructor.initializeProperties();
        this._jsBooleanConstructor.initializeProperties();
        this._jsDateConstructor.initializeProperties();
        this._jsErrorConstructor.initializeProperties();
        this._jsNumberConstructor.initializeProperties();
        this._jsRegExpConstructor.initializeProperties();
        this._jsStringConstructor.initializeProperties();
        new NativeMath(this);
        return this._global;
    }

    public void addId(String id, int fileIndex, ParseNodeBase hn) {
    }

    public String[] getAllIds() {
        return new String[0];
    }

    public void removeFileIds(int fileIndex) {
    }
}

