/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.formatting;

import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.ui.editors.preferences.formatter.DefaultCodeFormatterConstants;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;

public class JSCodeFormatterOptions {
    public static final int END_LINE = 0;
    public static final int NEXT_LINE = 1;
    public static final int NEXT_LINE_SHIFTED = 2;
    public boolean insertNewLineBeforeElse;
    public boolean insertNewLineBeforeCatch;
    public boolean insertNewLineBeforeFinally;
    public boolean insertNewLineBeforeWhile;
    public boolean insertNewLineBeforeReturn;
    public boolean insertNewLineBeforeIf;
    public boolean keepThenSameLine;
    public boolean keepSimpleIfOnOneLine;
    public boolean keepElseStatementOnSameLine;
    public boolean compactElseIf;
    public boolean keepGuardianClauseOnOneLine;
    public String formatterTabChar;
    public int tabSize;
    public boolean indentStatementsCompareToBody;
    public boolean indentStatementsCompareToBlock;
    public boolean indentStatementsCompareToSwitch;
    public boolean indentStatementsCompareToCases;
    public boolean indentBreaksCompareToCases;
    public boolean indentEmptyLines;
    public int blankLinesBeforeMethod = 1;
    public int blankLinesInStartOfMethodBody;
    public boolean preserveLineBreaks;
    public int formatterBracePositionForMethodDecl;
    public int formatterBracePositionForBlock;
    public int formatterBracePositionForBlockInCase;
    public int formatterBracePositionForBlockInSwitch;
    public int formatterBracePositionForArrayInitializer;
    public boolean keepEmptyArrayInitializerOnOneLine;
    public boolean addSpaceAfterFunctionDeclaration;
    public boolean doFormatting = true;

    public JSCodeFormatterOptions() {
        this.initFromPreferences();
    }

    public static Map getCompactJSOptionsMap() {
        Map javaConventionsSettings = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.compact_else_if", Boolean.TRUE.toString());
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_return_statement", Boolean.FALSE.toString());
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_if_statement", Boolean.FALSE.toString());
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_else_in_if_statement", Boolean.FALSE.toString());
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.keep_then_statement_on_same_line", Boolean.FALSE.toString());
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.keep_imple_if_on_one_line", Boolean.FALSE.toString());
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.keep_else_statement_on_same_line", Boolean.TRUE.toString());
        return javaConventionsSettings;
    }

    public static Map getKeepThenMap() {
        Map javaConventionsSettings = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.keep_then_statement_on_same_line", Boolean.TRUE.toString());
        return javaConventionsSettings;
    }

    public static Map getKeepSimpleIfMap() {
        Map javaConventionsSettings = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.keep_imple_if_on_one_line", Boolean.TRUE.toString());
        return javaConventionsSettings;
    }

    public static Map getKeepSimpleIfMap1() {
        Map javaConventionsSettings = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_return_statement", Boolean.FALSE.toString());
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.keep_imple_if_on_one_line", Boolean.TRUE.toString());
        return javaConventionsSettings;
    }

    public static Map getKeepElseIfMap() {
        Map javaConventionsSettings = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.compact_else_if", Boolean.TRUE.toString());
        return javaConventionsSettings;
    }

    public static Map getKeepGuardianMap() {
        Map javaConventionsSettings = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        javaConventionsSettings.put("com.aptana.ide.editors.codeassist.formatter.format_guardian_clause_on_one_line", Boolean.TRUE.toString());
        return javaConventionsSettings;
    }

    private void initFromPreferences() {
        IPreferenceStore preferenceStore = JSPlugin.getDefault().getPreferenceStore();
        this.insertNewLineBeforeReturn = this.parseInsert(preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_return_statement"));
        this.insertNewLineBeforeIf = this.parseInsert(preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_if_statement"));
        this.insertNewLineBeforeElse = this.parseInsert(preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_else_in_if_statement"));
        this.insertNewLineBeforeCatch = this.parseInsert(preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_catch_in_try_statement"));
        this.insertNewLineBeforeFinally = this.parseInsert(preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_finally_in_try_statement"));
        this.insertNewLineBeforeWhile = this.parseInsert(preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_while_in_do_statement"));
        this.keepThenSameLine = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.keep_then_statement_on_same_line");
        this.keepSimpleIfOnOneLine = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.keep_imple_if_on_one_line");
        this.keepElseStatementOnSameLine = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.keep_else_statement_on_same_line");
        this.compactElseIf = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.compact_else_if");
        this.keepGuardianClauseOnOneLine = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.format_guardian_clause_on_one_line");
        this.formatterTabChar = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
        this.tabSize = preferenceStore.getInt("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
        this.indentStatementsCompareToBody = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_body");
        this.indentStatementsCompareToBlock = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_block");
        this.indentStatementsCompareToSwitch = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_switch");
        this.indentStatementsCompareToCases = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_cases");
        this.indentBreaksCompareToCases = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_breaks_compare_to_cases");
        this.indentEmptyLines = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_empty_lines");
        this.blankLinesBeforeMethod = preferenceStore.getInt("com.aptana.ide.editors.codeassist.formatter.blank_lines_before_method");
        this.blankLinesInStartOfMethodBody = preferenceStore.getInt("com.aptana.ide.editors.codeassist.formatter.number_of_blank_lines_at_beginning_of_method_body");
        this.preserveLineBreaks = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns");
        this.formatterBracePositionForMethodDecl = this.parseOption(preferenceStore, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_method_declaration");
        this.formatterBracePositionForBlock = this.parseOption(preferenceStore, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_block");
        this.formatterBracePositionForBlockInCase = this.parseOption(preferenceStore, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_block_in_case");
        this.formatterBracePositionForBlockInSwitch = this.parseOption(preferenceStore, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_switch");
        this.formatterBracePositionForArrayInitializer = this.parseOption(preferenceStore, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_array_initializer");
        this.keepEmptyArrayInitializerOnOneLine = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.keep_empty_array_initializer_on_one_line");
        this.addSpaceAfterFunctionDeclaration = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.insert_space_after_closing_brace_in_block");
        String string = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant");
        if (string.length() > 0) {
            this.doFormatting = false;
        }
    }

    public final int parseOption(IPreferenceStore store, String id) {
        String string = store.getString(id);
        return this.parseOption(string);
    }

    private int parseOption(String string) {
        if (string == null) {
            return 2;
        }
        if (string.equals("end_of_line")) {
            return 0;
        }
        if (string.equals("next_line")) {
            return 1;
        }
        return 2;
    }

    public final int parseOption(Map store, String id) {
        return this.parseOption((String)store.get(id));
    }

    public final int parseOption(IEclipsePreferences store, String id) {
        return this.parseOption(store.get(id, null));
    }

    public JSCodeFormatterOptions(Map map, IProject project) {
        if (project != null) {
            IEclipsePreferences preferences = new ProjectScope(project).getNode(JSPlugin.ID);
            String string = preferences.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size", null);
            if (string == null) {
                this.initFromPreferences();
                return;
            }
            this.initFromProject(preferences, string);
        } else if (map == null) {
            this.initFromPreferences();
        } else {
            String sma;
            Object object24;
            Object object21;
            Object object20;
            Object object19a;
            Object object18;
            Object object17;
            Object object16;
            Object object15;
            Object object14;
            Object object13;
            Object object12;
            Object object10;
            Object object9;
            Object object8;
            Object object7;
            Object object6;
            Object object5;
            Object object4;
            Object object3;
            Object object2;
            Object object = map.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_else_in_if_statement");
            if (object != null) {
                this.insertNewLineBeforeElse = this.parseInsert(object.toString());
            }
            if ((object2 = map.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_catch_in_try_statement")) != null) {
                this.insertNewLineBeforeCatch = this.parseInsert(object2.toString());
            }
            if ((object3 = map.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_finally_in_try_statement")) != null) {
                this.insertNewLineBeforeFinally = this.parseInsert(object3.toString());
            }
            if ((object4 = map.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_while_in_do_statement")) != null) {
                this.insertNewLineBeforeWhile = this.parseInsert(object4.toString());
            }
            if ((object5 = map.get("com.aptana.ide.editors.codeassist.formatter.keep_then_statement_on_same_line")) != null) {
                this.keepThenSameLine = Boolean.parseBoolean(object5.toString());
            }
            if ((object6 = map.get("com.aptana.ide.editors.codeassist.formatter.keep_imple_if_on_one_line")) != null) {
                this.keepSimpleIfOnOneLine = Boolean.parseBoolean(object6.toString());
            }
            if ((object7 = map.get("com.aptana.ide.editors.codeassist.formatter.keep_else_statement_on_same_line")) != null) {
                this.keepElseStatementOnSameLine = Boolean.parseBoolean(object7.toString());
            }
            if ((object8 = map.get("com.aptana.ide.editors.codeassist.formatter.compact_else_if")) != null) {
                this.compactElseIf = Boolean.parseBoolean(object8.toString());
            }
            if ((object9 = map.get("com.aptana.ide.editors.codeassist.formatter.format_guardian_clause_on_one_line")) != null) {
                this.keepGuardianClauseOnOneLine = Boolean.parseBoolean(object9.toString());
            }
            this.formatterTabChar = (String)map.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
            if (this.formatterTabChar == null) {
                this.formatterTabChar = " ";
            }
            this.tabSize = (object10 = map.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size")) != null ? Integer.parseInt(object10.toString()) : 4;
            Object object11 = map.get("com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_body");
            if (object11 != null) {
                this.indentStatementsCompareToBody = Boolean.parseBoolean(object11.toString());
            }
            if ((object12 = map.get("com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_block")) != null) {
                this.indentStatementsCompareToBlock = Boolean.parseBoolean(object12.toString());
            }
            if ((object13 = map.get("com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_switch")) != null) {
                this.indentStatementsCompareToSwitch = Boolean.parseBoolean(object13.toString());
            }
            if ((object14 = map.get("com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_cases")) != null) {
                this.indentStatementsCompareToCases = Boolean.parseBoolean(object14.toString());
            }
            if ((object15 = map.get("com.aptana.ide.editors.codeassist.formatter.indent_breaks_compare_to_cases")) != null) {
                this.indentBreaksCompareToCases = Boolean.parseBoolean(object15.toString());
            }
            if ((object16 = map.get("com.aptana.ide.editors.codeassist.formatter.indent_empty_lines")) != null) {
                this.indentEmptyLines = Boolean.parseBoolean(object16.toString());
            }
            if ((object17 = map.get("com.aptana.ide.editors.codeassist.formatter.blank_lines_before_method")) != null) {
                this.blankLinesBeforeMethod = Integer.parseInt(object17.toString());
            }
            if ((object18 = map.get("com.aptana.ide.editors.codeassist.formatter.number_of_blank_lines_at_beginning_of_method_body")) != null) {
                this.blankLinesInStartOfMethodBody = Integer.parseInt(object18.toString());
            }
            if ((object19a = map.get("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns")) != null) {
                this.preserveLineBreaks = Boolean.parseBoolean(object19a.toString());
            }
            if ((object20 = map.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_if_statement")) != null) {
                this.insertNewLineBeforeIf = this.parseInsert(object20.toString());
            }
            if ((object21 = map.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_return_statement")) != null) {
                this.insertNewLineBeforeReturn = this.parseInsert(object21.toString());
            }
            this.formatterBracePositionForMethodDecl = this.parseOption(map, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_method_declaration");
            this.formatterBracePositionForBlock = this.parseOption(map, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_block");
            this.formatterBracePositionForBlockInCase = this.parseOption(map, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_block_in_case");
            this.formatterBracePositionForBlockInSwitch = this.parseOption(map, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_switch");
            this.formatterBracePositionForArrayInitializer = this.parseOption(map, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_array_initializer");
            Object object19 = map.get("com.aptana.ide.editors.codeassist.formatter.keep_empty_array_initializer_on_one_line");
            if (object19 != null) {
                this.keepEmptyArrayInitializerOnOneLine = Boolean.parseBoolean(object19.toString());
            }
            if ((object24 = map.get("com.aptana.ide.editors.codeassist.formatter.insert_space_after_closing_brace_in_block")) != null) {
                this.addSpaceAfterFunctionDeclaration = Boolean.parseBoolean(object24.toString());
            }
            if ((sma = (String)map.get("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant")) != null && sma.length() > 0) {
                this.doFormatting = false;
            }
        }
    }

    private void initFromProject(IEclipsePreferences preferences, String string) {
        this.insertNewLineBeforeIf = this.parseInsert(preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_if_statement", ""));
        this.insertNewLineBeforeReturn = this.parseInsert(preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_return_statement", ""));
        this.insertNewLineBeforeElse = this.parseInsert(preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_else_in_if_statement", ""));
        this.insertNewLineBeforeCatch = this.parseInsert(preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_catch_in_try_statement", ""));
        this.insertNewLineBeforeFinally = this.parseInsert(preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_finally_in_try_statement", ""));
        this.insertNewLineBeforeWhile = this.parseInsert(preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_before_while_in_do_statement", ""));
        this.keepThenSameLine = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.keep_then_statement_on_same_line", false);
        this.keepSimpleIfOnOneLine = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.keep_imple_if_on_one_line", false);
        this.keepElseStatementOnSameLine = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.keep_else_statement_on_same_line", false);
        this.compactElseIf = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.compact_else_if", false);
        this.keepGuardianClauseOnOneLine = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.format_guardian_clause_on_one_line", false);
        this.formatterTabChar = preferences.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char", "");
        this.tabSize = Integer.parseInt(string);
        this.indentStatementsCompareToBody = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_body", true);
        this.indentStatementsCompareToBlock = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_block", true);
        this.indentStatementsCompareToSwitch = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_switch", true);
        this.indentStatementsCompareToCases = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_cases", true);
        this.indentBreaksCompareToCases = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_breaks_compare_to_cases", true);
        this.indentEmptyLines = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.indent_empty_lines", true);
        this.blankLinesBeforeMethod = preferences.getInt("com.aptana.ide.editors.codeassist.formatter.blank_lines_before_method", 1);
        this.blankLinesInStartOfMethodBody = preferences.getInt("com.aptana.ide.editors.codeassist.formatter.number_of_blank_lines_at_beginning_of_method_body", 0);
        this.preserveLineBreaks = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns", true);
        this.formatterBracePositionForMethodDecl = this.parseOption(preferences, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_method_declaration");
        this.formatterBracePositionForBlock = this.parseOption(preferences, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_block");
        this.formatterBracePositionForBlockInCase = this.parseOption(preferences, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_block_in_case");
        this.formatterBracePositionForBlockInSwitch = this.parseOption(preferences, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_switch");
        this.formatterBracePositionForArrayInitializer = this.parseOption(preferences, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_array_initializer");
        this.keepEmptyArrayInitializerOnOneLine = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.keep_empty_array_initializer_on_one_line", true);
        this.addSpaceAfterFunctionDeclaration = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.insert_space_after_closing_brace_in_block", true);
        string = preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant", "");
        if (string.length() > 0) {
            this.doFormatting = false;
        }
    }

    private boolean parseInsert(String str) {
        return str.equals("insert");
    }
}

