/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.contentassist;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.js.JSLanguageEnvironment;
import com.aptana.ide.editor.js.JSOffsetMapper;
import com.aptana.ide.editor.js.contentassist.JSCompletionProposal;
import com.aptana.ide.editor.js.contentassist.JSCompletionProposalComparator;
import com.aptana.ide.editor.js.contentassist.JSContentAssistant;
import com.aptana.ide.editor.js.contentassist.JSContextInformationValidator;
import com.aptana.ide.editor.js.contentassist.Messages;
import com.aptana.ide.editor.js.environment.JSGuessedObject;
import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.js.runtime.IFunction;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.IScope;
import com.aptana.ide.editor.js.runtime.JSScope;
import com.aptana.ide.editor.js.runtime.JSUndefined;
import com.aptana.ide.editor.js.runtime.ObjectBase;
import com.aptana.ide.editor.js.runtime.Property;
import com.aptana.ide.editor.scriptdoc.ScriptDocHelper;
import com.aptana.ide.editor.scriptdoc.parsing.FunctionDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.TypedDescription;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IUnifiedViewer;
import com.aptana.ide.editors.unified.contentassist.IUnifiedContentAssistProcessor;
import com.aptana.ide.editors.unified.contentassist.UnifiedContentAssistProcessor;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.metadata.IDocumentation;
import com.aptana.ide.parsing.IOffsetMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class JSContentAssistProcessor
implements IContentAssistProcessor,
IUnifiedContentAssistProcessor {
    private IContextInformationValidator validator;
    boolean initalPopup = false;
    private static String[] keywords = new String[]{"break", "case", "catch", "continue", "default", "delete", "do", "else", "eval", "false", "field", "finally", "for", "function", "if", "in", "instanceof", "new", "null", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "while", "with"};
    private static Image fIconField = UnifiedEditorsPlugin.getImage((String)"icons/field_public.gif");
    private static Image fIconObject = UnifiedEditorsPlugin.getImage((String)"icons/object.gif");
    private static Image fIconClass = UnifiedEditorsPlugin.getImage((String)"icons/class.gif");
    private static Image fIconFunction = UnifiedEditorsPlugin.getImage((String)"icons/function.gif");
    private static Image fIconFieldGuessed = UnifiedEditorsPlugin.getImage((String)"icons/field_public_guess.gif");
    private static Image fIconObjectGuessed = UnifiedEditorsPlugin.getImage((String)"icons/object_guess.gif");
    private static Image fIconClassGuessed = UnifiedEditorsPlugin.getImage((String)"icons/class_guess.gif");
    private static Image fIconFunctionGuessed = UnifiedEditorsPlugin.getImage((String)"icons/function_guess.gif");
    private static Image fIconError = UnifiedEditorsPlugin.getImage((String)"icons/error.gif");
    private static Image fIconKeyword = UnifiedEditorsPlugin.getImage((String)"icons/keyword.gif");
    private static Image fIconConstant = UnifiedEditorsPlugin.getImage((String)"icons/constant.gif");
    private JSCompletionProposalComparator contentAssistComparator;
    private int _offset;
    private static final char[] fContextChars = new char[]{'(', ','};
    private EditorFileContext context;
    private boolean forceActivated = false;

    public JSContentAssistProcessor(EditorFileContext context) {
        this.context = context;
        this.validator = new JSContextInformationValidator(this);
        this.contentAssistComparator = new JSCompletionProposalComparator();
    }

    private Environment getEnvironment() {
        return (Environment)JSLanguageEnvironment.getInstance().getRuntimeEnvironment();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.computeCompletionProposals(viewer, offset, UnifiedContentAssistProcessor.DEFAULT_CHARACTER);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, char activationChar) {
        return this.computeCompletionProposals(viewer, offset, activationChar, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        IObject obj;
        char previousCharacter = this.getActivationChar(viewer, offset);
        IUnifiedViewer unifiedViewer = null;
        if (viewer instanceof IUnifiedViewer) {
            unifiedViewer = (IUnifiedViewer)viewer;
        }
        JSOffsetMapper mapper = (JSOffsetMapper)this.getOffsetMapper();
        int lexemeOffset = mapper.getLexemeIndexFromDocumentOffset(offset);
        Lexeme curLexeme = null;
        curLexeme = lexemeOffset != -1 ? mapper.getLexemeAtIndex(lexemeOffset) : mapper.getCurrentLexeme();
        String fullName = "";
        if (curLexeme != null && curLexeme.getEndingOffset() >= offset) {
            fullName = mapper.getNameHash(mapper.getLexemeList().getLexemeIndex(curLexeme));
        }
        if (fullName.equals("__mode_string")) {
            return null;
        }
        if (fullName.endsWith("]") || fullName.endsWith(")")) {
            return null;
        }
        this._offset = offset;
        if (fullName.equals("__not_an_identifier")) {
            return null;
        }
        boolean isConstructor = fullName.startsWith("__mode_new");
        if (isConstructor) {
            fullName = fullName.substring("__mode_new".length());
        }
        if (previousCharacter == ' ' && !isConstructor) {
            return null;
        }
        IScope scope = mapper.getGlobal();
        lexemeOffset = this.getJSOffsetMapper().getLexemeIndexFromDocumentOffset(offset);
        Lexeme lex = null;
        lex = lexemeOffset != -1 ? mapper.getLexemeAtIndex(lexemeOffset) : mapper.getCurrentLexeme();
        if (lex != null) {
            if (lex.getCategoryIndex() == 1) {
                int prevLexeme = mapper.getCurrentLexemeIndex() - 1;
                LexemeList lexemeList = mapper.getLexemeList();
                while (prevLexeme > 0 && prevLexeme < lexemeList.size()) {
                    lex = lexemeList.get(prevLexeme);
                    if (lex.getCategoryIndex() != 1) break;
                    ++prevLexeme;
                }
            }
            JSOffsetMapper prevLexeme = mapper;
            synchronized (prevLexeme) {
                scope = mapper.getScope(lex, scope);
            }
        }
        String prefix = "";
        if (!fullName.equals("") && fullName.indexOf(".") > -1) {
            String lookupName = fullName;
            if (fullName.indexOf(".") > -1) {
                lookupName = fullName.substring(0, fullName.lastIndexOf(".") + 1);
            }
            if ((obj = mapper.lookupReturnTypeFromNameHash(lookupName, scope)) == null) {
                return null;
            }
            prefix = fullName.substring(fullName.lastIndexOf(46) + 1).toUpperCase();
        } else {
            obj = scope;
            prefix = fullName.toUpperCase();
        }
        if (prefix.indexOf(40) > -1) {
            prefix = "";
        }
        ICompletionProposal[] result = null;
        result = curLexeme != null && curLexeme.typeIndex == 88 ? this.getValidCompletionProposals(obj, curLexeme.getText(), curLexeme.getText(), isConstructor, offset) : this.getValidCompletionProposals(obj, fullName, prefix, isConstructor, offset);
        UnifiedContentAssistProcessor.resetViewerState((IUnifiedViewer)unifiedViewer);
        if (result.length == 1 && prefix.equals(result[0].getDisplayString().toUpperCase())) {
            return this.getValidCompletionProposals(obj, fullName, "", isConstructor, prefix, offset);
        }
        return result;
    }

    private void addDefaultValues(String prefix, Hashtable completionProposals, int beginOffset) {
        FunctionDocumentation fDoc;
        TypedDescription[] params;
        IScope scope;
        this.initalPopup = true;
        String fullName = this.getFullName();
        IObject obj = this.getObject(fullName, scope = this.getScope());
        if (obj == null) {
            return;
        }
        IDocumentation doc = obj.getDocumentation();
        if (doc instanceof FunctionDocumentation && (params = (fDoc = (FunctionDocumentation)doc).getParams()).length == 1) {
            TypedDescription[] defaultValues = params[0].getDefaultValues();
            int i = 0;
            while (i < defaultValues.length) {
                TypedDescription d = defaultValues[i];
                String name = "\"" + d.getName() + "\"";
                Image defaultImage = fIconConstant;
                String location = "String Param";
                Image[] images = UnifiedContentAssistProcessor.getUserAgentImages((String[])UnifiedContentAssistProcessor.getUserAgents(), (String[])fDoc.getUserAgentPlatformNames());
                JSCompletionProposal cp = new JSCompletionProposal(name, beginOffset, prefix.length(), name.length(), defaultImage, name, null, d.getDescription(), 2, location, images);
                completionProposals.put(name, cp);
                ++i;
            }
        }
    }

    private IObject getObject(String fullName, IScope scope) {
        IObject obj = this.getJSOffsetMapper().lookupReturnTypeFromNameHash(fullName, scope);
        return obj;
    }

    private IScope getScope() {
        JSOffsetMapper mapper = this.getJSOffsetMapper();
        Lexeme curLex = mapper.getCurrentLexeme();
        IScope scope = null;
        if (curLex != null) {
            scope = mapper.getScope(curLex, mapper.getGlobal());
        }
        if (scope == null) {
            scope = this.getJSOffsetMapper().getGlobal();
        }
        return scope;
    }

    private String getFullName() {
        String fullName = this.getJSOffsetMapper().getArgAssistNameHash();
        if (fullName.indexOf(40) > -1) {
            fullName = fullName.substring(0, fullName.lastIndexOf(40));
        }
        return fullName;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        this.initalPopup = true;
        String fullName = this.getFullName();
        IScope scope = this.getScope();
        IObject obj = this.getObject(fullName, scope);
        IContextInformation[] ici = null;
        ContextInformation ci = this.computeArgContextInformation(obj, fullName);
        if (ci != null) {
            ici = new IContextInformation[]{ci};
        }
        return ici;
    }

    public char[] getCompletionProposalAllActivationCharacters() {
        char[] allActivationChars = UnifiedContentAssistProcessor.combine((char[])this.getCompletionProposalAutoActivationCharacters(), (char[])this.getContextInformationAutoActivationCharacters());
        Arrays.sort(allActivationChars);
        return allActivationChars;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', ' '};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.validator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return fContextChars;
    }

    public int[] getCompletionProposalIdleActivationTokens() {
        return new int[]{8};
    }

    public String getErrorMessage() {
        return null;
    }

    private ContextInformation computeArgContextInformation(IObject obj, String identifier) {
        ContextInformation result = null;
        StringBuffer docText = new StringBuffer();
        if (obj != null) {
            String additionalInfo;
            String[] params;
            IDocumentation idoc = obj.getDocumentation();
            if (idoc != null) {
                if (idoc instanceof FunctionDocumentation) {
                    String paramText;
                    FunctionDocumentation md = (FunctionDocumentation)idoc;
                    TypedDescription[] params2 = md.getParams();
                    docText.append(ScriptDocHelper.createMethodSignatureString(identifier, md, obj, false));
                    if (params2.length > 0 && (paramText = ScriptDocHelper.createParameterDocumentationList(params2, obj)) != null && !"".equals(paramText)) {
                        docText.append(ScriptDocHelper.DEFAULT_DELIMITER);
                        docText.append(paramText);
                    }
                } else if (idoc instanceof PropertyDocumentation) {
                    PropertyDocumentation pDoc = (PropertyDocumentation)idoc;
                    docText.append(ScriptDocHelper.createPropertyDocumentationHTML(identifier, pDoc, false));
                }
            } else if (obj instanceof IFunction && (params = ((IFunction)((Object)obj)).getParameterNames()) != null && params.length > 0) {
                docText.append("(");
                String comma = "";
                int i = 0;
                while (i < params.length) {
                    docText.append(String.valueOf(comma) + params[i]);
                    comma = ", ";
                    ++i;
                }
                docText.append(")");
            }
            String string = additionalInfo = docText.length() == 0 && obj instanceof IFunction ? Messages.JSContentAssistProcessor_NoArgs : docText.toString();
            if (additionalInfo.trim().length() > 0) {
                result = new ContextInformation("argInfo", additionalInfo);
            }
        }
        return result;
    }

    private char getActivationChar(ITextViewer viewer, int offset) {
        if (JSContentAssistant.isHotkeyActivated()) {
            JSContentAssistant.setHotkeyActivated(false);
            return '\u0000';
        }
        String source = viewer.getDocument().get();
        if (offset == 0) {
            return '\u0000';
        }
        char activationCharacter = source.charAt(offset - 1);
        if (Arrays.binarySearch(this.getCompletionProposalAllActivationCharacters(), activationCharacter) < 0) {
            activationCharacter = UnifiedContentAssistProcessor.DEFAULT_CHARACTER;
        }
        return activationCharacter;
    }

    private ICompletionProposal[] getValidCompletionProposals(IObject obj, String fullName, String prefix, boolean isConstructor, int docOffset) {
        return this.getValidCompletionProposals(obj, fullName, prefix, isConstructor, "", docOffset);
    }

    private ICompletionProposal[] getValidCompletionProposals(IObject baseObject, String fullName, String prefix, boolean isConstructor, String replaceString, int docOffset) {
        int sourceFileIndex;
        Property p;
        int lastDot;
        if (baseObject == null) {
            return new ICompletionProposal[0];
        }
        boolean isNamedGlobal = baseObject.equals(this.getJSOffsetMapper().getGlobal()) && fullName.indexOf(46) != -1;
        int fileIndex = this.getJSOffsetMapper().getFileIndex();
        int offset = 0;
        int lexemeOffset = this.getJSOffsetMapper().getLexemeIndexFromDocumentOffset(docOffset);
        Lexeme curLexeme = null;
        curLexeme = lexemeOffset != -1 ? this.getJSOffsetMapper().getLexemeAtIndex(lexemeOffset) : this.getJSOffsetMapper().getCurrentLexeme();
        if (curLexeme != null) {
            offset = curLexeme.offset;
        }
        if (replaceString.equals("")) {
            replaceString = prefix;
        }
        boolean isRootLevelCall = (lastDot = fullName.lastIndexOf(46)) <= -1;
        Hashtable<String, JSCompletionProposal> completionProposals = new Hashtable<String, JSCompletionProposal>();
        int beginOffset = this._offset;
        if (!prefix.equals("")) {
            boolean isText = curLexeme.getCategoryIndex() == 2 || curLexeme.getCategoryIndex() == 3;
            int n = beginOffset = isText ? curLexeme.offset : curLexeme.getEndingOffset() - prefix.length();
        }
        if (isRootLevelCall) {
            this.addKeywords(prefix, completionProposals, curLexeme);
            this.addDefaultValues(prefix, completionProposals, beginOffset);
        }
        String[] props = JSContentAssistProcessor.getAllPropertyNamesInScope(baseObject, true);
        String originalCasePrefix = isRootLevelCall ? fullName : fullName.substring(lastDot + 1, fullName.length());
        int i = 0;
        while (i < props.length) {
            IObject instance;
            String propName = props[i];
            String upperPropName = propName.toUpperCase();
            if (!(completionProposals.containsKey(propName) && isRootLevelCall || (p = JSOffsetMapper.getPropertyInScope(instance = baseObject.getInstance(this.getEnvironment(), fileIndex, offset), propName)) == null)) {
                JSCompletionProposal jscp;
                boolean wasJustTyped;
                IObject propObject;
                sourceFileIndex = p.getSourceFileIndex(fileIndex, beginOffset);
                if (sourceFileIndex == -1) {
                    sourceFileIndex = p.getSourceFileIndex(Integer.MAX_VALUE, Integer.MAX_VALUE);
                }
                if ((propObject = p.getValue(fileIndex, offset).getInstance(this.getEnvironment(), fileIndex, offset)) == JSUndefined.getSingletonInstance()) {
                    propObject = p.getValue(Integer.MAX_VALUE, Integer.MAX_VALUE).getInstance(this.getEnvironment(), Integer.MAX_VALUE, Integer.MAX_VALUE);
                }
                int asgnCount = p.getAssignments().size();
                boolean bl = wasJustTyped = prefix.equals(upperPropName) && asgnCount <= 1;
                if (wasJustTyped && asgnCount == 1 && p.getAssignment(0).getStartingOffset() != offset) {
                    wasJustTyped = false;
                }
                if (!wasJustTyped && (jscp = this.computeProposal(p, instance, propObject, propName, prefix, isConstructor, replaceString, isNamedGlobal, beginOffset, sourceFileIndex)) != null) {
                    completionProposals.put(propName, jscp);
                }
            }
            ++i;
        }
        if (isRootLevelCall && baseObject instanceof IScope) {
            IScope scope = (IScope)baseObject;
            String[] vars = isRootLevelCall ? scope.getVariableNames() : scope.getLocalVariableNames();
            int i2 = 0;
            while (i2 < vars.length) {
                String varName = vars[i2];
                if (!completionProposals.containsKey(varName) && (p = scope.getVariable(varName)) != null) {
                    JSCompletionProposal jscp;
                    sourceFileIndex = p.getSourceFileIndex(fileIndex, beginOffset);
                    if (sourceFileIndex == -1) {
                        sourceFileIndex = fileIndex;
                    }
                    IObject varObject = p.getValue(fileIndex, offset).getInstance(this.getEnvironment(), fileIndex, offset);
                    if (!(prefix.equals(varName.toUpperCase()) && p.getReferenceCount() < 2 || (jscp = this.computeProposal(p, baseObject, varObject, varName, prefix, isConstructor, replaceString, isNamedGlobal, beginOffset, sourceFileIndex)) == null)) {
                        completionProposals.put(varName, jscp);
                    }
                }
                ++i2;
            }
        }
        ICompletionProposal[] result = completionProposals.values().toArray(new ICompletionProposal[completionProposals.size()]);
        Arrays.sort(result, this.contentAssistComparator);
        if (originalCasePrefix.length() > 0 || fullName.endsWith(".")) {
            if (originalCasePrefix.equals("f")) {
                originalCasePrefix = "function";
            } else if (originalCasePrefix.equals("d")) {
                originalCasePrefix = "document";
            } else if (originalCasePrefix.equals("v")) {
                originalCasePrefix = "var";
            }
            UnifiedContentAssistProcessor.setSelection((String)originalCasePrefix, (ICompletionProposal[])result);
        }
        return result;
    }

    private void addKeywords(String prefix, Hashtable completionProposals, Lexeme curLexeme) {
        boolean isIdent = false;
        int beginOffset = 0;
        if (curLexeme != null) {
            isIdent = curLexeme.typeIndex == 8;
            beginOffset = isIdent ? curLexeme.offset : curLexeme.getEndingOffset();
        }
        int i = 0;
        while (i < keywords.length) {
            String keyName = keywords[i];
            if (!completionProposals.containsKey(keyName)) {
                int finOffset = beginOffset;
                if (curLexeme != null && !isIdent && keyName.equals(prefix.toLowerCase())) {
                    finOffset = curLexeme.offset;
                }
                String location = "Keyword";
                JSCompletionProposal cp = new JSCompletionProposal(keyName, finOffset, prefix.length(), keyName.length(), fIconKeyword, keyName, (IContextInformation)new ContextInformation("keywordInfo", String.valueOf(Messages.JSContentAssistProcessor_The) + keyName + Messages.JSContentAssistProcessor_Keyword), String.valueOf(Messages.JSContentAssistProcessor_The2) + keyName + Messages.JSContentAssistProcessor_Keyword2, 2, location, UnifiedContentAssistProcessor.getAllUserAgentImages((String[])UnifiedContentAssistProcessor.getUserAgents()));
                completionProposals.put(keyName, cp);
            }
            ++i;
        }
    }

    private boolean isValidProposal(IObject baseObject, IObject propertyObject, String propertyName, String prefix) {
        PropertyDocumentation pdocs;
        if (baseObject == null || propertyName.equals("")) {
            return false;
        }
        if (propertyName.indexOf("[") > -1) {
            return false;
        }
        if (propertyObject == ObjectBase.UNDEFINED || propertyObject == null) {
            return false;
        }
        Property prop = JSOffsetMapper.getPropertyInScope(baseObject, propertyName);
        if (prop == null && baseObject instanceof IScope) {
            prop = ((IScope)baseObject).getVariable(propertyName);
        }
        if (prop == null) {
            return false;
        }
        if (!prop.isVisible()) {
            return false;
        }
        IDocumentation docs = propertyObject.getDocumentation();
        return docs == null || !(docs instanceof PropertyDocumentation) || !((pdocs = (PropertyDocumentation)docs).getIsInvocationOnly() ? !(baseObject instanceof JSScope) : pdocs.getIsInternal());
    }

    private JSCompletionProposal computeProposal(Property p, IObject baseObject, IObject propertyObject, String propertyName, String prefix, boolean isConstructor, String replaceString, boolean isNamedGlobal, int beginOffset, int sourceFileIndex) {
        IObject finalObject;
        if (!this.isValidProposal(baseObject, propertyObject, propertyName, prefix)) {
            return null;
        }
        JSScope global = this.getJSOffsetMapper().getGlobal();
        JSCompletionProposal cp = null;
        int replaceLength = replaceString.length();
        String replacementText = propertyName;
        Image icon = fIconError;
        StringBuffer docText = new StringBuffer();
        int sortingType = 5;
        String additionalText = "";
        int extraInsert = 0;
        ContextInformation ci = null;
        int fileIndex = this.getJSOffsetMapper().getFileIndex();
        int offset = 0;
        Lexeme curLexeme = this.getOffsetMapper().getCurrentLexeme();
        if (curLexeme != null) {
            offset = curLexeme.offset;
        }
        if ((finalObject = propertyObject.getInstance(this.getEnvironment(), fileIndex, offset)) == null) {
            return cp;
        }
        boolean isGuessedObject = false;
        IDocumentation doc = finalObject.getDocumentation();
        if (doc == null) {
            doc = p.getAnyValidDocumentation(sourceFileIndex, beginOffset);
        }
        if (finalObject instanceof JSGuessedObject && doc == null) {
            isGuessedObject = true;
        }
        Image[] images = null;
        if (doc != null) {
            if (doc instanceof PropertyDocumentation && !(doc instanceof FunctionDocumentation)) {
                PropertyDocumentation pDoc = (PropertyDocumentation)doc;
                if (pDoc.getUserAgentPlatformNames().length > 0) {
                    images = UnifiedContentAssistProcessor.getUserAgentImages((String[])UnifiedContentAssistProcessor.getUserAgents(), (String[])pDoc.getUserAgentPlatformNames());
                }
                if (isNamedGlobal && pDoc.getIsInternal()) {
                    return null;
                }
                docText.append(ScriptDocHelper.createPropertyDocumentationHTML(propertyName, pDoc, true));
                if (baseObject == global) {
                    sortingType = 2;
                    icon = isGuessedObject ? fIconObjectGuessed : fIconObject;
                } else {
                    sortingType = 1;
                    icon = isGuessedObject ? fIconFieldGuessed : fIconField;
                }
            } else if (doc instanceof FunctionDocumentation) {
                FunctionDocumentation fDoc = (FunctionDocumentation)doc;
                if (fDoc.getUserAgentPlatformNames().length > 0) {
                    images = UnifiedContentAssistProcessor.getUserAgentImages((String[])UnifiedContentAssistProcessor.getUserAgents(), (String[])fDoc.getUserAgentPlatformNames());
                }
                if (isNamedGlobal && fDoc.getIsInternal() && fDoc.getIsConstructor()) {
                    return null;
                }
                docText.append(ScriptDocHelper.createMethodDocumentationHTML(propertyName, fDoc, finalObject));
                boolean isCtor = fDoc.getIsConstructor();
                boolean isMethod = fDoc.getIsMethod();
                if (!isCtor && !isMethod && this.hasPropertiesOnPrototype(finalObject, fileIndex, offset)) {
                    isCtor = true;
                }
                if (isCtor) {
                    sortingType = 4;
                    icon = isGuessedObject ? fIconClassGuessed : fIconClass;
                } else {
                    sortingType = 3;
                    icon = isGuessedObject ? fIconFunctionGuessed : fIconFunction;
                }
            } else {
                docText.append(ScriptDocHelper.createGenericDocumentationHTML(propertyName, doc, false));
                docText.append(doc.getDescription());
            }
        } else if (propertyObject instanceof IFunction) {
            ci = this.computeArgContextInformation(finalObject, propertyName);
            docText.append("<b>" + propertyName + "</b> " + ci.getInformationDisplayString());
            ci = null;
            if (this.hasPropertiesOnPrototype(finalObject, fileIndex, offset)) {
                sortingType = 4;
                icon = isGuessedObject ? fIconClassGuessed : fIconClass;
            } else {
                sortingType = 3;
                icon = isGuessedObject ? fIconFunctionGuessed : fIconFunction;
            }
        } else if (baseObject == global) {
            sortingType = 2;
            icon = isGuessedObject ? fIconObjectGuessed : fIconObject;
            docText.append("<b>" + propertyName + Messages.JSContentAssistProcessor_NoDocs);
        } else {
            sortingType = 1;
            icon = isGuessedObject ? fIconFieldGuessed : fIconField;
            docText.append("<b>" + propertyName + Messages.JSContentAssistProcessor_NoDocs2);
        }
        String name = "";
        if (sourceFileIndex == Integer.MIN_VALUE) {
            name = doc != null ? doc.getUserAgent() : "JS Core";
        } else if (sourceFileIndex == Integer.MAX_VALUE) {
            if (doc != null && doc.getUserAgent() != null && !doc.getUserAgent().equals("")) {
                name = doc.getUserAgent();
            } else {
                name = CoreUIUtils.getActiveEditorURI();
                if (name != null && !"".equals(name)) {
                    name = new Path(name).lastSegment();
                }
            }
        } else if (sourceFileIndex > -1) {
            name = FileContextManager.getURIFromFileIndex((int)sourceFileIndex);
            if (name != null && name.length() > 0) {
                name = new Path(name).lastSegment();
            } else if (doc != null) {
                name = doc.getUserAgent();
            }
        } else {
            name = "[Inferred]";
        }
        String location = name == null ? "" : name;
        location = StringUtils.urlDecodeFilename((char[])location.toCharArray());
        cp = new JSCompletionProposal(String.valueOf(propertyName) + additionalText, beginOffset, replaceLength, propertyName.length() + extraInsert, icon, replacementText, (IContextInformation)ci, docText.toString(), sortingType, location, images);
        return cp;
    }

    private boolean hasPropertiesOnPrototype(IObject obj, int fileIndex, int offset) {
        Property prot = obj.getProperty("prototype");
        if (prot != null) {
            String[] protProps = prot.getValue(fileIndex, offset).getLocalPropertyNames();
            return protProps != null && protProps.length > 1;
        }
        return false;
    }

    public static String[] getAllPropertyNamesInScope(IObject object, boolean includeHiddenProps) {
        if (object instanceof IScope) {
            IScope scope = (IScope)object;
            if (scope.getParentScope() == null) {
                return object.getPropertyNames(includeHiddenProps);
            }
            ArrayList<String[]> al = new ArrayList<String[]>();
            String[] curProps = object.getPropertyNames(includeHiddenProps);
            int totalProps = curProps.length;
            al.add(curProps);
            scope = scope.getParentScope();
            while (scope != null) {
                curProps = scope.getPropertyNames(includeHiddenProps);
                totalProps += curProps.length;
                al.add(curProps);
                scope = scope.getParentScope();
            }
            String[] result = new String[totalProps];
            int count = 0;
            int i = 0;
            while (i < al.size()) {
                String[] props = (String[])al.get(i);
                int k = 0;
                while (k < props.length) {
                    result[count++] = props[k];
                    ++k;
                }
                ++i;
            }
            return result;
        }
        return object.getPropertyNames(includeHiddenProps);
    }

    public IOffsetMapper getOffsetMapper() {
        IFileLanguageService ls = this.context.getLanguageService("text/javascript");
        if (ls != null) {
            return (JSOffsetMapper)ls.getOffsetMapper();
        }
        return null;
    }

    public JSOffsetMapper getJSOffsetMapper() {
        return (JSOffsetMapper)this.getOffsetMapper();
    }

    public void setHotkeyActivated(boolean value) {
        JSContentAssistant.setHotkeyActivated(value);
    }

    public void setNextIdleActivated(boolean value) {
        this.forceActivated = value;
    }

    public boolean isNextIdleActivated() {
        return this.forceActivated;
    }

    public boolean isValidIdleActivationLocation(ITextViewer viewer, int offset) {
        Lexeme currentLexeme = this.getOffsetMapper().getCurrentLexeme();
        return UnifiedContentAssistProcessor.isValidIdleActivationToken((Lexeme)currentLexeme, (int[])this.getCompletionProposalIdleActivationTokens());
    }
}

