/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js;

import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.UnifiedColorizerBase;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.IParseState;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.custom.StyleRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSColorizer
extends UnifiedColorizerBase {
    private String[] fTypes = new String[]{"Array", "Boolean", "Date", "Error", "EvalError", "RangeError", "ReferenceError", "SyntaxError", "TypeError", "URIError", "Function", "Math", "Null", "Number", "Object", "RegExp", "String", "Undefined"};
    public static Map<String, TextAttribute> htmlIdents = new HashMap<String, TextAttribute>();
    public static Map<String, TextAttribute> jsCoreIdents = new HashMap<String, TextAttribute>();
    private Map<String, TextAttribute> idents = new Hashtable<String, TextAttribute>();
    private TextAttribute nativeTypeTextAttribute;
    private TextAttribute htmlDomTextAttribute;
    private TextAttribute jsCoreTextAttribute;
    private LanguageColorizer colorizer;

    public JSColorizer() {
        super("text/javascript");
        int i = 0;
        while (i < this.fTypes.length) {
            this.idents.put(this.fTypes[i], this.nativeTypeTextAttribute);
            ++i;
        }
        this.colorizer = LanguageRegistry.getLanguageColorizer((String)"text/javascript");
    }

    public void createStyle(IParseState parseState, Lexeme lexeme, Vector<StyleRange> styles) {
        int cat = lexeme.getCategoryIndex();
        if (cat == 2) {
            String text = lexeme.getText();
            if (this.idents.containsKey(text)) {
                this.addRange(styles, lexeme.offset, lexeme.length, this.idents.get(text));
            } else if (jsCoreIdents.containsKey(text)) {
                this.addRange(styles, lexeme.offset, lexeme.length, this.jsCoreTextAttribute);
            } else if (htmlIdents.containsKey(text)) {
                this.addRange(styles, lexeme.offset, lexeme.length, this.htmlDomTextAttribute);
            } else {
                this.colorizer.createStyle(parseState, lexeme, styles);
            }
        } else {
            this.colorizer.createStyle(parseState, lexeme, styles);
        }
    }

    protected void initializeColorTables() {
        this.nativeTypeTextAttribute = this.getColorPreference("com.aptana.ide.editor.js.JSEDITOR_NATIVETYPE_COLOR", 1);
        this.jsCoreTextAttribute = this.getColorPreference("com.aptana.ide.editor.js.JSEDITOR_JSCORE_COLOR");
        this.htmlDomTextAttribute = this.getColorPreference("com.aptana.ide.editor.js.JSEDITOR_HTMLDOM_COLOR");
    }

    protected IPreferenceStore getPluginPreferenceStore() {
        return JSPlugin.getDefault().getPreferenceStore();
    }
}

