/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.model.user;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.model.IServiceErrors;
import com.aptana.ide.core.model.RESTServiceProvider;
import com.aptana.ide.core.model.user.AuthenticatedUserRequestBuilder;
import com.aptana.ide.core.model.user.User;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class AptanaUser {
    private static final String USER_URL_OVERRIDE = "USER_URL_OVERRIDE";
    private static final String PROPERTY_KEY = "SiteManagerSelection";
    public static final String BASE_URL;
    public static final String USERS;
    public static final String LOGINS;
    public static final String ACCOUNT_USERNAME = "com.aptana.ide.core.model.ACCOUNT_USERNAME";
    public static final String ACCOUNT_PASSWORD = "com.aptana.ide.core.model.ACCOUNT_PASSWORD";
    public static final String ACCOUNT_ID = "com.aptana.ide.core.model.ACCOUNT_ID";
    private static User user;
    private static URL users;
    private static URL logins;
    private static final String aptanaSettings = ".aptana-id";

    static {
        String propertyUrl;
        ResourcesPlugin.getPlugin().getPluginPreferences().setDefault(PROPERTY_KEY, true);
        boolean useProduction = true;
        BASE_URL = useProduction ? ((propertyUrl = System.getProperty(USER_URL_OVERRIDE)) != null && propertyUrl.length() > 0 ? propertyUrl : "https://cloudmanager.aptana.com/cloud") : "https://acotak-staging.aptana.com/cloud";
        USERS = String.valueOf(BASE_URL) + "/users";
        LOGINS = String.valueOf(BASE_URL) + "/logins";
        try {
            users = new URL(USERS);
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            logins = new URL(LOGINS);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public static synchronized User getSignedInUser() {
        if (user == null) {
            user = new User(){

                public IServiceErrors commit() {
                    IServiceErrors errors = null;
                    BufferedWriter bw = null;
                    try {
                        try {
                            File settings = AptanaUser.getSettingsFile();
                            FileWriter fw = new FileWriter(settings);
                            bw = new BufferedWriter(fw);
                            bw.write(AptanaUser.ACCOUNT_USERNAME);
                            bw.write("=");
                            if (this.getUsername() != null) {
                                bw.write(this.getUsername());
                            }
                            bw.newLine();
                            bw.write(AptanaUser.ACCOUNT_PASSWORD);
                            bw.write("=");
                            if (this.getPassword() != null) {
                                bw.write(this.getPassword());
                            }
                            bw.newLine();
                            bw.write(AptanaUser.ACCOUNT_ID);
                            bw.write("=");
                            if (this.getId() != null) {
                                bw.write(this.getId());
                            }
                            bw.newLine();
                        }
                        catch (Exception e) {
                            IdeLog.logError(AptanaCorePlugin.getDefault(), "Unable to write Aptana user", e);
                        }
                    }
                    finally {
                        if (bw != null) {
                            try {
                                bw.close();
                            }
                            catch (IOException e) {
                                IdeLog.logError(AptanaCorePlugin.getDefault(), "Unable to close Aptana user file", e);
                            }
                        }
                    }
                    errors = super.commit();
                    return errors;
                }

                public IServiceErrors update() {
                    File settings;
                    BufferedReader reader;
                    IServiceErrors errors;
                    block24: {
                        IServiceErrors iServiceErrors;
                        block25: {
                            errors = null;
                            reader = null;
                            settings = AptanaUser.getSettingsFile();
                            if (settings.exists()) break block24;
                            iServiceErrors = errors;
                            if (reader == null) break block25;
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                IdeLog.logError(AptanaCorePlugin.getDefault(), "Unable to close Aptana user file", e);
                            }
                        }
                        return iServiceErrors;
                    }
                    try {
                        try {
                            FileReader fw = new FileReader(settings);
                            reader = new BufferedReader(fw);
                            String line = reader.readLine();
                            while (line != null) {
                                String[] sections = line.split("=");
                                if (sections.length > 0) {
                                    String name = sections[0];
                                    String value = "";
                                    if (sections.length == 2) {
                                        value = sections[1];
                                    }
                                    if (value != null && value.length() > 0) {
                                        if (AptanaUser.ACCOUNT_USERNAME.equals(name)) {
                                            this.setUsername(value);
                                        } else if (AptanaUser.ACCOUNT_PASSWORD.equals(name)) {
                                            this.setPassword(value);
                                        } else if (AptanaUser.ACCOUNT_ID.equals(name)) {
                                            this.setId(value);
                                        }
                                    }
                                }
                                line = reader.readLine();
                            }
                        }
                        catch (Exception e) {
                            IdeLog.logError(AptanaCorePlugin.getDefault(), "Unable to read Aptana user", e);
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                IdeLog.logError(AptanaCorePlugin.getDefault(), "Unable to close Aptana user file", e);
                            }
                        }
                    }
                    errors = super.update();
                    return errors;
                }
            };
            user.update();
            user.setServiceProvider(new RESTServiceProvider());
            AuthenticatedUserRequestBuilder builder = new AuthenticatedUserRequestBuilder();
            builder.setUser(user);
            user.setRequestBuilder(builder);
            try {
                user.setDefaultLocation(new URL(LOGINS));
            }
            catch (MalformedURLException malformedURLException) {}
            if (user.hasCredentials()) {
                Job job = new Job("Updating Aptana ID"){

                    protected IStatus run(IProgressMonitor monitor) {
                        user.update();
                        user.update();
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(40);
                job.schedule();
            }
        }
        return user;
    }

    public static void signIn(String username, String password, URL location, String id) {
        AptanaUser.getSignedInUser().suspendEvents();
        AptanaUser.getSignedInUser().setPassword(password);
        AptanaUser.getSignedInUser().setUsername(username);
        AptanaUser.getSignedInUser().setLocation(location);
        AptanaUser.getSignedInUser().setId(id);
        AptanaUser.getSignedInUser().commit();
        AptanaUser.getSignedInUser().update();
        AptanaUser.getSignedInUser().resumeEvents();
    }

    public static void signOut() {
        AptanaUser.getSignedInUser().suspendEvents();
        AptanaUser.getSignedInUser().setPassword("");
        AptanaUser.getSignedInUser().setUsername("");
        AptanaUser.getSignedInUser().setId("");
        AptanaUser.getSignedInUser().setLocation(null);
        AptanaUser.getSignedInUser().clear();
        AptanaUser.getSignedInUser().resumeEvents();
        AptanaUser.getSignedInUser().commit();
    }

    public static File getConfigurationDirectory() {
        String homeDir = System.getProperty("osgi.configuration.area");
        URL fileURL = FileUtils.uriToURL(homeDir);
        File f = FileUtils.urlToFile(fileURL);
        f.mkdirs();
        return f;
    }

    private static File getSettingsFile() {
        File config = AptanaUser.getConfigurationDirectory();
        return new File(config, aptanaSettings);
    }

    public static URL getLogins() {
        return logins;
    }

    public static URL getUsers() {
        return users;
    }
}

