/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.model;

import com.aptana.ide.core.model.BaseModelObject;
import com.aptana.ide.core.model.CoreModelObject;
import com.aptana.ide.core.model.IModelListener;
import com.aptana.ide.core.model.IServiceErrors;
import com.aptana.ide.core.xpath.XPathUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoreGroupObject<T extends CoreModelObject>
extends CoreModelObject {
    protected List<T> children = new ArrayList<T>();
    protected boolean requireUniqueIds = true;
    protected T childTemplate = this.createItem();
    protected boolean isLoading = true;

    public T getItem(String itemId) {
        if (itemId != null) {
            CoreModelObject[] coreModelObjectArray = this.getItems();
            int n = 0;
            int n2 = coreModelObjectArray.length;
            while (n < n2) {
                CoreModelObject item = coreModelObjectArray[n];
                if (itemId.equals(item.getId())) {
                    return (T)item;
                }
                ++n;
            }
        }
        return null;
    }

    public abstract boolean shouldAdd(T var1);

    public T[] getItems() {
        return this.children.toArray(this.createEmptyArray());
    }

    @Override
    public synchronized void clear() {
        if (this.children != null) {
            this.isLoading = true;
            CoreModelObject[] coreModelObjectArray = this.getItems();
            int n = 0;
            int n2 = coreModelObjectArray.length;
            while (n < n2) {
                CoreModelObject item = coreModelObjectArray[n];
                item.clear();
                ++n;
            }
            this.children.clear();
        }
    }

    @Override
    public void addListener(IModelListener listener) {
        super.addListener(listener);
        CoreModelObject[] coreModelObjectArray = this.getItems();
        int n = 0;
        int n2 = coreModelObjectArray.length;
        while (n < n2) {
            CoreModelObject item = coreModelObjectArray[n];
            item.addListener(listener);
            ++n;
        }
    }

    @Override
    public void fromNode(Node node) {
        try {
            NodeList set = (NodeList)XPATH.evaluate(this.getItemString(), node, XPathConstants.NODESET);
            this.updateGroup(set);
        }
        catch (XPathExpressionException e1) {
            this.isLoading = false;
            this.logError("XPath error parsing " + this.getLoggingPrefix() + ": " + e1.getMessage());
        }
    }

    protected abstract T[] createEmptyArray();

    public abstract T createItem();

    protected void configureItem(T item) {
        this.configurationLocation(item);
        ((CoreModelObject)item).setRequestBuilder(this.getRequestBuilder());
        ((CoreModelObject)item).setServiceProvider(this.getServiceProvider());
    }

    protected void configurationLocation(T item) {
        if (((CoreModelObject)item).getId() != null && this.getLocation() != null) {
            String itemLocation = this.getLocation().toExternalForm();
            if (!itemLocation.endsWith("/")) {
                itemLocation = String.valueOf(itemLocation) + "/";
            }
            itemLocation = String.valueOf(itemLocation) + ((CoreModelObject)item).getId();
            try {
                URL itemURL = new URL(itemLocation);
                ((CoreModelObject)item).setLocation(itemURL);
            }
            catch (MalformedURLException e) {
                this.logError("Error building " + this.getLoggingPrefix() + " url: " + e.getMessage());
            }
        }
    }

    @Override
    public IServiceErrors update() {
        IServiceErrors errors = null;
        this.isLoading = true;
        try {
            errors = super.update();
        }
        finally {
            this.isLoading = false;
        }
        return errors;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroup(NodeList set) {
        try {
            try {
                ArrayList<T> newChildren = new ArrayList<T>();
                if (this.requireUniqueIds) {
                    CoreGroupObject coreGroupObject = this;
                    synchronized (coreGroupObject) {
                        newChildren.addAll(this.children);
                    }
                }
                ArrayList<String> ids = new ArrayList<String>();
                int i = 0;
                while (i < set.getLength()) {
                    BaseModelObject groupItem = null;
                    boolean newItem = true;
                    if (this.requireUniqueIds) {
                        String id = this.getTextContent("id", set.item(i));
                        if (id != null && id.length() > 0) {
                            ids.add(id);
                            for (CoreModelObject item : this.children) {
                                if (!id.equals(item.getId())) continue;
                                groupItem = item;
                                newItem = false;
                                break;
                            }
                            if (groupItem == null) {
                                groupItem = this.createItem();
                                if (this.requireUniqueIds) {
                                    ((CoreModelObject)groupItem).setId(id);
                                }
                            }
                        }
                    } else {
                        groupItem = (BaseModelObject)this.createItem();
                    }
                    if (groupItem != null) {
                        groupItem.suspendEvents();
                        ((CoreModelObject)groupItem).setLogger(this.getLogger());
                        groupItem.addListeners(this.getListeners());
                        groupItem.fromNode(set.item(i));
                        this.configureItem(groupItem);
                        if (newItem && this.shouldAdd(groupItem)) {
                            newChildren.add(groupItem);
                            groupItem.fireChange();
                        }
                        groupItem.resumeEvents();
                    }
                    ++i;
                }
                if (this.requireUniqueIds) {
                    Iterator iterator = newChildren.iterator();
                    while (iterator.hasNext()) {
                        CoreModelObject removedItem = (CoreModelObject)iterator.next();
                        if (ids.contains(removedItem.getId())) continue;
                        iterator.remove();
                        removedItem.clear();
                    }
                }
                CoreGroupObject coreGroupObject = this;
                synchronized (coreGroupObject) {
                    this.children = newChildren;
                }
            }
            catch (Exception e1) {
                this.logError("XPath error parsing " + this.getLoggingPrefix() + ": " + e1.getMessage());
            }
        }
        finally {
            this.isLoading = false;
        }
    }

    @Override
    public void fromXML(String xml) {
        try {
            NodeList set = (NodeList)XPATH.evaluate("/" + this.getGroupString() + "/" + this.getItemString(), XPathUtils.createSource(xml), XPathConstants.NODESET);
            this.updateGroup(set);
        }
        catch (XPathExpressionException e1) {
            this.isLoading = false;
            this.logError("XPath error parsing " + this.getLoggingPrefix() + ": " + e1.getMessage());
        }
    }

    @Override
    public Node toNode() {
        return null;
    }

    @Override
    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<" + this.getGroupString() + ">");
        CoreModelObject[] coreModelObjectArray = this.getItems();
        int n = 0;
        int n2 = coreModelObjectArray.length;
        while (n < n2) {
            CoreModelObject item = coreModelObjectArray[n];
            buffer.append(item.toXML());
            ++n;
        }
        buffer.append("</" + this.getGroupString() + ">");
        return buffer.toString();
    }

    protected abstract String getGroupString();

    @Override
    protected String getItemString() {
        if (this.childTemplate != null) {
            return ((CoreModelObject)this.childTemplate).getItemString();
        }
        return null;
    }

    public boolean isRequireUniqueIds() {
        return this.requireUniqueIds;
    }

    public void setRequireUniqueIds(boolean requireUniqueIds) {
        this.requireUniqueIds = requireUniqueIds;
    }

    public void addChild(T item) {
        this.children.add(item);
    }
}

