/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.licensing;

import java.util.Calendar;
import java.util.TimeZone;

public final class ClientKey {
    public static final String BEGIN_LICENSE_MARKER = "--begin-aptana-license--";
    public static final String END_LICENSE_MARKER = "--end-aptana-license--";
    public static final int PRO = 0;
    public static final int TRIAL = 1;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final String EMAILS_NON_MATCHING = "EMAILS_NON_MATCHING";
    public static final ClientKey EMPTY_KEY = new ClientKey(1, null, 0L);
    private String email;
    private long expiration;
    private int type;

    public ClientKey(int type, String email, long expiration) {
        this.type = type;
        this.email = email;
        this.expiration = expiration;
    }

    public boolean isCloseToExpiring() {
        Calendar currentCalendar = Calendar.getInstance(GMT);
        currentCalendar.add(2, 1);
        return this.getExpiration().before(currentCalendar);
    }

    public boolean isValid() {
        return this.email != null && this.email != EMAILS_NON_MATCHING;
    }

    public boolean isCloseToMatching() {
        return this.email == EMAILS_NON_MATCHING;
    }

    public boolean isExpired() {
        Calendar currentCalendar = Calendar.getInstance(GMT);
        return currentCalendar.after(this.getExpiration());
    }

    public String getEmail() {
        return this.email;
    }

    public Calendar getExpiration() {
        Calendar expirationCal = Calendar.getInstance(GMT);
        expirationCal.setTimeInMillis(this.expiration);
        return expirationCal;
    }

    public boolean isTrial() {
        return this.type == 1;
    }

    public boolean isPro() {
        return !this.isTrial();
    }

    public boolean shouldProPluginsRun() {
        if (this.isPro()) {
            return true;
        }
        return !this.isExpired();
    }

    public static String trimEncryptedLicense(String encrypted) {
        String newEncrypted = encrypted;
        newEncrypted = newEncrypted.trim();
        newEncrypted = newEncrypted.replaceAll(BEGIN_LICENSE_MARKER, "");
        newEncrypted = newEncrypted.replaceAll(END_LICENSE_MARKER, "");
        newEncrypted = newEncrypted.replaceAll("\\s+", "");
        return newEncrypted;
    }
}

