/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.sync;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.sync.SyncEventHandlerAdapter;
import com.aptana.ide.core.io.sync.VirtualFileSyncPair;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SyncEventHandlerAdapterWithProgressMonitor
extends SyncEventHandlerAdapter {
    private static final int TRANSFER_SCALE = 1024;
    private static final int PATH_DISPLAY_CHARACTERS = 40;
    private IProgressMonitor monitor;
    private Map<VirtualFileSyncPair, SubProgressMonitor> itemsProgress = new HashMap<VirtualFileSyncPair, SubProgressMonitor>();
    private Map<VirtualFileSyncPair, Long> itemsTransfer = new HashMap<VirtualFileSyncPair, Long>();

    public SyncEventHandlerAdapterWithProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
    }

    public boolean getFilesEvent(IVirtualFileManager manager, String path) {
        this.monitor.subTask(FileUtils.compressPath(path, 40));
        return !this.monitor.isCanceled() && super.getFilesEvent(manager, path);
    }

    public boolean syncContinue() {
        return !this.monitor.isCanceled() && super.syncContinue();
    }

    public void syncDone(VirtualFileSyncPair item) {
        SubProgressMonitor itemProgressMonitor = this.itemsProgress.get(item);
        if (itemProgressMonitor != null) {
            itemProgressMonitor.done();
            this.itemsProgress.remove(item);
            this.itemsTransfer.remove(item);
        }
        super.syncDone(item);
    }

    public boolean syncErrorEvent(VirtualFileSyncPair item, Exception e) {
        SubProgressMonitor itemProgressMonitor = this.itemsProgress.get(item);
        if (itemProgressMonitor != null) {
            itemProgressMonitor.done();
            this.itemsProgress.remove(item);
            this.itemsTransfer.remove(item);
        }
        return !this.monitor.isCanceled() && super.syncErrorEvent(item, e);
    }

    public boolean syncEvent(VirtualFileSyncPair item, int index, int totalItems) {
        SubProgressMonitor itemProgressMonitor = this.itemsProgress.get(item);
        if (itemProgressMonitor == null) {
            itemProgressMonitor = new SubProgressMonitor(this.monitor, 1);
            this.itemsProgress.put(item, itemProgressMonitor);
            this.itemsTransfer.put(item, 0L);
            this.monitor.subTask(FileUtils.compressPath(item.getRelativePath(), 40));
            itemProgressMonitor.beginTask(item.getRelativePath(), SyncEventHandlerAdapterWithProgressMonitor.getItemProgressAmount(item));
        }
        return !this.monitor.isCanceled() && super.syncEvent(item, index, totalItems);
    }

    public void syncTransferring(VirtualFileSyncPair item, long bytes) {
        SubProgressMonitor itemProgressMonitor = this.itemsProgress.get(item);
        if (itemProgressMonitor != null) {
            long delta = bytes - this.itemsTransfer.get(item);
            this.itemsTransfer.put(item, bytes);
            itemProgressMonitor.worked((int)(delta / 1024L));
        }
        super.syncTransferring(item, bytes);
    }

    private static int getItemProgressAmount(VirtualFileSyncPair item) {
        switch (item.getSyncDirection()) {
            case 1: {
                return (int)(item.getSourceFile().getSize() / 1024L);
            }
            case 2: {
                return (int)(item.getDestinationFile().getSize() / 1024L);
            }
        }
        return 1;
    }
}

