/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.ConnectionException;
import com.aptana.ide.core.io.FileTransferListener;
import com.aptana.ide.core.io.IFileProgressMonitor;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.IVirtualFileManagerEventHandler;
import com.aptana.ide.core.io.Messages;
import com.aptana.ide.core.io.ProtocolManager;
import com.aptana.ide.core.io.VirtualFileManagerException;
import com.aptana.ide.core.io.VirtualFileManagerGroup;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class VirtualManagerBase
implements IVirtualFileManager,
IPropertyChangeListener {
    ProtocolManager _protocolManager;
    private String _nickName = "";
    private long _id;
    private boolean _hidden;
    private boolean _transient;
    private IVirtualFileManagerEventHandler _eventHandler;
    private List<FileTransferListener> _fileTransferListeners;
    private long _timeOffset;
    private boolean _timeOffsetIsCached;
    private boolean _calculateOffset;
    private List<IVirtualFile> _cloakedFiles = new ArrayList<IVirtualFile>();
    private List<String> _cloakedFileExpressions = new ArrayList<String>();
    private int _initialPoolSize;
    private int _maxPoolSize;
    private VirtualFileManagerGroup _managerGroup;

    public VirtualManagerBase(ProtocolManager protocolManager) {
        this._protocolManager = protocolManager;
        this._id = (long)(9.223372036854776E18 * Math.random());
        this._hidden = false;
        this._transient = false;
        this._timeOffset = 0L;
        this._timeOffsetIsCached = false;
        this._initialPoolSize = 4;
        this._maxPoolSize = 8;
        try {
            IPreferenceStore store = this.getPreferenceStore();
            if (store != null) {
                store.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.updateCloakExpressions();
        }
        catch (Exception exception) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.VirtualManagerBase_UnableToAddPropertyListener);
        }
    }

    public IVirtualFileManagerEventHandler getEventHandler() {
        return this._eventHandler;
    }

    public boolean isEditable() {
        return true;
    }

    public void setEventHandler(IVirtualFileManagerEventHandler eventHandler) {
        this._eventHandler = eventHandler;
    }

    protected boolean fireGetFilesEvent(String path) {
        boolean result = true;
        if (this._eventHandler != null) {
            result = this._eventHandler.getFilesEvent(this, path);
        }
        return result;
    }

    public IVirtualFile[] getFiles(IVirtualFile file) throws ConnectionException, IOException {
        return this.getFiles(file, false, true);
    }

    public String getNickName() {
        return this._nickName;
    }

    public void setNickName(String nickName) {
        this._nickName = nickName;
    }

    public ProtocolManager getProtocolManager() {
        return this._protocolManager;
    }

    public int compareTo(Object o) {
        if (!(o instanceof IVirtualFileManager)) {
            return -1;
        }
        IVirtualFileManager fm = (IVirtualFileManager)o;
        String label = this.getDescriptiveLabel();
        if (label == null || fm == null) {
            return -1;
        }
        return label.compareTo(fm.getDescriptiveLabel());
    }

    public long getId() {
        return this._id;
    }

    public void setId(long id) {
        this._id = id;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean transient1) {
        this._transient = transient1;
    }

    public String getDescriptiveLabel() {
        String name = "";
        name = this.getBasePath() != null && !"".equals(this.getBasePath()) && !this.getBasePath().equals(this.getFileSeparator()) ? StringUtils.format("{0} ({1})", new String[]{this.getNickName(), this.getBasePath()}) : this.getNickName();
        return name;
    }

    public void addFileTransferListener(FileTransferListener listener) {
        if (this._fileTransferListeners == null) {
            this._fileTransferListeners = new ArrayList<FileTransferListener>();
        }
        this._fileTransferListeners.add(listener);
    }

    public void removeFileTransferListener(FileTransferListener listener) {
        if (this._fileTransferListeners != null) {
            this._fileTransferListeners.remove(listener);
        }
    }

    protected void fireFileTransferEvent(String logInfo) {
        if (this._fileTransferListeners != null) {
            int i = 0;
            while (i < this._fileTransferListeners.size()) {
                this._fileTransferListeners.get(i).addText(logInfo);
                ++i;
            }
        }
    }

    public void putStream(InputStream input, IVirtualFile targetFile) throws ConnectionException, VirtualFileManagerException, IOException {
        this.putStream(input, targetFile, null);
    }

    public void putFile(IVirtualFile sourceFile, IVirtualFile targetFile) throws ConnectionException, VirtualFileManagerException, IOException {
        this.putFile(sourceFile, targetFile, null);
    }

    public void putFile(IVirtualFile sourceFile, final IVirtualFile targetFile, final IFileProgressMonitor monitor) throws ConnectionException, VirtualFileManagerException, IOException {
        sourceFile.getStream(new IVirtualFile.Client(){

            public void streamGot(InputStream input) throws ConnectionException, VirtualFileManagerException, IOException {
                VirtualManagerBase.this.putStream(input, targetFile, monitor);
            }
        });
    }

    public void setTimeOffset(long timeOffset) {
        this._timeOffset = timeOffset;
        this._timeOffsetIsCached = true;
    }

    public void setAutoCalculateServerTimeOffset(boolean calculateOffset) {
        this._calculateOffset = calculateOffset;
    }

    public boolean isAutoCalculateServerTimeOffset() {
        return this._calculateOffset;
    }

    public void resetTimeOffsetCache() {
        this._timeOffsetIsCached = false;
    }

    public long getTimeOffset() throws ConnectionException {
        if (!this._calculateOffset) {
            return 0L;
        }
        if (!this._timeOffsetIsCached) {
            String tempFileBase = "timestamp";
            String tempFileExtension = ".tmp";
            String tempFileName = String.valueOf(tempFileBase) + tempFileExtension;
            try {
                File tempFile = File.createTempFile(tempFileBase, tempFileExtension);
                FileInputStream input = new FileInputStream(tempFile);
                long localModificationDate = tempFile.lastModified();
                String fullPath = this.getBasePath() != null && this.getBasePath().equals(this.getFileSeparator()) ? String.valueOf(this.getFileSeparator()) + tempFileName : String.valueOf(this.getBasePath()) + this.getFileSeparator() + tempFileName;
                IVirtualFile vFile = this.createVirtualFile(fullPath);
                this.putStream(input, vFile);
                IVirtualFile vParent = vFile.getParentFile();
                this._timeOffsetIsCached = true;
                IVirtualFile[] files = this.getFiles(vParent, true, true);
                this._timeOffsetIsCached = false;
                if (files.length > 0) {
                    int i = 0;
                    while (i < files.length) {
                        IVirtualFile file = files[i];
                        if (file.getName().equals(vFile.getName())) {
                            this._timeOffset = file.getModificationMillis() > 0L ? file.getModificationMillis() - localModificationDate : 0L;
                            this._timeOffsetIsCached = true;
                            break;
                        }
                        ++i;
                    }
                }
                this.deleteFile(vFile);
            }
            catch (IOException e) {
                IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.VirtualManagerBase_GetTimeOffsetError, e);
            }
        }
        return this._timeOffset;
    }

    public IVirtualFile[] getCloakedFiles() {
        return this._cloakedFiles.toArray(new IVirtualFile[0]);
    }

    public String[] getCloakedFileExpressions() {
        return this._cloakedFileExpressions.toArray(new String[0]);
    }

    public void setCloakedFiles(IVirtualFile[] files) {
        this._cloakedFiles.clear();
        this._cloakedFiles.addAll((Collection<IVirtualFile>)Arrays.asList(files));
    }

    public void addCloakedFile(IVirtualFile file) {
        this._cloakedFiles.add(file);
    }

    public void removeCloakedFile(IVirtualFile file) {
        this._cloakedFiles.remove(file);
    }

    public void addCloakExpression(String fileExpression) {
        this._cloakedFileExpressions.add(fileExpression);
    }

    public void removeCloakExpression(String fileExpression) {
        this._cloakedFileExpressions.remove(fileExpression);
    }

    public void removeAllCloakExpressions() {
        this._cloakedFileExpressions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileCloaked(IVirtualFile file) {
        boolean result = false;
        if (this._cloakedFiles.contains(file)) {
            result = true;
        } else {
            String separator = this.getFileSeparator();
            if ("\\".equals(separator)) {
                separator = "\\\\";
            }
            List<String> list = this._cloakedFileExpressions;
            synchronized (list) {
                for (String pattern : this._cloakedFileExpressions) {
                    if (pattern.contains(separator)) {
                        if (!file.getRelativePath().matches(pattern)) continue;
                        result = true;
                        break;
                    }
                    if (!file.getName().matches(pattern)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    protected IVirtualFile[] deserializeCloakedFiles(String items) {
        String[] files = items.split("}}}}");
        ArrayList<IVirtualFile> al = new ArrayList<IVirtualFile>();
        int i = 0;
        while (i < files.length) {
            if (files[i].length() > 0) {
                al.add(this.createVirtualFile(files[i]));
            }
            ++i;
        }
        return al.toArray(new IVirtualFile[al.size()]);
    }

    protected String serializeCloakedFiles(IVirtualFile[] files) {
        ArrayList<String> newFiles = new ArrayList<String>();
        int i = 0;
        while (i < files.length) {
            newFiles.add(files[i].getAbsolutePath());
            ++i;
        }
        return StringUtils.join("}}}}", newFiles.toArray(new String[0]));
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("com.aptana.ide.core.PREF_GLOBAL_SYNC_CLOAKING_EXTENSIONS".equals(property)) {
            this.updateCloakExpressions();
        }
    }

    private void updateCloakExpressions() {
        String expressions;
        this.removeAllCloakExpressions();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null && (expressions = store.getString("com.aptana.ide.core.PREF_GLOBAL_SYNC_CLOAKING_EXTENSIONS")) != null && expressions.length() > 0) {
            String[] array;
            String[] stringArray = array = expressions.split(";");
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String expression = stringArray[n];
                String regexString = this.cloakExpressionToRegex(expression);
                this.addCloakExpression(regexString);
                ++n;
            }
        }
    }

    private String cloakExpressionToRegex(String expression) {
        String result = null;
        if (expression != null) {
            if (expression.startsWith("/") && expression.endsWith("/")) {
                result = expression.substring(1, expression.length() - 1);
            } else {
                String separator = this.getFileSeparator();
                if (expression.contains("/")) {
                    if (!separator.equals("/")) {
                        expression = separator.equals("\\") ? expression.replaceAll("/", "\\\\\\\\") : expression.replaceAll("/", separator);
                    }
                } else if (expression.contains("\\")) {
                    expression = !separator.equals("\\") ? expression.replaceAll("\\\\", separator) : expression.replaceAll("\\\\", "\\\\\\\\");
                }
                result = expression.replaceAll("\\.(?=[^\\*])", "\\\\.");
                result = "(?i)" + result.replaceAll("(?<!\\.)\\*", ".*");
            }
        }
        return result;
    }

    protected abstract IPreferenceStore getPreferenceStore();

    public static String getFileTypeCloakExpression(IVirtualFile element) {
        if (element.isDirectory()) {
            return element.getName();
        }
        String extension = element.getExtension();
        if (extension != null && !"".equals(extension)) {
            return "*" + element.getExtension();
        }
        return element.getName();
    }

    public boolean isValid() {
        return true;
    }

    public IVirtualFileManager cloneManager() {
        return null;
    }

    public void cancel() {
    }

    public void setPoolSizes(int initialSize, int maxSize) {
        this._initialPoolSize = initialSize;
        this._maxPoolSize = maxSize;
    }

    public VirtualFileManagerGroup getManagerGroup() {
        return this._managerGroup;
    }

    public void setManagerGroup(VirtualFileManagerGroup group) {
        this._managerGroup = group;
    }

    protected int getInitialPoolSize() {
        return this._initialPoolSize;
    }

    protected int getMaxPoolSize() {
        return this._maxPoolSize;
    }
}

