/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.ide.core.io.ConnectionException;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.VirtualFileManagerException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;

public abstract class VirtualFile
implements IVirtualFile {
    public boolean isLocal() {
        return false;
    }

    public IVirtualFile[] getFiles() throws ConnectionException, IOException {
        return this.getFiles(false, true);
    }

    public String getTimeStamp() {
        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
        return df.format(new Date(this.getModificationMillis()));
    }

    public void setTimeStamp(String timeStamp) {
    }

    public InputStream getStream(IVirtualFile.Client client) throws ConnectionException, VirtualFileManagerException, IOException {
        InputStream input = this.getStream();
        client.streamGot(input);
        return input;
    }

    public void putStream(InputStream input) throws ConnectionException, VirtualFileManagerException, IOException {
        this.putStream(input, null);
    }

    public static IVirtualFile[] removeDuplicateFile(IVirtualFile[] files, IVirtualFile toRemove) {
        ArrayList<IVirtualFile> filteredSources = new ArrayList<IVirtualFile>();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                IVirtualFile element = files[i];
                if (element.getParentFile() == null || !element.getParentFile().getAbsolutePath().equals(toRemove.getAbsolutePath())) {
                    filteredSources.add(element);
                }
                ++i;
            }
        }
        return filteredSources.toArray(new IVirtualFile[filteredSources.size()]);
    }

    public static IVirtualFile[] reparentFiles(IVirtualFileManager manager, IVirtualFile[] files) {
        ArrayList<IVirtualFile> newFiles = new ArrayList<IVirtualFile>();
        int i = 0;
        while (i < files.length) {
            IVirtualFile file = files[i];
            IVirtualFile newFile = file.isDirectory() ? manager.createVirtualDirectory(file.getAbsolutePath()) : manager.createVirtualFile(file.getAbsolutePath());
            newFiles.add(newFile);
            ++i;
        }
        return newFiles.toArray(new IVirtualFile[newFiles.size()]);
    }

    public static IVirtualFile[] getParentDirectories(IVirtualFile file, IVirtualFileManager sourceManager) {
        ArrayList<IVirtualFile> parentDirs = new ArrayList<IVirtualFile>();
        if (sourceManager.containsFile(file)) {
            IVirtualFile currentFile = file;
            while (currentFile != null) {
                if (currentFile.equals(sourceManager.getBaseFile())) break;
                parentDirs.add(0, currentFile);
                currentFile = currentFile.getParentFile();
            }
        }
        return parentDirs.toArray(new IVirtualFile[parentDirs.size()]);
    }
}

