/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.Messages;
import com.aptana.ide.core.MutexJobRule;
import com.aptana.ide.core.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class VersionCheck
implements IStartup {
    public void earlyStartup() {
        final String version = System.getProperty("java.version");
        final String vendor = System.getProperty("java.vendor");
        if (!this.isNotLess15(version) || vendor.toLowerCase().contains("free")) {
            UIJob job = new UIJob("Checking JRE Version"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (Display.getCurrent().getActiveShell() == null) {
                        return Status.OK_STATUS;
                    }
                    String description = Messages.VersionCheck_BAD_JRE_DESCRIPTION;
                    description = StringUtils.format(description, new Object[]{vendor, version});
                    MessageDialog md = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.VersionCheck_BAD_JRE_TITLE, null, description, 4, new String[]{CoreStrings.CONTINUE}, 0);
                    md.open();
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)MutexJobRule.getInstance());
            job.setSystem(true);
            job.schedule();
        }
    }

    private boolean isNotLess15(String version) {
        double val;
        int k = version.indexOf(46) + 1;
        int e = version.indexOf(46, k);
        if (e > -1) {
            version = version.substring(0, e);
        }
        return (val = Double.parseDouble(version)) >= 1.5;
    }
}

