/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class URLEncoder {
    private URLEncoder() {
    }

    public static URL encode(URL url) throws MalformedURLException {
        try {
            String auth = url.getAuthority();
            String host = url.getHost();
            int port = url.getPort();
            if (auth == null || auth.length() == 0 || auth.equals(host) && port == -1 || auth.equals(String.valueOf(host) + ":" + port)) {
                URI uri = new URI(url.getProtocol(), null, host, port, url.getPath(), url.getQuery(), url.getRef());
                url = uri.toURL();
            }
        }
        catch (URISyntaxException e) {
            URLEncoder.logError("Could not encode: " + url, e);
        }
        return url;
    }

    public static String encode(String path, String query, String fragment) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(path, "/", true);
        while (tok.hasMoreTokens()) {
            String segment = tok.nextToken();
            if (segment.length() == 1 && segment.charAt(0) == '/') {
                sb.append(segment);
                continue;
            }
            sb.append(URLEncoder.encodeSegment(segment));
        }
        if (query != null && query.length() > 0) {
            sb.append('?').append(query);
        }
        if (fragment != null && fragment.length() > 0) {
            sb.append('?').append(URLEncoder.encodeSegment(fragment));
        }
        return sb.toString();
    }

    private static String encodeSegment(String segment) {
        int index = segment.indexOf(37);
        if (index != -1 && index + 1 < segment.length() && Character.isDigit(segment.charAt(index + 1))) {
            return segment;
        }
        StringBuffer sb = new StringBuffer();
        char[] chars = segment.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char ch = chars[i];
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= ',' && ch <= ':' || ch == '~' || ch == '_' || ch == '!' || ch == '$') {
                sb.append(ch);
            } else {
                try {
                    byte[] bytes = new Character(ch).toString().getBytes("UTF8");
                    int j = 0;
                    while (j < bytes.length) {
                        sb.append('%').append(Integer.toHexString(bytes[j] >> 4 & 0xF)).append(Integer.toHexString(bytes[j] & 0xF));
                        ++j;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            ++i;
        }
        return sb.toString();
    }

    private static void logError(String errorMessage, Throwable e) {
        Status status = new Status(4, ResourcesPlugin.getPlugin().getBundle().getSymbolicName(), 0, errorMessage, e);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }
}

