/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PlatformUtils;
import com.aptana.ide.core.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class FirefoxUtils {
    private static final String[] WIN32_PROFILES_LOCATIONS = new String[]{"%APPDATA%\\Mozilla\\Firefox\\"};
    private static final String[] LINUX_PROFILES_LOCATIONS = new String[]{"~/.mozilla/firefox/"};
    private static final String[] MACOSX_PROFILES_LOCATIONS = new String[]{"~/Library/Application Support/Firefox/", "~/Library/Mozilla/Firefox/"};
    private static final Map<String, String[]> LOCATIONS = new HashMap<String, String[]>();

    static {
        LOCATIONS.put("win32", WIN32_PROFILES_LOCATIONS);
        LOCATIONS.put("linux", LINUX_PROFILES_LOCATIONS);
        LOCATIONS.put("macosx", MACOSX_PROFILES_LOCATIONS);
    }

    private FirefoxUtils() {
    }

    public static File findDefaultProfileLocation() {
        String[] locations = LOCATIONS.get(Platform.getOS());
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                String location = PlatformUtils.expandEnvironmentStrings(locations[i]);
                File dir = new File(location);
                if (dir.isDirectory() && dir.exists()) {
                    IdeLog.logInfo(AptanaCorePlugin.getDefault(), StringUtils.format("Check location {0} for default profile", location));
                    File[] profiles = FirefoxUtils.readProfiles(dir);
                    if (profiles.length == 0) {
                        File dirProfiles = new File(dir, "Profiles");
                        if (!dirProfiles.exists() || !dirProfiles.isDirectory()) {
                            dirProfiles = dir;
                        }
                        profiles = dirProfiles.listFiles(new FilenameFilter(){

                            public boolean accept(File dir, String name) {
                                return name.endsWith(".default");
                            }
                        });
                    }
                    StringBuffer sb = new StringBuffer();
                    int j = 0;
                    while (j < profiles.length) {
                        if (j != 0) {
                            sb.append(',');
                        }
                        sb.append(profiles[j].toString());
                        ++j;
                    }
                    IdeLog.logInfo(AptanaCorePlugin.getDefault(), StringUtils.format("Profiles found: {0}", sb.toString()));
                    j = 0;
                    while (j < profiles.length) {
                        File profile = profiles[j];
                        if (profile.exists() && profile.isDirectory()) {
                            IdeLog.logInfo(AptanaCorePlugin.getDefault(), StringUtils.format("Default profile was found at {0}", profile.toString()));
                            return profile;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private static File[] readProfiles(File dir) {
        ArrayList<File> list;
        block20: {
            list = new ArrayList<File>();
            File profilesIni = new File(dir, "profiles.ini");
            if (profilesIni.exists()) {
                BufferedReader r;
                block19: {
                    r = null;
                    try {
                        try {
                            String line;
                            r = new LineNumberReader(new FileReader(profilesIni));
                            HashMap sections = new HashMap();
                            HashMap<String, String> last = null;
                            Pattern sectionPattern = Pattern.compile("^\\x5B(.*)\\x5D$");
                            Pattern valuePattern = Pattern.compile("^(.[^=]*)=(.*)$");
                            while ((line = ((LineNumberReader)r).readLine()) != null) {
                                Matcher matcher = sectionPattern.matcher(line);
                                if (matcher.find()) {
                                    last = new HashMap<String, String>();
                                    sections.put(matcher.group(1), last);
                                    continue;
                                }
                                if (last == null || !(matcher = valuePattern.matcher(line)).find()) continue;
                                last.put(matcher.group(1), matcher.group(2));
                            }
                            for (String section : sections.keySet()) {
                                if (!section.startsWith("Profile")) continue;
                                Map properties = (Map)sections.get(section);
                                String path = (String)properties.get("Path");
                                String isRelative = (String)properties.get("IsRelative");
                                File profile = isRelative != null && "1".equals(isRelative) ? new File(dir, path) : new File(path);
                                boolean def = properties.containsKey("Default");
                                if (def) {
                                    list.add(0, profile);
                                    continue;
                                }
                                list.add(profile);
                            }
                        }
                        catch (IOException e) {
                            IdeLog.logError(AptanaCorePlugin.getDefault(), StringUtils.format("Reading '{0}' fails", profilesIni.getAbsolutePath()), e);
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                }
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return list.toArray(new File[list.size()]);
    }

    public static String getExtensionVersion(String extensionID, File profileDir) {
        File installRdf;
        File dir = new File(new File(profileDir, "extensions"), extensionID);
        if (dir.exists() && (installRdf = new File(dir, "install.rdf")).exists()) {
            try {
                NamedNodeMap attrs;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document document = parser.parse(new FileInputStream(installRdf));
                Node node = document.getDocumentElement().getFirstChild();
                while (node != null) {
                    if ("description".equals(node.getNodeName().toLowerCase()) || "rdf:description".equals(node.getNodeName().toLowerCase())) {
                        attrs = node.getAttributes();
                        Node about = attrs.getNamedItem("about");
                        if (about == null) {
                            about = attrs.getNamedItem("RDF:about");
                        }
                        if (about != null && "urn:mozilla:install-manifest".equals(about.getNodeValue())) break;
                    }
                    node = node.getNextSibling();
                }
                if (node != null) {
                    attrs = node.getAttributes();
                    Node version = attrs.getNamedItem("em:version");
                    if (version != null) {
                        return version.getNodeValue();
                    }
                    node = node.getFirstChild();
                }
                while (node != null) {
                    if ("em:version".equals(node.getNodeName().toLowerCase())) break;
                    node = node.getNextSibling();
                }
                if (node != null) {
                    return node.getTextContent();
                }
            }
            catch (Exception e) {
                IdeLog.logError(AptanaCorePlugin.getDefault(), "", e);
            }
        }
        return null;
    }
}

