/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.FileTricks;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.Messages;
import com.aptana.ide.core.StreamUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.URLEncoder;
import com.aptana.ide.core.io.IFileProgressMonitor;
import com.aptana.ide.internal.core.CoreNatives;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class FileUtils {
    public static String NEW_LINE = System.getProperty("line.separator");
    private static final char ALT_SEPARATOR_CHAR = (char)(File.separatorChar == '/' ? 92 : 47);
    private static Hashtable fileDirectoryStatus = new Hashtable();
    public static String systemTempDir = FileUtils.getTempDir();

    protected FileUtils() {
    }

    public static boolean copy(String from, String to, String what) {
        return FileUtils.copy(new File(from, what), new File(to, what));
    }

    public static boolean copy(File from, File to, String what) {
        return FileUtils.copy(new File(from, what), new File(to, what));
    }

    public static final boolean isEmpty(Object data) {
        if (data == null) {
            return true;
        }
        if (data instanceof Collection) {
            return ((Collection)data).isEmpty();
        }
        if (data instanceof Map) {
            return ((Map)data).isEmpty();
        }
        if (data instanceof Object[]) {
            return ((Object[])data).length == 0;
        }
        return data.toString().length() == 0 || "null".equals(data.toString());
    }

    public static boolean copy(String from, String to) {
        return FileUtils.copy(new File(from), new File(to));
    }

    public static boolean copy(File from, File to) {
        long time;
        if (from.isDirectory()) {
            String[] contents = from.list();
            int i = 0;
            while (contents != null && i < contents.length) {
                FileUtils.copy(from, to, contents[i]);
                ++i;
            }
        } else {
            try {
                FileOutputStream os = FileUtils.makeFile(to);
                FileInputStream is = new FileInputStream(from);
                FileUtils.pipe(is, os, false);
                ((InputStream)is).close();
                ((OutputStream)os).close();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (!to.setLastModified(time = from.lastModified())) {
            return false;
        }
        long newtime = to.lastModified();
        return time == newtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipe(InputStream in, OutputStream out, boolean isBlocking, ByteFilter filter, IFileProgressMonitor monitor) throws IOException {
        byte[] buf = new byte[50000];
        int total = 0;
        InputStream inputStream = in;
        synchronized (inputStream) {
            int navailable = isBlocking ? buf.length : in.available();
            int nread = in.read(buf, 0, Math.min(buf.length, navailable));
            while (navailable > 0 && nread >= 0) {
                if (filter == null) {
                    out.write(buf, 0, nread);
                } else {
                    byte[] filtered = filter.filter(buf, nread);
                    out.write(filtered);
                }
                total += nread;
                if (monitor != null) {
                    monitor.bytesTransferred(total);
                }
                navailable = isBlocking ? buf.length : in.available();
                nread = in.read(buf, 0, Math.min(buf.length, navailable));
            }
        }
        out.flush();
        buf = null;
    }

    public static void pipe(InputStream in, OutputStream out, boolean isBlocking, ByteFilter filter) throws IOException {
        FileUtils.pipe(in, out, isBlocking, filter, null);
    }

    public static void pipe(InputStream in, OutputStream out, boolean isBlocking) throws IOException {
        FileUtils.pipe(in, out, isBlocking, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pipe(Reader in, Writer out) {
        if (in == null) {
            return false;
        }
        if (out == null) {
            return false;
        }
        try {
            Reader reader = in;
            synchronized (reader) {
                int c = in.read();
                while (in.ready() && c > 0) {
                    out.write(c);
                    c = in.read();
                }
            }
            out.flush();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static FileOutputStream makeFile(String dirname, String filename, boolean append) throws IOException {
        File dir;
        if (!FileUtils.isEmpty(dirname) && !(dir = new File(dirname)).isDirectory()) {
            if (dir.exists()) {
                dir.delete();
            }
            dir.mkdirs();
        }
        return new FileOutputStream(new File(dirname, filename), append);
    }

    public static FileOutputStream makeFile(String dir, String filename) throws IOException {
        return FileUtils.makeFile(dir, filename, false);
    }

    public static FileOutputStream makeFile(String[] path, boolean append) throws IOException {
        return FileUtils.makeFile(path[0], path[1], append);
    }

    public static FileOutputStream makeFile(String[] path) throws IOException {
        return FileUtils.makeFile(path[0], path[1]);
    }

    public static FileOutputStream makeFile(String path, boolean append) throws IOException {
        return FileUtils.makeFile(FileUtils.splitPath(path), append);
    }

    public static FileOutputStream makeFile(String path) throws IOException {
        return FileUtils.makeFile(FileUtils.splitPath(path));
    }

    public static String[] splitPath(String path) {
        return new String[]{FileUtils.dirname(path), new File(path).getName()};
    }

    public static FileOutputStream makeFile(File file, boolean append) throws IOException {
        return FileUtils.makeFile(file.getCanonicalPath(), append);
    }

    public static String dirname(File file) {
        String parent = file.getParent();
        if (parent == null) {
            parent = ".";
        }
        if (file.getPath().indexOf(File.separatorChar) < 0 && file.getPath().indexOf(ALT_SEPARATOR_CHAR) >= 0 && parent.indexOf(File.separatorChar) >= 0) {
            parent = parent.replace(File.separatorChar, ALT_SEPARATOR_CHAR);
        }
        return parent;
    }

    public static String dirname(String path) {
        String dirname = FileUtils.dirname(new File(path));
        if (path.indexOf(ALT_SEPARATOR_CHAR) >= 0 && path.indexOf(File.separatorChar) < 0) {
            return dirname.replace(File.separatorChar, ALT_SEPARATOR_CHAR);
        }
        return dirname;
    }

    public static FileOutputStream makeFile(File file) throws IOException {
        return FileUtils.makeFile(file.getCanonicalPath());
    }

    public static final OutputStreamWriter makeFileWriter(String path, String encoding) throws IOException {
        return new OutputStreamWriter((OutputStream)FileUtils.makeFile(path), encoding);
    }

    public static File[] getFilesInDirectory(File file) {
        Path path = new Path(file.toString());
        String lastSegment = path.lastSegment();
        File[] files = new File[]{};
        if (file.isDirectory()) {
            files = file.listFiles();
        } else {
            File parent = file.getParentFile();
            files = parent.listFiles();
        }
        if (lastSegment != null && lastSegment.indexOf(42) >= 0) {
            return FileUtils.matchFiles(lastSegment, files);
        }
        return files;
    }

    public static File[] matchFiles(String pattern, File[] files) {
        String newPattern = StringUtils.replace(pattern, "\\", "\\\\");
        newPattern = StringUtils.replace(newPattern, ".", "\\.");
        newPattern = StringUtils.replace(newPattern, "*", ".*");
        ArrayList<File> al = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            File fileTest = files[i];
            if (fileTest.toString().matches(newPattern)) {
                al.add(fileTest);
            }
            ++i;
        }
        return al.toArray(new File[0]);
    }

    public static String makeFilePathRelative(File fileA, File fileB) {
        String r;
        String separator = System.getProperty("file.separator");
        String a = fileA.toString();
        if (!fileA.isDirectory()) {
            a = String.valueOf(fileA.getParent().toString()) + separator;
        }
        String b = fileB.toString();
        if (fileB.isDirectory()) {
            b = String.valueOf(b) + separator;
        }
        if ((r = StringUtils.replace(b, a, "")).endsWith(separator)) {
            r = r.substring(0, r.length() - 1);
        }
        return r;
    }

    public static String getExtension(String fileName) {
        if (fileName == null || "".equals(fileName)) {
            return fileName;
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        if (index == fileName.length()) {
            return "";
        }
        return fileName.substring(index + 1, fileName.length());
    }

    public static String stripExtension(String fileName) {
        if (fileName == null || "".equals(fileName)) {
            return fileName;
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        if (index == fileName.length()) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static boolean isDirectory(File f) {
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            return f.isDirectory();
        }
        String filePath = f.getAbsolutePath();
        if (fileDirectoryStatus.containsKey(filePath)) {
            return fileDirectoryStatus.get(filePath).equals(Boolean.TRUE);
        }
        File fShell = FileTricks.attemptReplaceWithShellFolder(f);
        boolean isDirectory = fShell.isDirectory();
        if (isDirectory) {
            fileDirectoryStatus.put(filePath, Boolean.TRUE);
        } else {
            fileDirectoryStatus.put(filePath, Boolean.FALSE);
        }
        return isDirectory;
    }

    private static String getTempDir() {
        if (systemTempDir == null) {
            PrivilegedAction pa = new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("java.io.tmpdir");
                }
            };
            systemTempDir = (String)AccessController.doPrivileged(pa);
        }
        return systemTempDir;
    }

    public static String ensureExtension(String extension) {
        if (extension == null || "".equals(extension)) {
            return extension;
        }
        if (extension.startsWith(".")) {
            return extension;
        }
        return "." + extension;
    }

    public static String ensureValidFilename(String fileName) {
        String newName = StringUtils.replace(fileName, String.valueOf(File.separatorChar), "_");
        newName = StringUtils.replace(newName, ":", "_");
        newName = StringUtils.replace(newName, "|", "_");
        newName = StringUtils.replace(newName, "<", "_");
        newName = StringUtils.replace(newName, ">", "_");
        newName = StringUtils.replace(newName, "*", "_");
        newName = StringUtils.replace(newName, "?", "_");
        return newName;
    }

    public static String stripExtensionPeriod(String extension) {
        if (extension == null || "".equals(extension)) {
            return extension;
        }
        if (extension.startsWith(".")) {
            return extension.substring(1);
        }
        return extension;
    }

    public static String compressPath(String path, int pathLength) {
        if ((path = path.replace('\\', '/')).length() > pathLength) {
            int firstSlash = path.indexOf(47, 1);
            int endSearch = path.length() - pathLength - firstSlash;
            if (firstSlash < 0 || endSearch < 0) {
                return path;
            }
            int lastSlash = path.indexOf(47, endSearch);
            if (lastSlash > firstSlash) {
                return String.valueOf(path.substring(0, firstSlash)) + "/..." + path.substring(lastSlash);
            }
            lastSlash = path.lastIndexOf(47, path.length() - 2);
            return String.valueOf(path.substring(0, firstSlash)) + "/..." + path.substring(lastSlash);
        }
        return path;
    }

    public static String getRandomFileName(String prefix, String suffix) {
        if (suffix == null) {
            return String.valueOf(prefix) + (long)(2.147483647E9 * Math.random());
        }
        return String.valueOf(prefix) + (long)(2.147483647E9 * Math.random()) + suffix;
    }

    public static boolean deleteDirectory(String parentDirectory, String directoryName) {
        File newDirectory = new File(String.valueOf(parentDirectory) + File.separator + directoryName);
        if (newDirectory.exists()) {
            return FileUtils.deleteDirectory(newDirectory);
        }
        return false;
    }

    public static boolean deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            String[] children = directory.list();
            int i = 0;
            while (i < children.length) {
                boolean success = FileUtils.deleteDirectory(new File(directory, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return directory.delete();
    }

    public static boolean setHidden(File file) {
        if ("win32".equals(Platform.getOS())) {
            try {
                return CoreNatives.SetFileAttributes(file.getAbsolutePath(), 2, 0);
            }
            catch (UnsatisfiedLinkError e) {
                IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.FileUtils_CoreLibraryNotFound, e);
            }
        }
        return false;
    }

    public static String readContent(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return StreamUtils.readContent(fis, null);
    }

    public static boolean isFileURL(URL url) {
        if (url == null) {
            return false;
        }
        String surl = url.toString();
        return surl.startsWith("file:/");
    }

    public static File urlToFile(URL url) {
        try {
            URI uri = url.toURI();
            if ("file".equals(uri.getScheme())) {
                return new File(uri.getSchemeSpecificPart());
            }
        }
        catch (Exception e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), "", e);
        }
        return null;
    }

    public static File openURL(String uri) {
        URL fileURL = FileUtils.uriToURL(uri);
        if (fileURL == null) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), StringUtils.format("Unable to open URL {0} as file", uri));
            return null;
        }
        File f = FileUtils.urlToFile(fileURL);
        if (f != null) {
            return f;
        }
        try {
            String text = FileUtils.readContent(fileURL);
            String[] path = fileURL.getFile().split("/");
            String name = path[path.length - 1];
            File temp = File.createTempFile(FileUtils.stripExtension(name), FileUtils.ensureExtension(FileUtils.getExtension(name)));
            BufferedWriter out = new BufferedWriter(new FileWriter(temp));
            out.write(text);
            out.close();
            return temp;
        }
        catch (IOException e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), StringUtils.format("Unable to open URL {0} as file", uri), e);
            return null;
        }
    }

    public static URL uriToURL(String uri) {
        try {
            String encodedUri = URLEncoder.encode(uri, null, null);
            URI uri2 = new URI(encodedUri);
            return uri2.toURL();
        }
        catch (MalformedURLException e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), StringUtils.format("Unable to convert uri {0} to URL. Malformed", uri), e);
            return null;
        }
        catch (URISyntaxException e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), StringUtils.format("Unable to convert uri {0} to URL. Syntax is incorrect", uri), e);
            return null;
        }
    }

    public static String readContent(URL url) throws IOException {
        String text = null;
        if (FileUtils.isFileURL(url)) {
            File file = FileUtils.urlToFile(url);
            return FileUtils.readContent(file);
        }
        InputStream is = url.openStream();
        text = StreamUtils.readContent(is, null);
        return text;
    }

    public static void writeStreamToFile(InputStream in, String fileName) {
        block18: {
            try {
                FileOutputStream fos;
                block17: {
                    fos = new FileOutputStream(fileName);
                    try {
                        try {
                            int ch;
                            while (-1 != (ch = in.read())) {
                                fos.write(ch);
                            }
                        }
                        catch (Exception exception) {
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fos != null) {
                            try {
                                fos.flush();
                                fos.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (fos != null) {
                        try {
                            fos.flush();
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
                if (fos != null) {
                    try {
                        fos.flush();
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    public static void writeStringToFile(String text, String filePath) throws IOException {
        File outFile = new File(filePath);
        FileUtils.writeStringToFile(text, outFile);
    }

    public static void writeStringToFile(String text, File file) throws IOException {
        FileWriter out = new FileWriter(file);
        out.write(text);
        out.close();
    }

    public static interface ByteFilter {
        public byte[] filter(byte[] var1, int var2);
    }
}

