/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl.internal.filesystem.text;

import com.aptana.ide.search.epl.filesystem.text.FileSystemTextSearchScope;
import com.aptana.ide.search.epl.internal.filesystem.text.PatternConstructor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class FileNamePatternSearchScope
extends FileSystemTextSearchScope {
    private static final boolean IS_CASE_SENSITIVE_FILESYSTEM = !new File("Temp").equals(new File("temp"));
    private final String fDescription;
    private final File[] fRootElements;
    private final Set fFileNamePatterns;
    private Matcher fFileNameMatcher;
    private boolean fVisitDerived;

    public static FileNamePatternSearchScope newSearchScope(String description, File[] resources, boolean includeDerived) {
        return new FileNamePatternSearchScope(description, FileNamePatternSearchScope.removeRedundantEntries(resources, includeDerived), includeDerived);
    }

    private FileNamePatternSearchScope(String description, File[] resources, boolean visitDerived) {
        Assert.isNotNull((Object)description);
        this.fDescription = description;
        this.fRootElements = resources;
        this.fFileNamePatterns = new HashSet(3);
        this.fFileNameMatcher = null;
        this.fVisitDerived = visitDerived;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public File[] getRoots() {
        return this.fRootElements;
    }

    public boolean contains(File proxy) {
        if (proxy.isFile()) {
            return this.matchesFileName(proxy.getName());
        }
        return true;
    }

    public void addFileNamePattern(String pattern) {
        if (this.fFileNamePatterns.add(pattern)) {
            this.fFileNameMatcher = null;
        }
    }

    public void setFileNamePattern(Pattern pattern) {
        this.fFileNameMatcher = pattern.matcher("");
    }

    public Pattern getFileNamePattern() {
        return this.getFileNameMatcher().pattern();
    }

    public boolean isIncludeDerived() {
        return this.fVisitDerived;
    }

    private Matcher getFileNameMatcher() {
        if (this.fFileNameMatcher == null) {
            Pattern pattern;
            if (this.fFileNamePatterns.isEmpty()) {
                pattern = Pattern.compile(".*");
            } else {
                String[] patternStrings = this.fFileNamePatterns.toArray(new String[this.fFileNamePatterns.size()]);
                pattern = PatternConstructor.createPattern(patternStrings, IS_CASE_SENSITIVE_FILESYSTEM);
            }
            this.fFileNameMatcher = pattern.matcher("");
        }
        return this.fFileNameMatcher;
    }

    private boolean matchesFileName(String fileName) {
        return this.getFileNameMatcher().reset(fileName).matches();
    }

    public String getFileNamePatternDescription() {
        Object[] ext = this.fFileNamePatterns.toArray(new String[this.fFileNamePatterns.size()]);
        Arrays.sort(ext);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < ext.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append((String)ext[i]);
            ++i;
        }
        return buf.toString();
    }

    private static File[] removeRedundantEntries(File[] elements, boolean includeDerived) {
        ArrayList res = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            File curr = elements[i];
            FileNamePatternSearchScope.addToList(res, curr, includeDerived);
            ++i;
        }
        return res.toArray(new File[res.size()]);
    }

    private static void addToList(ArrayList res, File curr, boolean includeDerived) {
        if (!includeDerived && FileNamePatternSearchScope.isDerived(curr)) {
            return;
        }
        Path currPath = new Path(curr.getAbsolutePath());
        int k = res.size() - 1;
        while (k >= 0) {
            File other = (File)res.get(k);
            Path otherPath = new Path(other.getAbsolutePath());
            if (otherPath.isPrefixOf((IPath)currPath)) {
                return;
            }
            if (currPath.isPrefixOf((IPath)otherPath)) {
                res.remove(k);
            }
            --k;
        }
        res.add(curr);
    }

    private static boolean isDerived(File curr) {
        return false;
    }

    public static FileSystemTextSearchScope newSearchScope(File[] files, String[] fileNamePatterns) {
        FileNamePatternSearchScope fileNamePatternSearchScope = new FileNamePatternSearchScope("", files, true);
        int a = 0;
        while (a < fileNamePatterns.length) {
            fileNamePatternSearchScope.addFileNamePattern(fileNamePatterns[a]);
            ++a;
        }
        return fileNamePatternSearchScope;
    }
}

