/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl.filesystem.ui.text;

import com.aptana.ide.search.epl.FileSystemSearchResult;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemSearchPage;
import com.aptana.ide.search.epl.filesystem.ui.text.IFileSearchContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FileTableContentProvider
implements IStructuredContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private FileSystemSearchPage fPage;
    private AbstractTextSearchResult fResult;

    public FileTableContentProvider(FileSystemSearchPage page) {
        this.fPage = page;
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof FileSystemSearchResult) {
            int elementLimit = this.getElementLimit();
            Object[] elements = ((FileSystemSearchResult)((Object)inputElement)).getElements();
            if (elementLimit != -1 && elements.length > elementLimit) {
                Object[] shownElements = new Object[elementLimit];
                System.arraycopy(elements, 0, shownElements, 0, elementLimit);
                return shownElements;
            }
            return elements;
        }
        return this.EMPTY_ARR;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof FileSystemSearchResult) {
            this.fResult = (FileSystemSearchResult)((Object)newInput);
        }
    }

    public void elementsChanged(Object[] updatedElements) {
        TableViewer viewer = this.getViewer();
        int elementLimit = this.getElementLimit();
        boolean tableLimited = elementLimit != -1;
        int i = 0;
        while (i < updatedElements.length) {
            if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                if (viewer.testFindItem(updatedElements[i]) != null) {
                    viewer.update(updatedElements[i], null);
                } else if (!tableLimited || viewer.getTable().getItemCount() < elementLimit) {
                    viewer.add(updatedElements[i]);
                }
            } else {
                viewer.remove(updatedElements[i]);
            }
            ++i;
        }
    }

    private int getElementLimit() {
        Integer elementLimit1 = this.fPage.getElementLimit1();
        if (elementLimit1 == null) {
            return -1;
        }
        return elementLimit1;
    }

    private TableViewer getViewer() {
        return (TableViewer)this.fPage.getViewer();
    }

    public void clear() {
        this.getViewer().refresh();
    }
}

