/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl;

import com.aptana.ide.search.epl.TextSearchVisitor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;

public class TextSearchVisitorWrapper {
    private MultiStatus fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
    private TextSearchRequestor requestor;
    private Pattern pattern;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private IFile fCurrentFile;
    private Matcher fMatcher;

    public TextSearchVisitorWrapper(TextSearchRequestor requestor, Pattern searchPattern) {
        this.requestor = requestor;
        this.pattern = searchPattern;
        this.fMatcher = searchPattern.pattern().length() == 0 ? null : searchPattern.matcher(new String());
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(scope.evaluateFilesInScope(this.fStatus), monitor);
    }

    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = files.length;
        this.fCurrentFile = null;
        int availableProcessors = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
        final Thread[] threads = new Thread[availableProcessors];
        Job monitorUpdateJob = new Job(SearchMessages.TextSearchVisitor_progress_updating_job){
            private int fLastNumberOfScannedFiles;
            {
                super($anonymous0);
                this.fLastNumberOfScannedFiles = 0;
            }

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    IFile file = TextSearchVisitorWrapper.this.fCurrentFile;
                    if (file != null) {
                        String fileName = file.getName();
                        Object[] args = new Object[]{fileName, new Integer(TextSearchVisitorWrapper.this.fNumberOfScannedFiles), new Integer(TextSearchVisitorWrapper.this.fNumberOfFilesToScan)};
                        TextSearchVisitorWrapper.this.fProgressMonitor.subTask(Messages.format((String)SearchMessages.TextSearchVisitor_scanning, (Object[])args));
                        int steps = TextSearchVisitorWrapper.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                        TextSearchVisitorWrapper.this.fProgressMonitor.worked(steps);
                        this.fLastNumberOfScannedFiles += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                int a = 0;
                while (a < threads.length) {
                    if (threads[a].isAlive()) {
                        threads[a].interrupt();
                    }
                    ++a;
                }
                return Status.OK_STATUS;
            }
        };
        try {
            String taskName = this.fMatcher == null ? SearchMessages.TextSearchVisitor_filesearch_task_label : Messages.format((String)SearchMessages.TextSearchVisitor_textsearch_task_label, (Object)this.fMatcher.pattern().pattern());
            this.fProgressMonitor.beginTask(taskName, this.fNumberOfFilesToScan);
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                this.requestor.beginReporting();
                final FileAccess fs = new FileAccess(files);
                int a = 0;
                while (a < availableProcessors) {
                    Thread ss;
                    threads[a] = ss = new Thread(){

                        public void run() {
                            IFile nextFile;
                            TextSearchVisitor visitor = new TextSearchVisitor(TextSearchVisitorWrapper.this.requestor, TextSearchVisitorWrapper.this.pattern, false, false);
                            visitor.setFProgressMonitor(TextSearchVisitorWrapper.this.fProgressMonitor);
                            visitor.initDocuments();
                            while ((nextFile = fs.getNextFile()) != null) {
                                visitor.processFile(nextFile);
                                if (!TextSearchVisitorWrapper.this.fProgressMonitor.isCanceled()) continue;
                                return;
                            }
                        }
                    };
                    ss.start();
                    ++a;
                }
                a = 0;
                while (a < availableProcessors) {
                    try {
                        threads[a].join();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    ++a;
                }
            }
            finally {
                monitorUpdateJob.cancel();
            }
        }
        finally {
            this.fProgressMonitor.done();
            this.requestor.endReporting();
        }
        return this.fStatus;
    }

    static class FileAccess {
        IFile[] files;
        volatile int position;

        public FileAccess(IFile[] files) {
            this.files = files;
        }

        public synchronized IFile getNextFile() {
            if (this.position < this.files.length) {
                return this.files[this.position++];
            }
            return null;
        }
    }
}

