/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.messaging;

import com.aptana.ide.core.AptanaAuthenticator;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.messaging.Message;
import com.aptana.ide.intro.preferences.FeedDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.search.UpdatePolicy;
import org.eclipse.update.search.IUpdateSiteAdapter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesReader
extends DefaultHandler {
    private List<Message> messages = new ArrayList<Message>();
    private Message currentMessage;
    private String currentSiteURL;
    private boolean inTitle;
    private boolean inLink;
    private boolean inDescription;
    private boolean inContent;
    private boolean inDate;
    private StringBuilder buffer = new StringBuilder();
    private String channelTitle;
    private static final int TIMEOUT = 10000;

    public Message[] getMessages() {
        return this.messages.toArray(new Message[this.messages.size()]);
    }

    public void clearMessages() {
        this.messages.clear();
    }

    public void loadMessages(FeedDescriptor[] feeds, IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("Loading feeds", feeds.length);
        }
        this.clearMessages();
        Authenticator.setDefault((Authenticator)new AptanaAuthenticator());
        int i = 0;
        while (i < feeds.length) {
            FeedDescriptor feedDescriptor;
            block21: {
                InputStream stream;
                block20: {
                    feedDescriptor = feeds[i];
                    String siteURL = feedDescriptor.getUrl();
                    if (monitor != null) {
                        monitor.subTask(StringUtils.format((String)"Loading messages from {0}", (String)siteURL));
                    }
                    this.currentSiteURL = siteURL;
                    stream = null;
                    try {
                        try {
                            URL url = new URL(siteURL);
                            URLConnection conn = url.openConnection();
                            conn.setConnectTimeout(10000);
                            conn.setReadTimeout(10000);
                            stream = conn.getInputStream();
                            SAXParserFactory factory = SAXParserFactory.newInstance();
                            factory.setNamespaceAware(true);
                            SAXParser saxParser = null;
                            saxParser = factory.newSAXParser();
                            saxParser.parse(stream, (DefaultHandler)this);
                            stream.close();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            break block20;
                        }
                        catch (SocketTimeoutException ste) {
                            if (monitor == null) break block20;
                            monitor.subTask(StringUtils.format((String)"Error loading messages", (String)siteURL));
                            IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)"Error loading messages due to socket timeout.  Please confirm that the siteURL is live and not password protected.", (Throwable)ste);
                            break block20;
                        }
                        catch (Exception e) {
                            IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)"Error loading message XML", (Throwable)e);
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block21;
                    }
                    catch (IOException iOException) {}
                    break block21;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            feedDescriptor.setLastPoll(new Date());
            ++i;
        }
    }

    public static Map<String, String> getUpdateSites() {
        HashMap<String, String> updateSites = new HashMap<String, String>();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] sites = config.getConfiguredSites();
            int i = 0;
            while (i < sites.length) {
                IFeatureReference[] refs = sites[i].getFeatureReferences();
                int j = 0;
                while (j < refs.length) {
                    IFeatureReference ref = refs[j];
                    IFeature feature = ref.getFeature(null);
                    IURLEntry entry = feature.getUpdateSiteEntry();
                    if (entry != null) {
                        String url = MessagesReader.getPolicyMappedURL(feature);
                        if (url == null) {
                            url = entry.getURL().toExternalForm();
                        }
                        url = MessagesReader.appendMessagesXml(url);
                        updateSites.put(url, feature.getLabel());
                    }
                    IIncludedFeatureReference[] included = feature.getIncludedFeatureReferences();
                    int x = 0;
                    while (x < included.length) {
                        IFeature includedFeature = included[x].getFeature(null);
                        IURLEntry subEntry = includedFeature.getUpdateSiteEntry();
                        if (subEntry != null) {
                            String url = MessagesReader.getPolicyMappedURL(includedFeature);
                            if (url == null) {
                                url = subEntry.getURL().toExternalForm();
                            }
                            url = MessagesReader.appendMessagesXml(url);
                            updateSites.put(url, includedFeature.getLabel());
                        }
                        ++x;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return updateSites;
    }

    private static String appendMessagesXml(String url) {
        if (url.endsWith(".xml")) {
            try {
                URL newUrl = CoreUIUtils.trimURLSegments((URL)new URL(url), (int)1);
                url = newUrl.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)StringUtils.format((String)"Unable to parse URL {0}", (String)url));
            }
        }
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        url = String.valueOf(url) + "messages.xml";
        return url;
    }

    private static String getPolicyMappedURL(IFeature feature) {
        String url = null;
        UpdatePolicy policy = new UpdatePolicy();
        URL mapURL = UpdateUtils.getUpdateMapURL();
        if (mapURL != null) {
            try {
                IUpdateSiteAdapter adapter;
                policy.load(UpdateUtils.getUpdateMapURL(), null);
                String id = feature.getVersionedIdentifier().getIdentifier();
                if (id != null && (adapter = policy.getMappedSite(id)) != null) {
                    url = adapter.getURL().toExternalForm();
                }
            }
            catch (Exception exception) {}
        }
        return url;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("item")) {
            this.currentMessage = new Message();
            this.currentMessage.setSite(this.currentSiteURL);
            String read = attributes.getValue("aptana:read");
            if (read != null && !"".equals(read)) {
                this.currentMessage.setRead(Boolean.parseBoolean(read));
            }
        } else if (this.currentMessage == null && qName.equals("title")) {
            this.buffer = new StringBuilder();
        } else if (this.currentMessage != null) {
            if (qName.equals("title")) {
                this.inTitle = true;
                this.buffer = new StringBuilder();
            } else if (qName.equals("link")) {
                this.inLink = true;
                this.buffer = new StringBuilder();
            } else if (qName.equals("description")) {
                this.inDescription = true;
                this.buffer = new StringBuilder();
            } else if (qName.equals("content:encoded")) {
                this.inContent = true;
                this.buffer = new StringBuilder();
            } else if (qName.equals("pubDate") || qName.equals("dc:date")) {
                this.inDate = true;
                this.buffer = new StringBuilder();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("item") && this.currentMessage != null) {
            if (this.currentMessage.getContent() == null && this.currentMessage.getPreview() != null) {
                this.currentMessage.setContent(this.currentMessage.getPreview());
            }
            if (this.currentMessage.getContent() != null && this.currentMessage.getTitle() != null && this.currentMessage.getId() != null && this.currentMessage.getAddress() != null && this.currentMessage.getPreview() != null && this.currentMessage.getDate() != null) {
                this.messages.add(this.currentMessage);
            } else {
                IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)StringUtils.format((String)"Unable to add message {0}", (String)this.currentMessage.getId()));
            }
            this.currentMessage = null;
        }
        if (qName.equals("title") && this.currentMessage == null) {
            this.channelTitle = this.buffer.toString();
        } else if (this.currentMessage != null) {
            if (qName.equals("title")) {
                if (this.inTitle) {
                    String messageTitle = MessagesReader.extractTitle(this.buffer.toString());
                    this.currentMessage.setTitle(messageTitle);
                    if (messageTitle.toLowerCase().startsWith("urgent:")) {
                        this.currentMessage.setUrgent(true);
                    }
                }
                this.inTitle = false;
                this.currentMessage.setChannelTitle(this.channelTitle);
            } else if (qName.equals("link")) {
                if (this.inLink) {
                    this.currentMessage.setId(this.buffer.toString());
                    this.currentMessage.setAddress(this.buffer.toString());
                }
                this.inLink = false;
            } else if (qName.equals("description")) {
                if (this.inDescription) {
                    this.currentMessage.setPreview(this.buffer.toString());
                }
                this.inDescription = false;
            } else if (qName.equals("content:encoded")) {
                if (this.inContent) {
                    this.currentMessage.setContent(this.buffer.toString());
                }
                this.inContent = false;
            } else if ((qName.equals("pubDate") || qName.equals("dc:date")) && this.inDate) {
                Date date;
                SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
                try {
                    date = df.parse(this.buffer.toString());
                }
                catch (ParseException parseException) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        date = sdf.parse(this.buffer.toString());
                    }
                    catch (ParseException parseException2) {
                        date = new Date();
                    }
                }
                this.currentMessage.setDate(date);
            }
            this.buffer = new StringBuilder();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    private static String extractTitle(String message) {
        int index = message.indexOf(10);
        return index < 0 ? message : message.substring(0, index);
    }
}

